!
! $Id: modulePakoPointing.f90,v 1.2 2005/06/22 14:46:29 ungerech Exp $
!
! <DOCUMENTATION name="modulePakoPointing">
!   <PROGRAM>
!                Pako
!   <\PROGRAM>
!   <FAMILY>
!                Observing Modes
!   </FAMILY>
!   <SIBLINGS>
!                Pointing
!   </SIBLINGS>        
!
!   Pako module for command: Pointing
!
! </DOCUMENTATION> <!-- name="modulePakoPointing" -->
!
Module modulePakoPointing
  !
  Use modulePakoMessages
  Use modulePakoGlobalParameters
  Use modulePakoLimits
  Use modulePakoXML
  Use modulePakoPlots
  Use modulePakoDisplayText
  Use modulePakoGlobalVariables
  Use modulePakoSubscanList
  Use modulePakoReceiver
  Use modulePakoBackend
  Use modulePakoSource
  Use modulePakoSwBeam
  Use modulePakoSwWobbler
  Use modulePakoSwTotalPower
!
  Implicit None
  Save
  Private
  Public :: pointing
!!$      Public :: savePointing
  Public :: startPointing
  Public :: displayPointing
  Public :: plotPointing
  !     
  ! *** Variables for pointing ***
  Include 'inc/variables/variablesPointing.inc'
  !
!!$  Real (kind=kindSingle) :: angleFactorR
!!$  Real (kind=kindDouble) :: angleFactorD
!!!   
!!!   
Contains
!!!   
!!!
  Subroutine pointing(programName,line,command,                    &
       &        error)
    !
    ! *** Arguments: ***
    Include 'inc/variables/headerForCommandHandler.inc'
    !
    ! *** standard working variables   ***
    Include 'inc/variables/standardWorkingVariables.inc'
    !
    Logical :: isConnected   = .False.
    !
    Character(len=12)  ::  commandToSave = "Pointing"
    Character(len=12)  ::  OMselected = "Pointing"
    !
    !     TBD: the following shall be replaced by a SR reading from XML:
    Include 'inc/ranges/rangesPointing.inc'
    !
    Write (6,*) " modulePako pointing ---> SR: pointing 21"
    Write (6,*) "                          "
    Write (6,*) " programName:  ->", programName(1:lenc(programName)), "<-"
    Write (6,*) " line:         ->", line(1:lenc(line)), "<-"
    Write (6,*) " command:      ->", command(1:lenc(command)), "<-"
    Write (6,*) " error:        ->", error
    !
    !**   initialize:   ***
    If (.Not.isInitialized) Then
       Include 'inc/variables/setDefaults.inc'
       isInitialized = .True.
    Endif
    !
    !**   set In-values = previous Values   ***
    If (.Not.ERROR) Then
       vars(iIn) = vars(iValue)
    End If
    !
    ! *** check N of Parameters: 0, n --> at  most n allowed  ***
    ! *** read Parameters, Options (to detect errors)         ***
    ! *** and check for validity and ranges                   ***
    Call checkNofParameters(command,                                 &
         &     0, 1,                                                       &
         &     nArguments,                                                 &
         &     errorNumber)
    ERROR = ERROR .Or. errorNumber
    If (.Not. ERROR) Then
       Include 'inc/parameters/parametersLength.inc'
       Include 'inc/options/readOptionsPointing.inc'
    End If
    !
    !**   set defaults   ***
    If (.Not. ERROR) Then
       option = 'DEFAULTS'
       Call indexCommmandOption                                      &
            &        (command,option,commandFull,optionFull,                  &
            &        commandIndex,optionIndex,iCommand,iOption,               &
            &        errorNotFound,errorNotUnique)
       setDefaults = SIC_PRESENT(iOption,0)
       If (setDefaults) Then
          Include 'inc/variables/setDefaults.inc'
       Endif
    Endif
    !
    !**   read Parameters, Options (again, after defaults!)   ***
    !**   and check for validity and ranges                   ***
    If (.Not. ERROR) Then
       Include 'inc/parameters/parametersLength.inc'
       Include 'inc/options/readOptionsPointing.inc'
    End If
    !
    ! *** check consistency and                           ***
    !**   store from In into persistent variables   ***
    If (.Not.error) Then
       errorInconsistent = .False.
       !
       Call queryReceiver("BOLOMETER", isConnected)
       If (vars(iIn)%doCalibrate .And. isConnected) Then
          Write (messageText,*)  "/CALIBRATE will not be used with BOLOMETER"
          Call PakoMessage(priorityW,severityW,command//"",messageText)
       End If
       !
       If (.Not. errorInconsistent) Then
          vars(iTemp) = vars(iIn)
       End If
    End If
    !
    ERROR = ERROR .Or. errorInconsistent
    !
    ! *** store from temporary into final variables ***
    If (.Not.ERROR) Then
       vars(iValue)  = vars(iTemp)
       GV%tRecord    = vars(iValue)%tRecord 
       Write (6,*) "       GV%tRecord = ", GV%tRecord
    End If
    !
    !**   display values  ***
    !     (Note: this is done independantly of the Error status)
    Call displayPointing
    !
    !**   set "selected" observing mode & plot  ***
    If (.Not.error) Then
       GV%observingMode = command
       Write (6,*) "        GV%observingMode ->", GV%observingMode(1:len_trim(GV%observingMode)), "<-"        
       pointingCommand = line(1:lenc(line))
       Write (6,*) "        pointingCommand ->", pointingCommand(1:len_trim(pointingCommand)), "<-"
       Call analyzePointing (errorA)
       Call listSegmentList (errorA)
       Call plotPointing (errorP)
       !
    End If
    !
    Return
  End Subroutine pointing
!!!
  Subroutine analyzePointing (errorA)
    !
    Include 'inc/variables/standardWorkingVariables.inc'
    !
    Integer                :: nScan 
    Character (len=lenCh)  :: aUnit, sUnit
    Integer                :: iSS           = 0     ! counts subcans/segment
    Integer                :: nSS           = 1
    !
    Real    :: swWobblerShift  = 0.0               !   Shift in Azimuth when Wobbler Switching
    !
    Logical :: isConnected   = .False.
    !
    errorA    = .False.
    iSS       = 0
    nScan     = 1111
    aUnit     = GV%angleUnitC                        ! 
    sUnit     = GV%speedUnitC                        ! 
    !
    Write (6,*) "   --> analyzePointing   "
    !
    swWobblerShift  = 0.0
    If (GV%switchingMode .Eq. "SWWOBBLER") Then   
       swWobblerShift = -0.5*Abs(GV%wOffset(2)-GV%wOffset(1))  
       !D           Write (6,*) "       swWobblerShift = ", swWobblerShift
    End If
    !
    segList(:) = segDefault
    !
    Call countSubscans(value=0)
    Call countSegments(value=0)
    !
    isConnected = .False.
    Call queryReceiver("BOLOMETER", isConnected)
    If (vars(iValue)%doCalibrate .And. .Not.isConnected) Then
       !
       !                                                        Cal Sky
       Call countSubscans(ii)
       Call countSegments(jj)
       Write (6,*) " Cal Sky    ii, jj ", ii, jj
       segList(ii)%newSubscan = .True.
       segList(ii)%ssNumber   =  ii
       segList(ii)%segNumber  =  1
       segList(ii)%ssType     =  ss%cs
       segList(ii)%segType    =  seg%track
       segList(ii)%angleUnit  =  aUnit
       segList(ii)%speedUnit  =  sUnit
       segList(ii)%flagOn     =  .True.
       segList(ii)%flagRef    =  .False.
       segList(ii)%pStart%x   = -vars(iValue)%length/2.0
       segList(ii)%pStart%y   =  0.0
       segList(ii)%pEnd       =  segList(ii)%pStart
       segList(ii)%systemName =  offsetSystemChoices(iHORIZONTRUE)
       segList(ii)%tSegment   =  3.0
       segList(ii)%tRecord    =  1.0
       !
       If (GV%switchingMode .Eq. "SWWOBBLER") Then   
          segList(ii)%pStart%x  = segList(ii)%pStart%x +swWobblerShift  
          segList(ii)%pEnd%x    = segList(ii)%pEnd%x   +swWobblerShift  
       End If
       !
       !                                                        Cal Cold
       Call countSubscans(ii)
       Call countSegments(jj)
       Write (6,*) " Cal Cold   ii, jj ", ii, jj
       segList(ii)            =  segList(1)
       segList(ii)%ssNumber   =  ii
       segList(ii)%segNumber  =  1
       segList(ii)%ssType     =  ss%cc
       segList(ii)%segType    =  seg%track
       !                                                        Cal Ambient
       Call countSubscans(ii)
       Call countSegments(jj)
       Write (6,*) " Cal Amb    ii, jj ", ii, jj
       segList(ii)            =  segList(1)
       segList(ii)%ssNumber   =  ii
       segList(ii)%segNumber  =  1
       segList(ii)%ssType     =  ss%ca
       segList(ii)%segType    =  seg%track
       !
    End If
    !
    !
    If (vars(iValue)%nOtf .Ge. 1) Then                           ! first OTF incr. in Az
       Call countSubscans(ii)
       Call countSegments(jj)
       Write (6,*) " 1st OTF    ii, jj ", ii, jj
       segList(ii)%newSubscan  =  .True.
       segList(ii)%scanNumber  =  nScan
       segList(ii)%ssNumber    =  ii
       segList(ii)%segNumber   =  1
       segList(ii)%ssType      =  ss%otf
       segList(ii)%segType     =  seg%linear
       segList(ii)%angleUnit   =  aUnit
       segList(ii)%speedUnit   =  sUnit
       segList(ii)%flagOn      =  .True.
       segList(ii)%flagRef     =  .False.
       segList(ii)%pStart%x    = -vars(iValue)%length/2.0
       segList(ii)%pStart%y    =  0.0
       segList(ii)%pEnd%x      =  vars(iValue)%length/2.0
       segList(ii)%pEnd%y      =  0.0
       segList(ii)%lengthOtf   =  vars(iValue)%length
       segList(ii)%systemName  =  offsetSystemChoices(iHORIZONTRUE)
       segList(ii)%altOption   =  "TOTF"
       segList(ii)%speedStart  =  vars(iValue)%length/vars(iValue)%tOtf
       segList(ii)%speedEnd    =  vars(iValue)%length/vars(iValue)%tOtf
       segList(ii)%tSegment    =  vars(iValue)%tOtf
       segList(ii)%tRecord     =  vars(iValue)%tRecord
       !
       If (GV%switchingMode .Eq. "SWWOBBLER") Then   
          segList(ii)%pStart%x  = segList(ii)%pStart%x +swWobblerShift  
          segList(ii)%pEnd%x    = segList(ii)%pEnd%x   +swWobblerShift  
       End If
       !
    End If
    !
    If (vars(iValue)%nOtf .Eq. 2) Then                               ! 2nd OTF if only 2 incr. in El.
       Call countSubscans(ii)
       Call countSegments(jj)
       Write (6,*) " 2nd OTF El ii, jj ", ii, jj
       segList(ii)             =  segList(ii-1)                     
       segList(ii)%ssNumber    =  ii
       segList(ii)%segNumber   =  1
       !
       segList(ii)%pStart%x    =  0.0
       segList(ii)%pStart%y    =  -vars(iValue)%length/2.0
       segList(ii)%pEnd%x      =  0.0
       segList(ii)%pEnd%y      =   vars(iValue)%length/2.0
       !
       If (GV%switchingMode .Eq. "SWWOBBLER") Then   
          segList(ii)%pStart%x  = segList(ii)%pStart%x +swWobblerShift  
          segList(ii)%pEnd%x    = segList(ii)%pEnd%x   +swWobblerShift  
       End If
       !
    Else If (vars(iValue)%nOtf .Ge. 2) Then
       !
       Do kk = 2, vars(iValue)%nOtf, 1
          !
          If (Mod(kk,4).Eq.1) Then                                   ! incr. in Az.
             Call countSubscans(ii)
             Call countSegments(jj)
             Write (6,*) " nth OTF    ii, jj, kk ", ii, jj, kk
             segList(ii)             =  segList(ii-1)                     
             segList(ii)%ssNumber    =  ii
             segList(ii)%segNumber   =  1
             !
             segList(ii)%pStart%x    =  -vars(iValue)%length/2.0
             segList(ii)%pStart%y    =  0.0                     
             segList(ii)%pEnd%x      =   vars(iValue)%length/2.0
             segList(ii)%pEnd%y      =  0.0                     
             !
          End If
          !
          If (Mod(kk,4).Eq.2) Then                                   ! decr. in Az.
             Call countSubscans(ii)
             Call countSegments(jj)
             Write (6,*) " nth OTF    ii, jj, kk ", ii, jj, kk
             segList(ii)             =  segList(ii-1)                 
             segList(ii)%ssNumber    =  ii
             segList(ii)%segNumber   =  1
             !
             segList(ii)%pStart%x    =   vars(iValue)%length/2.0
             segList(ii)%pStart%y    =  0.0                     
             segList(ii)%pEnd%x      =  -vars(iValue)%length/2.0
             segList(ii)%pEnd%y      =  0.0                     
             !
          End If
          !
          If (Mod(kk,4).Eq.3) Then                                   ! incr. in El.
             Call countSubscans(ii)
             Call countSegments(jj)
             segList(ii)             =  segList(ii-1)
             Write (6,*) " nth OTF    ii, jj, kk ", ii, jj, kk
             segList(ii)%ssNumber    =  ii
             segList(ii)%segNumber   =  1
             !
             segList(ii)%pStart%x    =  0.0                     
             segList(ii)%pStart%y    =  -vars(iValue)%length/2.0
             segList(ii)%pEnd%x      =  0.0                     
             segList(ii)%pEnd%y      =   vars(iValue)%length/2.0
             !
          End If
          !
          If (Mod(kk,4).Eq.0) Then                                   ! decr. in El.
             Call countSubscans(ii)
             Call countSegments(jj)
             Write (6,*) " nth OTF    ii, jj, kk ", ii, jj, kk
             segList(ii)             =  segList(ii-1)
             segList(ii)%ssNumber    =  ii
             segList(ii)%segNumber   =  1
             !
             segList(ii)%pStart%x    =  0.0                     
             segList(ii)%pStart%y    =   vars(iValue)%length/2.0
             segList(ii)%pEnd%x      =  0.0                     
             segList(ii)%pEnd%y      =  -vars(iValue)%length/2.0
             !
          End If
          !
          If (GV%switchingMode .Eq. "SWWOBBLER") Then   
             segList(ii)%pStart%x  = segList(ii)%pStart%x +swWobblerShift  
             segList(ii)%pEnd%x    = segList(ii)%pEnd%x   +swWobblerShift  
          End If
          !
       End Do
       !
    End If
    !
    Call getCountSegments(nSegments)
    !
    Return 
    !
  End Subroutine analyzePointing
!!!
  Subroutine displayPointing
    !
    Include 'inc/variables/standardWorkingVariables.inc'
    !
    Character(len=24)  :: command
    !
    Include 'inc/display/commandDisplayPointing.inc'
    !
  End Subroutine displayPointing
!!!
  Subroutine plotPointing (errorP)
    !
    !**   Variables  for Plots   ***
    Include 'inc/variables/headerForPlotMethods.inc'
    !
    !**   standard working variables   ***
    Include 'inc/variables/standardWorkingVariables.inc'
    !
    Integer :: nSegments
    !
    Real    :: swWobblerShift  = 0.0               !   Shift in Azimuth when Wobbler Switching
    !
    errorP = .False.
    !
    swWobblerShift  = 0.0
    !
    Call configurePlots
    !
    Call plotPointingStart(errorP)
    !
    Call getCountSegments(nSegments)
    !D      Write (6,*) '      number of segments: ', nSegments
    !
    Do ii = 1, nSegments, 1
       If (segList(ii)%ssType .Eq.ss%cs .And.                                                 &
            &       segList(ii)%segType.Eq.seg%track) Then
          Call plotCalSky(segList(ii)%pStart%x,segList(ii)%pStart%y,                          &
               &                    errorP,                                                               &
               &                    number=segList(ii)%ssNumber,                                          &
               &                    Type=segList(ii)%ssType)
       End If
    End Do
    !
    If (GV%switchingMode .Ne. "SWWOBBLER") Then   
       jj = 0
       Do ii = 1, nSegments, 1
          If (segList(ii)%ssType .Eq.ss%otf .And.                                             &
               segList(ii)%segType.Eq.seg%linear) Then
             jj = jj+1
             If (jj.Le.4) Then
                Call plotOtfLinear(segList(ii)%pStart%x,segList(ii)%pStart%y,                 &
                     &                    segList(ii)%pEnd%x,segList(ii)%pEnd%y,                                &
                     &                    errorP,                                                               &
                     &                    number=jj,                                                            &
                     &                    Type='pointing')
             Else
                Call plotOtfLinear(segList(ii)%pStart%x,segList(ii)%pStart%y,                 &
                     &                    segList(ii)%pEnd%x,segList(ii)%pEnd%y,                                &
                     &                    errorP,                                                               &
                     &                    Type='pointing')
             End If
          End If
       End Do
    End If
    !
    If (GV%switchingMode .Eq. "SWWOBBLER") Then   
       swWobblerShift = -0.5*Abs(GV%wOffset(2)-GV%wOffset(1))  
       !D         Write (6,*) "       swWobblerShift = ", swWobblerShift
       jj = 0
       Do ii = 1, nSegments, 1
          If (segList(ii)%ssType .Eq.ss%otf .And.                                             &
               segList(ii)%segType.Eq.seg%linear) Then
             jj = jj+1
             If (jj.Le.4) Then
                Call plotOtfLinear(segList(ii)%pStart%x,segList(ii)%pStart%y,                 &
                     &                    segList(ii)%pEnd%x,segList(ii)%pEnd%y,               &
                     &                    errorP,                                              &
                     &                    number=jj,                                           &
                     &                    Type='extra')
                Call plotOtfLinear(segList(ii)%pStart%x-swWobblerShift,segList(ii)%pStart%y,  &
                     &                    segList(ii)%pEnd%x-swWobblerShift,segList(ii)%pEnd%y,&
                     &                    errorP,                                              &
                     &                    number=jj,                                           &
                     &                    Type='pointing')
             Else
                Call plotOtfLinear(segList(ii)%pStart%x,segList(ii)%pStart%y,                 &
                     &                    segList(ii)%pEnd%x,segList(ii)%pEnd%y,               &
                     &                    errorP,                                              &
                     &                    Type='extra')
                Call plotOtfLinear(segList(ii)%pStart%x-swWobblerShift,segList(ii)%pStart%y,  &
                     &                    segList(ii)%pEnd%x-swWobblerShift,segList(ii)%pEnd%y,&
                     &                    errorP,                                              &
                     &                    Type='pointing')
             End If
          End If
       End Do
    End If
    !
    Call gr_exec(      'set character 0.6' )
    Call gr_exec(      'pen 0'             )
    !
    errorP =  errorP .Or. GR_ERROR()
    !
    If (errorP)                                                    &
         &        Call PakoMessage(priorityE,severityE,                         &
         &        'Pointing',' could not plot ')
    !
    Return
  End Subroutine plotPointing
!!!
!!$      Subroutine savePointing(programName,LINE,commandToSave,           &
!!$     &        OMselected, iUnit, ERROR)
!!$!
!!$!**   Variables   ***
!!$      Include 'inc/variables/headerForSaveMethods.inc'
!!$!
!!$      contC = contNN
!!$!
!!$      Include 'inc/Commands/saveCommand.inc'
!!$!
!!$      contC = contCC
!!$!
!!$      Include 'inc/parameters/saveLength.inc'
!!$!
!!$      Include 'inc/options/saveCalibrate.inc'
!!$      Include 'inc/options/saveFeBe.inc'
!!$!TBD:      Include 'inc/options/saveMore.inc'
!!$      Include 'inc/options/saveNotf.inc'
!!$      contC = contCN
!!$      Include 'inc/options/saveTotf.inc'
!!$!TBD:      Include 'inc/options/saveTrecord.inc'
!!$!TBD:      Include 'inc/options/saveUpdate.inc'
!!$!
!!$      Write (iUnit,*) "!"
!!$!
!!$      Return
!!$      End Subroutine savePointing
!!$!!!
!!!
!!!
  Subroutine startPointing(programName,LINE,commandToSave,         &
       &        iUnit, ERROR)
    !
    !**   Variables   ***
    Include 'inc/variables/headerForSaveMethods.inc'
    !
    Integer            :: ii
    Character (len=24) :: valueC
    Character (len=48) :: valueComment
    Logical            :: errorXML
    !
    !D      Write (6,*) "   --> modulePakoPointing: SR startPointing "
    !
    ERROR = .False.
    !
    Call pakoXMLsetOutputUnit(iunit=iunit)
    Call pakoXMLsetIndent(iIndent=2)
    !
    Include 'inc/startXML/pointingHead.inc'
    !
    Call writeXMLset(programName,LINE,commandToSave,                  &
         &           iUnit, ERROR)
    !
    Call pakoXMLwriteStartElement("RESOURCE","pakoScript",             &
         &                         comment="save from pako",                 &
         &                         error=errorXML)
    Call pakoXMLwriteStartElement("DESCRIPTION",                       &
         &                         doCdata=.True.,                           &
         &                         error=errorXML)
    !
!!$    Call pakoSaveSet(programName,LINE,commandToSave,                  &
!!$         &        OMselected, iUnit, ERROR)                                 
!!$    Call saveReceiver(programName,LINE,commandToSave,                  &
!!$         &        OMselected, iUnit, ERROR)
!!$    Call saveBackend(programName,LINE,commandToSave,                   &
!!$         &        OMselected, iUnit, ERROR)
!!$    Call saveSwitching(programName,LINE,commandToSave,                 &
!!$         &        OMselected, iUnit, ERROR)
!!$    Call saveSource(programName,LINE,commandToSave,                    &
!!$         &        OMselected, iUnit, ERROR)
!!$    Call saveOffsets(programName,LINE,commandToSave,                   &
!!$         &        OMselected, iUnit, ERROR)
!!$    Call savePointing(programName,LINE,commandToSave,                  &
!!$         &        OMselected, iUnit, ERROR)
!!$    !
    Call pakoXMLwriteEndElement("DESCRIPTION",                         &
         &                         doCdata=.True.,                           &
         &                         error=errorXML)
    Call pakoXMLwriteEndElement  ("RESOURCE","pakoScript",             &
         &                         space="after",                            &
         &                         error=errorXML)
    !
    Call writeXMLreceiver(programName,LINE,commandToSave,              &
         &        iUnit, ERROR)
    !
    Call writeXMLbackend(programName,LINE,commandToSave,               &
         &        iUnit, ERROR)
    !
    Include 'inc/startXML/switchingMode.inc'
    !
    Call writeXMLsource(programName,LINE,commandToSave,                &
         &        iUnit, ERROR)
    !
    Include 'inc/startXML/generalScanHead.inc'
    !
    Call writeXMLsubscanList(programName,LINE,commandToSave,         &
         &        iUnit, ERROR)
    !   
    Include 'inc/startXML/generalTail.inc'
    !
    Return
  End Subroutine startPointing
!!!
!!!
End Module modulePakoPointing
!!!
