!
!     $Id: variablesReceiver.inc,v 1.1 2005/03/23 14:25:45 pety Exp $
!
! *** variables for command Receiver
!
Include 'inc/variables/headerForVariables.inc'
!
Type :: receiverFrequency
   Character(len=lenCh)     :: name           =  GPnone
   Character(len=lenCh)     :: kind           =  GPnone
   Character(len=lenCh)     :: unit           =  GPnone
   Character(len=lenCh)     :: doppler        =  GPnone         
   Real(kind=kindDouble)    :: value          =  GPnoneD
End Type receiverFrequency
!
Type :: gainRatio
   Character(len=lenCh)     :: name           =  GPnone
   Character(len=lenCh)     :: kind           =  GPnone
   Character(len=lenCh)     :: unit           =  GPnone
   Real(kind=kindSingle)    :: value          =  GPnoneR
   Real(kind=kindSingle)    :: db             =  -3.3e-33
End Type gainRatio
!
Type :: varReceiver
   !
   Character(len=lenCh)     :: name           =  GPnone
   Logical                  :: isConnected    =  GPnoneL
   Logical                  :: gunnOn         =  GPnoneL
   !
   ! ** bolometer parameters
   !    TBD: eliminate duplication of information for bolometer
   !        %nChannels %channel
   Integer                  :: nChannels      =  GPnoneI  !  number of bolometer channels
   Character(len=lenCh)     :: bolometerName  =  GPnone   !  name of bolometer
   Real(kind=kindSingle)    :: gainBolometer  =  GPnoneR  !  bolometer gain
   Integer                  :: channel        =  GPnoneI  !  bolometer channel selected
   !
   Character(len=lenCh)     :: lineName       =  GPnone         
   Type(receiverFrequency)  :: frequency
   Type(receiverFrequency)  :: offset
   Character(len=lenCh)     :: sideBand       =  GPnone         
   !
   Character(len=lenCh)     :: width          =  GPnone   !  NARROW / WIDE
   !
   Type(gainRatio)          :: gainImage
   !
   Real(kind=kindSingle)    :: tempCold       =  GPnoneR
   Real(kind=kindSingle)    :: tempAmbient    =  GPnoneR
   Real(kind=kindSingle)    :: effForward     =  GPnoneR
   Real(kind=kindSingle)    :: effBeam        =  GPnoneR
   Character(len=lenCh)     :: scale          =  GPnone
   !
   Integer                  :: iPixel         =  GPnoneI  !  MB pixel selected
   !
   ! ** additional variables, fixed or not directly set by Observer
   !
   Integer                  :: nPixels        =  GPnoneI  !  number of MB pixels
   !
   Real(kind=kindDouble)    :: centerIF       =  GPnoneD  ! 
   Real(kind=kindDouble)    :: bandWidth      =  GPnoneD  !  [GHz]
   !
   Integer                  :: disBoxInput    =  GPnoneI  !  distribution box input
   Real(kind=kindDouble)    :: IF2            =  GPnoneD  !  2nd IF
   Logical                  :: isFlippingIF2  =  GPnoneL  !  is flipping 2nd down converter
   !
   Character(len=lenCh)     :: polarization   =  GPnone   !  H/V in Nasmyth system
   !
   Logical                  :: useSpecialLO   =  GPnoneL  !  special LO mode (below 80 GHz)
   !
End Type varReceiver
!
! *** 
!
Integer, Parameter :: nDimReceivers = 12
!
Type (varReceiver), Dimension(nDimValues,nDimReceivers) :: vars
Type (varReceiver),           Dimension(nDimReceivers)  :: listRX
Character(len=lenLineDouble), Dimension(nDimReceivers)  :: receiverCommand = GPnone
!
! *
Integer, Parameter :: nCombos =  7
!
Integer, Dimension(nDimReceivers,nCombos)               :: iCombos, iCombosN
!
! *
Integer, Parameter                   :: nDimGainBoloChoices  = 7
Real, Dimension(nDimGainBoloChoices) :: gainBolometerChoices
!
! *
Logical                :: isInitialized  =  .False.
Logical                :: catalogOpen    =  .False.
!
! *** "helper" variables: (some are obsolete?)
!
Character(len=lenVar)  :: cFile = GPnone  ! catalog file name
!
Character(len=lenCh)   :: receiverSelected = GPnone
Character(len=lenCh)   :: name  = GPnone
Integer                :: lname = 1
!
Integer                :: larg  = 1
Integer                :: lenc  = 1
!
Logical                :: found =.False.
Integer                :: npar  = 1
Integer                :: npar1 = 1
Integer                :: ier   = 1
Integer                :: iRec  = 1 
!
Integer, Dimension(nDimReceivers) :: iIsConnected
Integer, Dimension(nDimReceivers) :: iComboCheck








