!
! $Id: parametersReceiver.inc,v 1.1 2005/03/23 14:25:51 pety Exp $
!
catalogOpen = .False.
!
error  = .False.
errorL = .False.
errorC = .False.
errorR = .False.
!
! *** RECEIVER NAME
!
iOption   = 0
iArgument = 1
!
If (SIC_PRESENT(iOption,iArgument)) Then
   Call SIC_CH(LINE,iOption,iArgument,                           &
        &        cInput,lengthInput,.True.,errorC)
Else
   errorL = .True.
   messageText =                                                 &
        &        "no receiver name specified"
   Call PakoMessage(priorityI,severityI,command,messageText)
End If
!
If (errorC) Then
   messageText =                                                 &
        &     "receiver name invalid"
   Call PakoMessage(priorityE,severityE,command,messageText)
End If
!
ERROR = ERROR .Or. errorC
!
! *** Check against valid receiver names
!
If (SIC_PRESENT(iOption,iArgument) .And. .Not. error) Then
   !
   Call pakoUmatchKey (                                            &
        &              keys=receiverChoices,                       &
        &              key=cInput,                                 &
        &              command='RECEIVER',                         &
        &              howto='Start Upper',                        &
        &              iMatch=iMatch,                              &
        &              nMatch=nMatch,                              &
        &              error=errorC,                               &
        &              errorCode=errorCode                         &
        &             )
   !
   ERROR = ERROR .Or. errorC
   !
   If (.Not. ERROR) Then
      iRec                       = iMatch
      receiverSelected           = receiverChoices(iMatch)
      vars(iIn,iRec)%isConnected = .True.
      vars(iIn,iRec)%name        = receiverChoices(iMatch)
   End If
   !
   l = lenc(receiverSelected)
   !D   Write (6,*) "   iRec:       ",                                &
   !D        &                  iRec
   !D   Write (6,*) "   receiverSelected ->",                         &
   !D        &                  receiverSelected(1:l),"<-"
   !D   Write (6,*) "   vars(iIn,iRec)%name ->",                      &
   !D        &                  vars(iIn,iRec)%name(1:l),"<-"
   !
End If
!
! *** Read parameters for BOLOmeter
!
If (iRec .Eq. iBOLO) Then
   !
   If (SIC_NARG(0).Gt.2.) Then
      !
      ! * parameters should be in command line
      messageText =                                              &
           &      " reading from command line "
      Call PakoMessage(priorityI,severityI,command,messageText)
      !
      ii = Index(line,'/')
      If (ii.Eq.0) ii = LENC(line)+1
      cInputLong  = line(14:ii-1)                   ! skip language, command, and options
      lengthInput = LENC(cInputLong)
      Call SIC_BLANC(cInputLong,lengthInput)
      Call SIC_UPPER(cInputLong)
      !
      nPar = 1
      lPar = 12
      Call SIC_NEXT (cInputLong(nPar:),cPar,lPar,nPar)     ! skip receiver name
      Call SIC_NEXT (cInputLong(nPar:),cPar,lPar,nPar)     ! get  bolometer name
      errorNotFound = .False.
      !
   End If
   !
   error = error .Or. errorNotfound
   !
   If (.Not. error .And. SIC_NARG(0).Ge.2.) Then
      !
      !D            Write (6,*) "    lengthInput:        ",lengthInput
      !D            Write (6,*) "    cInputLong        ->",cInputLong(1:lengthInput),"<-"
      !D            Write (6,*) "    nPar:               ",nPar
      !D            Write (6,*) "    lPar:               ",lPar
      !D            Write (6,*) "    cPar              ->",cPar(1:lenc(cPar)),"<-"
      !D            Write (6,*) "    cInputLong(nPar:) ->",cInputLong(nPar:lengthInput),"<-"!
      !
      ! TBD: nChannels form table
      ! 
      If (lPar.Gt.0) Then
         If (cpar.Eq."117") Then
            vars(iIn,iRec)%bolometerName = "117"
            vars(iIn,iRec)%nChannels     =  117
         Else If (cpar.Eq."37") Then 
            vars(iIn,iRec)%bolometerName = "37"
            vars(iIn,iRec)%nChannels     =  37
         Else
            ! TBD:            error message
            errorC = .True.
         End If
      Else
         errorC = .True.
      End If
      !
   End If
   !
   error = error .Or. errorC
   !
   If (.Not. error .And. SIC_NARG(0).Ge.2.) Then
      ! ***  bolometer gain
      !
      errorR = .False.
      !
      Call SIC_NEXT (cInputLong(nPar:),cPar,lPar,nPar)     ! get gain
      !
      If (lPar.Gt.0) Then
         Read(cPar(1:lPar),'(F20.0)',iostat=ioerr) rInput
      End If
      !
      If (lPar.Gt.0 .And. ioerr.Eq.0) Then  
         !
         Call pakoUmatchReal(gainBolometerChoices,rInput,0.1,   &
              &    command//" gainBolo ","DELTA",iMatch,nMatch,errorR,errorCode)
         If (.Not. errorR) Then
            vars(iIn,iRec)%gainBolometer = rInput
         End If
      Else
         errorR = .True.
      End If
      !
   End If
   !
   error = error .Or. errorR
   !
   If (.Not. error .And. SIC_NARG(0).Ge.4.) Then
      ! ***  bolometer channel
      !
      errorI = .False.
      !
      Call SIC_NEXT (cInputLong(nPar:),cPar,lPar,nPar)     ! get channel
      !
      If (lPar.Gt.0) Then
         Read(cPar(1:lPar),'(I10)',iostat=ioerr) iInput
      End If
      !
      !D          Write (6,*) " number of channels:  ", vars(iIn,iRec)%nChannels
      !
      If (iInput.LT.1 .Or. iInput.GT.vars(iIn,iRec)%nChannels) Then
         errorI = .True.
         Write (messageText, *) ' value ', iInput, 'not valid. ',           &
              &  ' must be between 1 and ', vars(iIn,iRec)%nChannels
         Call PakoMessage(priorityE,severityE,command//"channel",messageText)
      End If
      !
      If (lPar.Gt.0 .And. ioerr.Eq.0 .And. .Not. errorR) Then  
         vars(iIn,iRec)%channel = iInput
      Else
         errorI = .True.
      End If
      !
   End If
   !
   error = error .Or. errorI
   !
   ! *** Read parameters for heterodyne receivers (not BOLOmeter)
Else
   !
   ! *** line name
   !
   If (.Not. error) Then

      iOption   = 0
      iArgument = 2
      If (SIC_PRESENT(iOption,iArgument)) Then
         Call SIC_CH(LINE,iOption,iArgument,                           &
              &         cInput,lengthInput,.True.,errorC)
         cInputUpper = cInput
         Call SIC_UPPER(cInputUpper)
      Else
         errorL = .True.
         messageText =                                                 &
              &        "no line name specified"
         Call PakoMessage(priorityI,severityI,command,messageText)
      End If
      !
      errorC = errorC .Or. lengthInput.Eq.0
      !
      If (errorC) Then
         messageText =                                                &
              &     "line name invalid"
         Call PakoMessage(priorityE,severityE,command,messageText)
      End If
      !
      If (SIC_PRESENT(iOption,iArgument)                              &
           &       .And. .Not. errorC) Then
         vars(iIn,iRec)%lineName = cInputUpper(1:lengthInput)
         messageText =                                                &
              &        receiverSelected(1:lenc(receiverSelected))//   &
              &        " "//                                          &
              &        vars(iIn,iRec)%lineName(1:lengthInput)
         Call PakoMessage(priorityI,severityI,command,messageText)
      End If
      !
   End If
   !
   error = error .Or. errorC
   !
   If (.Not. error) Then
      !
      If (SIC_NARG(0).Eq.2.) Then
         ! *** parameters should be in line catalog
         !
         messageText =                                              &
              &      " try line catalog: "
         !TBD:     &      " try line catalog: "//catalogList%line(1)(1:20)
         Call PakoMessage(priorityI,severityI,command,messageText)
         !
         cFile = 'none'
         !TBD            cFile = catalogList%line(1)
         !
         If (LENC(cFile).Eq.0) Then
            errorNotFound = .True.
            messageText =                                           &
                 &        "no line catalog specified"
            Call PakoMessage(priorityE,severityE,command,messageText)
         Else
            Close(UNIT=10)
            Open(unit=10, action='read', file=cFile(1:lenc(cFile)),    &
                 &                 status='old', iostat=ier)
            If (ier .Gt. 0) Then
               errorNotFound = .True.
               messageText =                                           &
                    &           "could not open line catalog: "
               !TBD     &           "could not open line catalog: "//cFile(1:lenc(cFile))
               Call PakoMessage(priorityE,severityE,command,messageText)
            Else
               catalogOpen = .True.
               found = .False.
               ioerr = 0
               !
               Do While (.Not. found .And. ioerr.Eq.0)
                  Read(10,'(Q,A)',iostat=ioerr) lengthInput, cInputLong
                  !
                  !        ignore empty lines & comments 
                  If (lengthInput.Gt.0 .And. cInputLong(1:1).Ne.'!') Then
                     Call SIC_BLANC(cInputLong,lengthInput)
                     Call SIC_UPPER(cInputLong)
                     nPar = 1
                     lPar = 12
                     Call SIC_NEXT (cInputLong(nPar:),cPar,lPar,nPar)     ! get line name
                     !
                     If (lPar.Ne.0) Then
                        lname = lenc(vars(iIn,iRec)%lineName)
                        name  = vars(iIn,iRec)%lineName(1:lname)
                        Call CHECKLINE(name,lname,cPar,lPar,found)
                     End If
                  Endif
               Enddo
               Close(UNIT=10)
               !
               If (found) Then
                  errorNotFound = .False.
               Else
                  errorNotFound = .True.
                  messageText =                                                 &
                       &              "line not found in catalog: "//cFile(1:lenc(cFile))
                  Call PakoMessage(priorityE,severityE,command,messageText)
               End If
               !
            End If
         End If
         !
      Else If (SIC_NARG(0).Gt.2.) Then
         ! *** parameters should be in command line
         !
         !D         Write (6,*) " use command line: ",line(1:lenc(line))
         messageText =                                              &
              &      " use command line: "
         Call PakoMessage(priorityI,severityI,command,messageText)
         !
         ii = Index(line,'/')
         If (ii.Eq.0) ii = LENC(line)+1
         cInputLong  = line(14:ii-1)                   ! skip language, command, and options
         lengthInput = LENC(cInputLong)
         Call SIC_BLANC(cInputLong,lengthInput)
         Call SIC_UPPER(cInputLong)
         !
         nPar = 1
         lPar = 12
         Call SIC_NEXT (cInputLong(nPar:),cPar,lPar,nPar)     ! skip receiver name
         Call SIC_NEXT (cInputLong(nPar:),cPar,lPar,nPar)     ! get  line name
         errorNotFound = .False.
         !
      End If
      !
      error = error .Or. errorNotfound
      !
      If (.Not. error .And. SIC_NARG(0).Ge.2.) Then
         !
         !D            Write (6,*) "    lengthInput:        ",lengthInput
         !D            Write (6,*) "    cInputLong        ->",cInputLong(1:lengthInput),"<-"
         !D            Write (6,*) "    nPar:               ",nPar
         !D            Write (6,*) "    lPar:               ",lPar
         !D            Write (6,*) "    cPar              ->",cPar(1:lenc(cPar)),"<-"
         !D            Write (6,*) "    cInputLong(nPar:) ->",cInputLong(nPar:lengthInput),"<-"!
      End If
      !
   End If
   !
   If (.Not. error .And. SIC_NARG(0).Ge.2.) Then
      ! ***  frequency
      !
      errorR = .False.
      !
      Call SIC_NEXT (cInputLong(nPar:),cPar,lPar,nPar)     ! get frequency
      !
      If (lPar.Gt.0) Then
         Read(cPar(1:lPar),'(F20.0)',iostat=ioerr) dInput
      End If
      !
      If (lPar.Gt.0 .And. ioerr.Eq.0) Then  
         Call checkR8co(command,option,dInput,             &
              &               vars(:,iRec)%frequency%value,                     &
              &               errorR)
      Else
         errorR = .True.
      End If
      !
      ! NOTE:
      ! if the frequency is below 80 GHz for the 3mm RXs,
      ! the logical flag %useSpecialLO is set to indicate
      ! that special LO hardware and caclulations ae used
      ! TBD:
      ! should handle %frequency%unit, for now assumed to be GHz
      !
      If (.Not. errorR) Then
         If ( iRec.Eq.iA100 .Or. iRec.Eq.iB100 ) Then
            If ( vars(iIn,iRec)%frequency%value.LT.80.0D0 ) Then
               vars(iIn,iRec)%useSpecialLO = .True.
            Else
               vars(iIn,iRec)%useSpecialLO = .False.
            End If
         End If
      End If
      !
   End If
   !
   error = error .Or. errorR
   !
   If (.Not. error .And. SIC_NARG(0).Ge.2.) Then
      ! ***  sideband
      !
      errorC = .False.
      Call SIC_NEXT (cInputLong(nPar:),cPar,lPar,nPar)     ! get sideband
      !
      If (lPar.Gt.0) Then
         If (cpar.Eq."LSB" .Or. cpar(1:1).Eq."L") Then
            vars(iIn,iRec)%sideBand="LSB"
         Else If (cpar.Eq."USB" .Or. cpar(1:1).Eq."U") Then 
            vars(iIn,iRec)%sideBand="USB"
         Else
            errorC = .True.
         End If
      Else
         errorC = .True.
      End If
      !
      If (errorC) Then
         messageText =                                           &
              &        "sideband not valid"
         Call PakoMessage(priorityE,severityE,command,messageText)
      End If
      !
      error = error .Or. errorC
      !
   End If
   !
End If  !  *** end if not bolometer
!





