subroutine run_sas(line,comm,error)
  use classcore_interfaces
  use class_addons
  !---------------------------------------------------------------------
  ! @ no-interface (because of module problems)
  ! Support routine for LAS\ language
  !---------------------------------------------------------------------
  character(len=*), intent(in)  :: line   ! Command line
  character(len=*), intent(in)  :: comm   ! Command name
  logical,          intent(out) :: error  ! Error status
  !
  call sub_sas(line,comm,error,mem_user(ip_user))
end subroutine run_sas
!
subroutine run_ana(line,comm,error)
  use class_addons
  !---------------------------------------------------------------------
  ! @ no-interface (because of module problems)
  ! Support routine for ANALYSE\ language
  !---------------------------------------------------------------------
  character(len=*), intent(inout) :: line   ! Command line
  character(len=*), intent(in)    :: comm   ! Command name
  logical,          intent(out)   :: error  ! Error status
  !
  call sub_ana(line,comm,error,mem_user(ip_user))
end subroutine run_ana
!
subroutine run_fit(line,comm,error)
  use class_addons
  !---------------------------------------------------------------------
  ! @ no-interface (because of module problems)
  ! Support routine for FIT\ language
  !---------------------------------------------------------------------
  character(len=*), intent(in)  :: line   ! Command line
  character(len=*), intent(in)  :: comm   ! Command name
  logical,          intent(out) :: error  ! Error status
  !
  call sub_fit(line,comm,error,mem_user(ip_user))
end subroutine run_fit
!
subroutine run_dec(line,comm,error)
  use class_addons
  !---------------------------------------------------------------------
  ! @ no-interface (because of module problems)
  ! Support routine for DSB2SSB\ language
  !---------------------------------------------------------------------
  character(len=*), intent(in)  :: line   ! Command line
  character(len=*), intent(in)  :: comm   ! Command name
  logical,          intent(out) :: error  ! Error status
  !
  call sub_dec(line,comm,error,mem_user(ip_user))
end subroutine run_dec
!
subroutine run_exp(line,comm,error)
  use class_addons
  !---------------------------------------------------------------------
  ! @ no-interface (because of module problems)
  ! Support routine for EXPERIMENTAL\ language
  !---------------------------------------------------------------------
  character(len=*), intent(in)  :: line   ! Command line
  character(len=*), intent(in)  :: comm   ! Command name
  logical,          intent(out) :: error  ! Error status
  !
  call sub_exp(line,comm,error,mem_user(ip_user))
end subroutine run_exp
!
subroutine sub_sas(line,comm,error,user_function)
  use gbl_constant
  use gbl_message
  use gkernel_interfaces
  use classcore_interfaces
  use class_data
  use class_setup
  !----------------------------------------------------------------------
  ! @ no-interface (because of argument type mismatch)
  ! CLASS Main routine for language LAS\
  ! Call appropriate subroutine according to COMM
  !----------------------------------------------------------------------
  character(len=*), intent(in)  :: line           ! Command line
  character(len=*), intent(in)  :: comm           ! Command name
  logical,          intent(out) :: error          ! Error status
  logical,          external    :: user_function  !
  ! Local
  character(len=*), parameter :: rname='LAS'
  integer(kind=4) :: i
  integer(kind=4), save :: icall=0
  !
  if (icall.ne.0) then
     Print *,'Re-entrant call to RUN_LAS ',comm
     read(5,*) i
  endif
  icall = icall+1
  !
  call class_message(seve%c,rname,line)
  !
  error = .false.
  if (r%is_otf) then
    select case (comm)
    case ('COPY')
      call class_copy(line,error,user_function)
    case ('FILE')
      call class_file(line,error)
    case ('FIND')
      call find(line,error)
    case ('GET')
      call get(line,error,user_function)
    case ('LIST')
      call class_list(line,error)
    case ('SET')
      call class_set_command(line,error)
    case ('SHOW')
      call class_show_comm(line,error)
    case ('WRITE')
      call class_write_comm(line,error,user_function)
    case default
      call class_message(seve%e,rname,'Command forbidden on OTF data')
      call class_message(seve%e,rname,'Use WRITE to convert this data into spectra')
      error = .true.
    end select
    icall = icall-1
    return
  endif
  !
  select case (comm)
  case ('ACCUMULATE')
    call class_accumulate(line,error,user_function)
  case ('ASSOCIATE')
    call class_associate(line,error)
  case ('AVERAGE')
    call class_average(line,error,user_function)
  case ('BASE')
    call baseline (line,error,user_function)
  case ('BOX')
    call class_box(line,error)
  case ('CATALOG')
    call class_catalog(line,error)
  case ('CONSISTENCY')
    call index_consistency_check(line,error,user_function)
  case ('COPY')
    call class_copy(line,error,user_function)
  case ('DROP')
    call class_drop(line,error)
  case ('DUMP')
    call class_dump(line,error)
  case ('EXTRACT')
    call extract(line,error,user_function)
  case ('FILE')
    call class_file(line,error)
  case ('FIND')
    call find(line,error)
  case ('FITS')
    call fits_class(line,error,user_function)
  case ('FOLD')
    call class_fold(line,error,user_function)
  case ('GET')
    call get(line,error,user_function)
  case ('HEADER')
    call class_header(error)
  case ('IGNORE')
    call ignore(line,error)
  case ('LIST')
    call class_list(line,error)
  case ('LOAD')
    call load_2d(line,error,user_function)
  case ('MERGE')
    call merge(error,user_function)
  case ('MODIFY')
    call modify(line,error)
  case ('MULTIPLY')
    call multi(line,error)
  case ('NEW_DATA')
    call new_data(line,error)
  case ('PLOT')
    call class_plot(line,error)
  case ('SAVE')
    call class_save(line,error)
  case ('SET')
    call class_set_command(line,error)
  case ('SHOW')
    call class_show_comm(line,error)
  case ('SPECTRUM')
    call class_spectrum(line,error)
  case ('STITCH')
    call class_stitch(line,error,user_function)
  case ('SWAP')
    call swaprt(comm,error,user_function)
  case ('TAG')
    call tagout(line,error)
  case ('TITLE')
    call class_title(line,error)
  case ('UPDATE')
    ! Do not try to write it in case of error !...
    call class_update_comm(error,user_function)
  case ('WRITE')
    call class_write_comm(line,error,user_function)
  case default
    call class_message(seve%e,rname,'You are using an undocumented, unsupported feature')
    call class_message(seve%e,rname,trim(comm)//' not yet implemented')
    call class_message(seve%e,rname,'Command line: '//line)
    error = .true.
  end select
  icall = icall-1
end subroutine sub_sas
!
subroutine sub_ana(line,comm,error,user_function)
  use gbl_message
  use classcore_interfaces
  use class_data
  !----------------------------------------------------------------------
  ! @ no-interface (because of argument type mismatch)
  ! CLASS Main routine for language ANALYSE\
  ! Call appropriate subroutine according to COMM
  !----------------------------------------------------------------------
  character(len=*), intent(inout) :: line           ! Command line (inout because of command DRAW)
  character(len=*), intent(in)    :: comm           ! Command name
  logical,          intent(out)   :: error          ! Error status
  logical,          external      :: user_function  !
  ! Local
  character(len=*), parameter :: rname='ANALYSE'
  character(len=message_length) :: mess
  integer(kind=4) :: i
  integer(kind=4), save :: icall=0
  !
  if (icall.ne.0) then
     Print *,'Re-entrant call to RUN_ANA ',comm
     read(5,*) i
  endif
  !
  call class_message(seve%c,rname,line)
  !
  if (r%is_otf) then
     call class_message(seve%e,rname,'Command forbidden on OTF data')
     call class_message(seve%e,rname,'Use WRITE to convert this data into spectra')
     error = .true.
     return
  endif
  icall = icall+1
  !
  select case (comm)
  case ('COMMENT')
    call class_comment(line,error)
  case ('DIVIDE')
    call class_divide(line,error)
  case ('DRAW')
    call class_draw(line,error)
  case ('FILL')
    call class_fill(line,error,user_function)
  case ('FFT')
    call class_fft(line,error,user_function)
  case ('GREG')
    call class_greg(line,error,user_function)
  case ('LMV')
    call class_lmv(line,error,user_function)
  case ('MAP')
    call class_cells(line,error,user_function)
  case ('MEMORIZE')
    call memorize(line,error)
  case ('MODEL')
    call model (line,error,user_function)
  case ('NOISE')
    call class_noise(line,error,user_function)
  case ('POPUP')
    call popup (line,error,user_function)
  case ('PRINT')
    call class_print (line,error)
  case ('RESAMPLE')
    call class_resample (line,error,user_function)
  case ('RETRIEVE')
    call retrieve(line,error,user_function)
  case ('SMOOTH')
    call smooth(line,error,user_function)
  case ('STAMP')
    call stamp(line,error,user_function)
  case ('STRIP')
    call class_strip(line,error,user_function)
  case ('TABLE')
    call class_table(line,error,user_function)
  case ('REDUCE')
    call class_message(seve%e,rname,'REDUCE not yet implemented')
    error = .true.
    ! if (r%head%gen%kind.eq.kind_sky) then
    !   call redsky(line,error)
    ! else
    !   call class_message(seve%w,'REDUCE','Only valid for skydips')
    ! endif
  case default
    mess = 'ANALYSE'//char(92)//comm//' not yet implemented'
    call class_message(seve%i,rname,mess)
    error = .true.
  end select
  icall = icall-1
end subroutine sub_ana
!
subroutine sub_fit(line,comm,error,user_function)
  use gbl_constant
  use gbl_message
  use gkernel_interfaces
  use classcore_interfaces
  use class_data
  use class_setup
  !----------------------------------------------------------------------
  ! @ no-interface (because of argument type mismatch)
  ! CLASS Main routine for language FIT\
  !   Call appropriate subroutine according to COMM
  !----------------------------------------------------------------------
  character(len=*), intent(in)  :: line           ! Command line
  character(len=*), intent(in)  :: comm           ! Command name
  logical,          intent(out) :: error          ! Error status
  logical,          external    :: user_function  !
  ! Local
  character(len=*), parameter :: rname='FIT'
  character(len=message_length) :: mess
  integer(kind=4) :: i
  integer(kind=4), save :: icall=0
  !
  if (icall.ne.0) then
     Print *,'Re-entrant call to RUN_FIT ',comm
     read(5,*) i
  endif
  !
  call class_message(seve%c,rname,line)
  !
  if (r%is_otf) then
     call class_message(seve%e,rname,'Command forbidden on OTF data')
     call class_message(seve%e,rname,'Use WRITE to convert this data into spectra')
     error = .true.
     return
  endif
  icall = icall+1
  !
  select case (comm)
  case ('DISPLAY')
    call display(line,set,r,error)
  case ('ITERATE')
    call iterate_fit(line,set,r,error)
  case ('KEEP')
    call keepfi(r,error)
  case ('LINES')
    call fitlines(line,set,error)
  case ('METHOD')
    call class_method(line,set,error)
  case ('MINIMIZE')
    call minimize(line,set,r,error)
  case ('RESIDUAL')
    call residu_comm(line,set,r,user_function,error)
  case ('RESULT')
    call result_comm(line,set,r,user_function,error)
  case ('VISUALIZE')
    call plotfit(line,set,r,error)
  case default
    mess = 'FIT'//char(92)//comm//' not yet implemented'
    call class_message(seve%i,rname,mess)
    error = .true.
  end select
  icall = icall-1
end subroutine sub_fit
!
subroutine sub_dec(line,comm,error,user_function)
  use gbl_constant
  use gbl_message
  use classcore_interfaces
  use class_data
  !----------------------------------------------------------------------
  ! @ no-interface (because of argument type mismatch)
  ! CLASS Main routine for language DSB2SSB\
  !  Call appropriate subroutine according to COMM
  !----------------------------------------------------------------------
  character(len=*), intent(in)  :: line           ! Command line
  character(len=*), intent(in)  :: comm           ! Command name
  logical,          intent(out) :: error          ! Error status
  logical,          external    :: user_function  !
  ! Local
  character(len=*), parameter :: rname='DSB2SSB'
  character(len=message_length) :: mess
  integer(kind=4) :: i
  integer(kind=4), save :: icall=0
  !
  if (icall.ne.0) then
     Print *,'Re-entrant call to RUN_DECONV ',comm
     read(5,*) i
  endif
  !
  call class_message(seve%c,rname,line)
  !
  if (r%is_otf) then
     call class_message(seve%e,rname,'Command forbidden on OTF data')
     call class_message(seve%e,rname,'Use WRITE to convert this data into spectra')
     error = .true.
     return
  endif
  icall = icall+1
  !
  select case (comm)
  case ('DECONVOLVE')
    call deconv(line,error,user_function)
  case ('INITIALIZE')
    call deconv_init(line,error,user_function)
  case default
    mess = rname//char(92)//comm//' not yet implemented'
    call class_message(seve%i,rname,mess)
    error = .true.
  end select
  icall = icall-1
end subroutine sub_dec
!
subroutine sub_exp(line,comm,error,user_function)
  use gbl_constant
  use gbl_message
  use classcore_interfaces
  use class_data
  !----------------------------------------------------------------------
  ! @ no-interface (because of argument type mismatch)
  ! CLASS Main routine for language EXPERIMENTAL\
  !  Call appropriate subroutine according to COMM
  !----------------------------------------------------------------------
  character(len=*), intent(in)  :: line           ! Command line
  character(len=*), intent(in)  :: comm           ! Command name
  logical,          intent(out) :: error          ! Error status
  logical,          external    :: user_function  !
  ! Local
  character(len=*), parameter :: rname='EXPERIMENTAL'
  character(len=message_length) :: mess
  integer(kind=4) :: i
  integer(kind=4), save :: icall=0
  !
  if (icall.ne.0) then
     Print *,'Re-entrant call to RUN_EXPERIMENTAL ',comm
     read(5,*) i
  endif
  !
  call class_message(seve%c,rname,line)
  !
  if (r%is_otf) then
     call class_message(seve%e,rname,'Command forbidden on OTF data')
     call class_message(seve%e,rname,'Use WRITE to convert this data into spectra')
     error = .true.
     return
  endif
  icall = icall+1
  !
  select case (comm)
  case ('DIFF')
    call class_diff(line,error,user_function)
  case ('FILTER')
    call class_filter(line,error)
  case ('MEDIAN')
    call class_median(line,error)
  case ('RMS')
    call class_rms(line,error,user_function)
  case ('SUBTRACT')
    call class_subtract_comm(line,error,user_function)
  case ('UNBLANK')
    call class_unblank(line,error)
  case ('UV_ZERO')
    call class_uvt (line,error,user_function)
  case ('VARIABLE')
    call class_variable(line,error,user_function)
  case ('WAVELET')
    call class_wavelet(line,error,user_function)
  case default
    mess = rname//char(92)//comm//' not yet implemented'
    call class_message(seve%i,rname,mess)
    error = .true.
  end select
  icall = icall-1
end subroutine sub_exp
!
function class_error()
  !---------------------------------------------------------------------
  ! @ private
  ! Support routine for the error status of the library. Does nothing
  ! here.
  !---------------------------------------------------------------------
  logical :: class_error  ! Function value on return
  !
  class_error = .false.
  !
end function class_error
!
function sas_function(action)
  !---------------------------------------------------------------------
  ! @ private
  !---------------------------------------------------------------------
  logical :: sas_function                 ! intent(out)
  character(len=*), intent(in) :: action  !
  ! Too much verbose when working with thousands of spectra...
  ! print *,'User function ',action
  sas_function = .false.
end function sas_function
!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
