function fgauss(xvel,x)
  use gauss_parameter
  !-------------------------------------------------------------------
  ! @ private
  ! CLASS internal function
  ! Not used ?
  !-------------------------------------------------------------------
  real(kind=8) :: fgauss            ! Function value on return
  real(kind=8), intent(in) :: xvel  ! Central velocity
  real(kind=8), intent(in) :: x(*)  ! Input lines parameters
  ! Local
  integer :: i
  real :: ff,tt,vv,dd,xf,xt,xv,xd,arg
  !
  ff=0.
  tt=x(1) ! Temperature
  vv=x(2) ! Central velocity
  dd=x(3) ! FWHM
  !
  do i=1,nline
     xt = x(3*i+1) * tt
     xv = x(3*i+2) + vv
     xd = x(3*i+3) * dd
     arg = (xvel - xv) / xd
     if (abs(arg).gt.4) then
        xf = 0.
     else
        xf = exp(-arg**2)
        ff = ff + xf * xt / xd
     endif
  enddo
  fgauss = ff
end function fgauss
!
subroutine dgauss (xvel,x,g)
  use gauss_parameter
  !---------------------------------------------------------------------
  ! @ private
  ! LAS	Internal routine
  !	Function to be minimized in the gaussian fit.
  !	By using 3 hidden parameters, the method allows dependent
  !	and independent gaussians to be fitted. The computation is
  !	highly optimised, but take care of R*4 and R*8 values !...
  !	Basic parameters are Area, Position and Width.
  ! Not used ?
  !---------------------------------------------------------------------
  real(kind=8), intent(in)  :: xvel  ! X value
  real(kind=8), intent(in)  :: x(*)  ! Parameter values
  real(kind=8), intent(out) :: g(*)  ! Array of derivatives
  ! Local
  real :: tt,vv,dd,gt,gv,gd,ff
  real :: t1,v1,d1,t2,v2,d2,t3,v3,d3,t4,v4,d4,t5,v5,d5
  real :: g1,g2,g3,g4,g5,g6,g7,g8,g9,g10,g11,g12,g13,g14,g15
  real :: arg1,arg2,arg3,arg4,arg5,f1,f2,f3,f4,f5,arg
  !
  tt=x(1)
  vv=x(2)
  dd=x(3)
  gt=0.
  gv=0.
  gd=0.
  !
  t1=x(4)*tt
  v1=x(5)+vv
  d1=x(6)*dd
  g1=0.
  g2=0.
  g3=0.
  !
  if (nline.ge.2) then
    t2=x(7)*tt
    v2=x(8)+vv
    d2=x(9)*dd
    g4=0.
    g5=0.
    g6=0.
    if (nline.ge.3) then
      t3=x(10)*tt
      v3=x(11)+vv
      d3=x(12)*dd
      g7=0.
      g8=0.
      g9=0.
      if (nline.ge.4) then
        t4=x(13)*tt
        v4=x(14)+vv
        d4=x(15)*dd
        g10=0.
        g11=0.
        g12=0.
        if (nline.ge.5) then
          t5=x(16)*tt
          v5=x(17)+vv
          d5=x(18)*dd
          g13=0.
          g14=0.
          g15=0.
        endif
      endif
    endif
  endif
  !
  !
  ff = 1.0
  ! First
  arg1 = (xvel - v1) / d1
  if (abs(arg1).le.4.) then
    f1 = exp(-arg1**2)
    arg = f1*ff/d1
    g1  = g1 + arg
    gt  = gt + arg*t1
    arg = t1/d1*arg
    g3  = g3 - arg
    gd  = gd - arg*d1
    arg = arg*arg1*2.
    g2  = g2 + arg
    gv  = gv + arg
    g3  = g3 + arg*arg1
    gd  = gd + arg*arg1*d1
  endif
  !
  if (nline.ge.2) then
    ! Second
    arg2 = (xvel - v2) / d2
    if (abs(arg2).le.4.) then
      f2 = exp(-arg2**2)
      arg = f2*ff/d2
      g4  = g4 + arg
      gt  = gt + arg*t2
      arg = arg*t2/d2
      g6  = g6 - arg
      gd  = gd - arg*d2
      arg = arg*arg2*2.
      g5  = g5 + arg
      gv  = gv + arg
      g6  = g6 + arg*arg2
      gd  = gd + arg*arg2*d2
    endif
    if (nline.ge.3) then
      ! Third
      arg3 = (xvel - v3) / d3
      if (abs(arg3).le.4.) then
        f3 = exp(-arg3**2)
        arg = f3*ff/d3
        g7  = g7 + arg
        gt  = gt + arg*t3
        arg = arg*t3/d3
        g9  = g9 - arg
        gd  = gd - arg*d3
        arg = arg*arg3*2.
        g8  = g8 + arg
        gv  = gv + arg
        g9  = g9 + arg*arg3
        gd  = gd + arg*arg3*d3
      endif
      if (nline.ge.4) then
        ! Fourth
        arg4 = (xvel - v4) / d4
        if (abs(arg4).le.4.) then
          f4 = exp(-arg4**2)
          arg = f4*ff/d4
          g10 = g10 + arg
          gt  = gt + arg*t4
          arg = arg*t4/d4
          g12 = g12 - arg
          gd  = gd - arg*d4
          arg = arg*arg4*2.
          g11 = g11 + arg
          gv  = gv + arg
          g12 = g12 + arg*arg4
          gd  = gd + arg*arg4*d4
        endif
        if (nline.ge.5) then
          ! Fifth
          arg5 = (xvel - v5) / d5
          if (abs(arg5).le.4.) then
            f5 = exp(-arg5**2)
            arg = f5*ff/d5
            g13 = g13 + arg
            gt  = gt  + arg*t5
            arg = arg*t5/d5
            g15 = g15 - arg
            gd  = gd - arg*d5
            arg = arg*arg5*2.
            g14 = g14 + arg
            gv  = gv  + arg
            g15 = g15 + arg*arg5
            gd  = gd  + arg*arg5*d5
          endif
        endif                  ! 5
      endif                    ! 4
    endif                      ! 3
  endif
  !
  ! Setup values and return
  g(1)=gt/tt
  g(2)=gv
  g(3)=gd/dd
  !
  g(4)=g1*tt
  g(5)=g2
  g(6)=g3*dd
  !
  if (nline.lt.2) return
  g(7)=g4*tt
  g(8)=g5
  g(9)=g6*dd
  if (nline.lt.3) return
  g(10)=g7*tt
  g(11)=g8
  g(12)=g9*dd
  if (nline.lt.4) return
  g(13)=g10*tt
  g(14)=g11
  g(15)=g12*dd
  if (nline.lt.5) return
  g(16)=g13*tt
  g(17)=g14
  g(18)=g15*dd
end subroutine dgauss

