subroutine fits_gildas(line,error)
  use gildas_def
  use image_def
  use gbl_message
  use sic_dependencies_interfaces
  use sic_interfaces, except_this=>fits_gildas
  !---------------------------------------------------------------------
  ! @ public
  ! Support routine for command
  !   FITS File.fits FROM File.gdf /STYLE [/XTENSION Number] /CHECK /OVERWRITE
  !   FITS File.fits TO File.gdf   /STYLE /BITS /BLC /TRC /OVERWRITE
  !
  ! Internal FITS_GILDAS or GILDAS_FITS conversion.
  ! Allow unrecognized FITS keyword handling, either by Symbol translation
  ! or by user input.
  !---------------------------------------------------------------------
  character(len=*) :: line          !
  logical :: error                  !
  ! Local
  character(len=*), parameter :: rname='FITS'
  character(len=filename_length) :: gildas_file,fits_file
  character(len=12) :: key
  character(len=12) :: style
  character(len=80) :: chain
  integer(kind=index_length) :: blc(gdf_maxdims),trc(gdf_maxdims)
  integer :: ng,nh,nk
  integer :: nbit,ncom,i,n
  logical :: check
  integer(kind=4), parameter :: mstyle=7
  character(len=16) :: styles(mstyle),argum,comm
  data styles/'STANDARD','CPC','SPLINE','UVFITS','AIPSFITS', 'SORTED_AIPSFITS', &
              'CASA_UVFITS'/
  ! Options to command:
  integer(kind=4), parameter :: optbits=1
  integer(kind=4), parameter :: optstyl=2
  integer(kind=4), parameter :: optxten=3
  integer(kind=4), parameter :: optchec=4
  integer(kind=4), parameter :: optblc =5
  integer(kind=4), parameter :: opttrc =6
  integer(kind=4), parameter :: optover=7
  !
  if (sic_present(optxten,0)) then
    call sic_message(seve%e,rname,'Option /XTENSION is not implemented')
    call sic_message(seve%e,rname,'Use SIC\DEFINE FITS instead to circumvent the problem')
    error = .true.
    return
  endif
  !
  call sic_ke(line,0,2,key,nk,.true.,error)
  if (error) return
  !
  check = sic_present(optchec,0)
  !
  nbit = 32
  call sic_i4(line,optbits,1,nbit,.false.,error)
  if (nbit.ne.16 .and. nbit.ne.32 .and. nbit.ne.-32 .and. nbit.ne.-64) then
    write(chain,'(A,I0)') 'Invalid number of bits ',nbit
    call sic_message(seve%e,rname,chain)
    error = .true.
    return
  endif
  style = 'STANDARD'
  if (sic_present(optstyl,1)) then
    call sic_ke(line,optstyl,1,argum,nk,.true.,error)
    call sic_ambigs(rname,argum,comm,ncom,styles,mstyle,error)
    if (error) return
    style = comm
  endif
  !
  ! Use FITS --> GILDAS
  if (key.eq.'TO') then
    blc = 0
    if (sic_present(optblc,0)) then
      n = sic_narg(optblc)
      if (n.gt.gdf_maxdims) then
        write(chain,'(A,I3,A,I3)') 'Too many values for BLC ',n,' > ',gdf_maxdims
        call sic_message(seve%e,rname,chain)
        error = .true.
        return
      endif
      do i=1,n
        call sic_i0(line,optblc,i,blc(i),.true.,error)
        if (error) return
      enddo
    endif
    trc = 0
    if (sic_present(opttrc,0)) then
      n = sic_narg(opttrc)
      if (n.gt.gdf_maxdims) then
        write(chain,'(A,I3,A,I3)') 'Too many values for TRC ',n,' > ',gdf_maxdims
        call sic_message(seve%e,rname,chain)
        error = .true.
        return
      endif
      do i=1,n
        call sic_i0(line,opttrc,i,trc(i),.true.,error)
        if (error) return
      enddo
    endif
    !
    call sic_ch(line,0,1,fits_file,nh,.true.,error)
    if (error) return
    call sic_ch(line,0,3,gildas_file,ng,.true.,error)
    if (error) return
    !
    if (sic_present(optover,0) .and. gag_inquire(gildas_file,ng).eq.0)  &
      call gag_filrm(gildas_file(1:ng))
    !
    call fits_gildas_sub(fits_file,gildas_file,style,blc,trc,check,error,  &
    sic_getsymbol,sic_wpr)
    !
  elseif  (key.eq.'FROM') then
    !
    if (sic_present(optblc,0) .or. sic_present(opttrc,0)) then
      chain = 'Options /BLC or /TRC not supported in this direction'
      call sic_message(seve%e,rname,chain)
      error = .true.
      return
    endif
    !
    ! Use GILDAS --> FITS
    call sic_ch(line,0,1,fits_file,nh,.true.,error)
    if (error) return
    call sic_ch(line,0,3,gildas_file,ng,.true.,error)
    if (error)  return
    !
    if (sic_present(optover,0) .and. gag_inquire(fits_file,nh).eq.0)  &
      call gag_filrm(fits_file(1:nh))
    !
    call gildas_fits_sub(gildas_file,fits_file,style,nbit,error)
  endif
  !
end subroutine fits_gildas
