subroutine fits2gdf(name,error)
  use gio_interfaces, only: fits_gildas_sub, gio_message, &
    fits2gdf_getsymbol,fits2gdf_wpr
  use gbl_message
  use gio_params
  !---------------------------------------------------------------------
  ! @ private
  ! Automatic FITS to GDF converion
  !---------------------------------------------------------------------
  character(len=*), intent(inout)  :: name       ! File name (modified)
  logical, intent(out) :: error                  ! Error flag
  ! Local
  character(len=*), parameter :: rname='FITS2GDF'
  character(len=filename_length) :: iname,oname
  integer(kind=index_length) :: blc(gdf_maxdims),trc(gdf_maxdims)
  !
  call gio_message(seve%i,rname,'FITS-to-GDF automatic conversion, Version 1.1')
  !
  error=.false.
  blc = 0
  trc = 0
  !
  iname = name
  oname = trim(name)//'.gdf'
  name = oname
  !
  call fits_gildas_sub(iname,oname,'STANDARD',blc,trc,.false.,error,  &
  fits2gdf_getsymbol,fits2gdf_wpr)
  if (error) then
    call gio_message(seve%e,rname,'Conversion failed')
    error=.true.
  else
    call gio_message(seve%i,rname,'Successful completion')
  endif
  !
end subroutine fits2gdf
!
subroutine fits2gdf_getsymbol(symb,trans,error)
  !---------------------------------------------------------------------
  ! @ private-mandatory (because symbol is used elsewhere)
  !---------------------------------------------------------------------
  character(len=*) :: symb          !
  character(len=*) :: trans         !
  logical :: error                  !
  error = .true.
end subroutine fits2gdf_getsymbol
!
subroutine fits2gdf_wpr(chain,answer)
  use gio_dependencies_interfaces
  use gio_interfaces, only : gio_message
  use gildas_def
  use gbl_message
  !---------------------------------------------------------------------
  ! @ private-mandatory (because symbol is used elsewhere)
  !---------------------------------------------------------------------
  character(len=*) :: chain         !
  character(len=*) :: answer        !
  call gio_message(seve%e,'FITS2GDF','Invalid call to SIC_WPR')
  call sysexi(fatale)
end subroutine fits2gdf_wpr
