subroutine fitreal(ndat,array,scale,zero,error)
  use gio_interfaces, only : gio_message, gfits_putbuf
  use gio_fitsdef
  use gbl_message
  !---------------------------------------------------------------------
  ! @ no-interface (rank mismatch for input 'array')
  ! Write NDAT data values in FITS data area,
  ! with scaling SCALE and offset ZERO
  !---------------------------------------------------------------------
  integer, intent(in)    :: ndat         ! Number of data elements
  real,    intent(in)    :: array(ndat)  ! Data array
  real,    intent(in)    :: scale        ! Scaling factor
  real,    intent(in)    :: zero         ! Zero offset
  logical, intent(inout) :: error        ! Error flag
  ! Local
  character(len=*), parameter :: rname='FITREAL'
  integer :: i
  real :: vtest
  character(len=message_length) :: mess
  !
  ! I*2
  if (snbit.eq.16) then
    do i = 1, ndat
      vtest = (array(i)-zero)/scale
      if (vtest.lt.-32768.) then
        write(mess,*) 'Value ',array(i),' below range'
        call gio_message(seve%e,rname,mess)
        vtest = -32768.
      elseif (vtest.gt.32767.) then
        write(mess,*) 'Value ',array(i),' above range'
        call gio_message(seve%e,rname,mess)
        vtest = 32767.
      endif
      nb = nb+1
      i2buf(nb) = vtest
      if (nb.ge.1440) then
#if defined(IEEE) || defined(VAX)
        call iei2ei (buffer,buffer,1440)
#endif
        call gfits_putbuf(buffer,2880,error)
        nb = 0
        if (error) return
      endif
    enddo
  elseif (snbit.eq.32) then
    do i = 1, ndat
      vtest = (array(i)-zero)/scale
      if (vtest.lt.-2147483648.) then
        write(mess,*) 'Value ',array(i),' below range'
        call gio_message(seve%e,rname,mess)
        vtest = -2147483648.
      elseif (vtest.gt.2147483647.) then
        write(mess,*) 'Value ',array(i),' above range'
        call gio_message(seve%e,rname,mess)
        vtest = 2147483647.
      endif
      nb = nb+1
      i4buf(nb) = vtest
      if (nb.ge.720) then
#if defined(IEEE) || defined(VAX)
        call iei4ei(buffer,buffer,720)
#endif
        call gfits_putbuf(buffer,2880,error)
        nb = 0
        if (error) return
      endif
    enddo
  elseif  (snbit.eq.-32) then
#if defined(VAX)
    call setblnk4(bval)
#endif
    do i = 1, ndat
      vtest = (array(i)-zero)/scale
      nb= nb+1
#if defined(VAX)
      call var4ei(vtest,i4buf(nb),1)
#endif
#if defined(IEEE)
      call ier4ei(vtest,i4buf(nb),1)
#endif
#if defined(EEEI)
      i4buf(nb) = vtest
#endif
      if (nb.ge.720) then
        call gfits_putbuf(buffer,2880,error)
        nb = 0
        if (error) return
      endif
    enddo
  else
    error = .true.
  endif
  return
!
entry fitreal_end(error)
  if (nb.eq.0) return
  if (snbit.eq.16) then
    do i = nb+1,1440
      i2buf (i) = 0
    enddo
#if defined(IEEE) || defined(VAX)
    call iei2ei(buffer,buffer,1440)
#endif
  elseif (snbit.eq.32) then
    do i = nb+1,720
      i4buf (i) = 0
    enddo
#if defined(IEEE) || defined(VAX)
    call iei4ei(buffer,buffer,720)
#endif
  elseif (snbit.eq.-32) then
    do i = nb+1,720
      i4buf (i) = 0
    enddo
  else
    error = .true.
    return
  endif
  call gfits_putbuf(buffer,2880,error)
  nb = 0
end subroutine fitreal
