module gfits_types
  !
  type :: fits_descriptor_t
    real(kind=4)    :: bscal   ! Tape scaling factor
    real(kind=4)    :: bzero   ! Map offset
    integer(kind=4) :: nbit    ! Number of bits per value in current file
    integer(kind=4) :: snbit   ! Number of bits per value for FITS writing
    integer(kind=4) :: nb      ! Pointer within I/O buffer
    real(kind=4)    :: bval0   ! Default blanking value
  end type fits_descriptor_t
  !
  ! Type for scalar FITS cards = key + value + comment. Since the value is
  ! is not decoded at this stage, use the 'unknown' type.
  ! ZZZZ Duplicate of Mrtcal and Class same types
  integer(kind=4), parameter :: key_length=15
  integer(kind=4), parameter :: char0d_length=80   ! FITS character scalar values
  integer(kind=4), parameter :: comment_length=72
  type fits_unkn_0d_t
     character(len=comment_length) :: comment = ''
     character(len=key_length) :: key = ''
     character(len=char0d_length) :: val = ''
  end type fits_unkn_0d_t
  !
  ! ZZZZ Duplicate of Class same type
  integer(kind=4), parameter :: mcard=1000
  type :: fits_header_t
    ! Dictionary of cards in the header
    integer(kind=4) :: ncard
    type(fits_unkn_0d_t) :: diccard(mcard)
    integer(kind=4) :: sort(mcard)  ! Sorting array
  end type fits_header_t
  !
end module gfits_types
