!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
! *** JP: This code should be factorized with the primitive types used for the
! *** JP: header in header-array.f90.
!
module cubemain_extrema_types
  use cubemain_messaging
  use cube_types
  !
  public :: extrema_prog_t
  private
  !
  integer(kind=ndim_k), parameter :: ndim = 3
  integer(kind=ndim_k), parameter :: ix = 1
  integer(kind=ndim_k), parameter :: iy = 2
  integer(kind=ndim_k), parameter :: ic = 3 
  !
  type extrema_prog_t
     real(kind=sign_k) :: min ! Minimum inside region of interest
     real(kind=sign_k) :: max ! Maximum inside region of interest
     !
     integer(kind=data_k),  private :: locmin(ndim)  ! Location of the minimum
     integer(kind=data_k),  private :: locmax(ndim)  ! Location of the maximum
     integer(kind=data_k),  private :: nnan          ! Number of NaNs
     integer(kind=data_k),  private :: ndata         ! Number of data
     integer(kind=ndim_k),  private :: iaxes(ndim) = [ix,iy,ic] ! Dimension pointers
     integer(kind=data_k),  private :: range(ndim,2) ! Ranges
     type(cube_t), pointer, private :: cube          ! Pointer to cube
   contains
     procedure, public  :: get           => cubemain_extrema_get
     procedure, private :: test_range    => cubemain_extrema_test_range
     procedure, private :: getorder      => cubemain_extrema_getorder
     !
     procedure, private :: header        => cubemain_extrema_header
     procedure, private :: data          => cubemain_extrema_data
     procedure, private :: loop          => cubemain_extrema_loop
     procedure, private :: act           => cubemain_extrema_act
     procedure, private :: init          => cubemain_extrema_init
     procedure, private :: merge_local   => cubemain_extrema_merge_local
     !
     procedure, public  :: list          => cubemain_extrema_list
     procedure, public  :: def_substruct => cubemain_extrema_def_substruct
  end type extrema_prog_t
  !
contains
  !
  subroutine cubemain_extrema_get(ext,cube,xrange,yrange,crange,error)
    use cubetemplate_sperange_types
    use cubetemplate_sparange_types
    !------------------------------------------------------------------------
    !
    !------------------------------------------------------------------------
    class(extrema_prog_t), intent(out)   :: ext
    type(cube_t), target,  intent(inout) :: cube
    type(sparange_prog_t), intent(in)    :: xrange
    type(sparange_prog_t), intent(in)    :: yrange
    type(sperange_prog_t), intent(in)    :: crange
    logical,               intent(inout) :: error
    !
    logical :: dodata
    character(len=*), parameter :: rname='EXTREMA>GET'
    !
    call cubemain_message(mainseve%trace,rname,'Welcome')
    !
    ext%cube => cube
    call ext%test_range(xrange,yrange,crange,dodata,error)
    if (error) return
    !
    if (dodata) then
       call ext%data(error)
       if (error) return
    else
       call ext%header(error)
       if (error) return
    endif
  end subroutine cubemain_extrema_get
  !
  subroutine cubemain_extrema_test_range(ext,xrange,yrange,crange,dodata,error)
    use cubetools_nan
    use cubetemplate_sperange_types
    use cubetemplate_sparange_types
    !------------------------------------------------------------------------
    !
    !------------------------------------------------------------------------
    class(extrema_prog_t), intent(inout) :: ext
    type(sparange_prog_t), intent(in)    :: xrange
    type(sparange_prog_t), intent(in)    :: yrange
    type(sperange_prog_t), intent(in)    :: crange
    logical,               intent(out)   :: dodata
    logical,               intent(inout) :: error
    !
    integer(kind=8) :: stride
    logical :: totalx,totaly,totalc,wholecube,bothnan,allnan
    character(len=*), parameter :: rname='EXTREMA>TEST>RANGE'
    !
    call cubemain_message(mainseve%trace,rname,'Welcome')
    !
    call ext%getorder(error)
    if (error) return
    !
    call xrange%to_pixe_k(ext%range(ext%iaxes(ix),1),ext%range(ext%iaxes(ix),2),stride,error)
    if (error) return
    call yrange%to_pixe_k(ext%range(ext%iaxes(iy),1),ext%range(ext%iaxes(iy),2),stride,error)
    if (error) return
    call crange%to_chan_k(ext%range(ext%iaxes(ic),1),ext%range(ext%iaxes(ic),2),stride,error)
    if (error) return
    !
    ! If requested region goes beyond the cube resize it to the cube
    ! limits
    ! VVV should a warning be raised, I guess not
    if (ext%range(ext%iaxes(ic),1).lt.1) ext%range(ext%iaxes(ic),1) = 1
    if (ext%range(ext%iaxes(ic),2).gt.ext%cube%head%arr%n%c) &
         ext%range(ext%iaxes(ic),2) = ext%cube%head%arr%n%c
    if (ext%range(ext%iaxes(ix),1).lt.1) ext%range(ext%iaxes(ix),1) = 1
    if (ext%range(ext%iaxes(ix),2).gt.ext%cube%head%arr%n%l) &
         ext%range(ext%iaxes(ix),2) = ext%cube%head%arr%n%l
    if (ext%range(ext%iaxes(iy),1).lt.1) ext%range(ext%iaxes(iy),1) = 1
    if (ext%range(ext%iaxes(iy),2).gt.ext%cube%head%arr%n%m) &
         ext%range(ext%iaxes(iy),2) = ext%cube%head%arr%n%m
    !
    ! If we cover the whole x,y,c axes we only need to compute extrema
    ! if they are both NaN
    totalx = ext%range(ext%iaxes(ix),1).eq.1.and.ext%range(ext%iaxes(ix),2).eq.ext%cube%head%arr%n%l
    totaly = ext%range(ext%iaxes(iy),1).eq.1.and.ext%range(ext%iaxes(iy),2).eq.ext%cube%head%arr%n%m
    totalc = ext%range(ext%iaxes(ic),1).eq.1.and.ext%range(ext%iaxes(ic),2).eq.ext%cube%head%arr%n%c
    wholecube = totalc.and.totaly.and.totalx
    bothnan = ieee_is_nan(ext%cube%head%arr%min%val).and.ieee_is_nan(ext%cube%head%arr%max%val)
    allnan  = ext%cube%head%arr%n%nan.eq.ext%cube%head%arr%n%dat 
    !
    if (allnan) then
       dodata = .false.
    else
       if (wholecube.and..not.bothnan) then
          dodata = .false.
       else
          dodata = .true.
       endif
    endif
  end subroutine cubemain_extrema_test_range
  !
  subroutine cubemain_extrema_getorder(ext,error)
    !------------------------------------------------------------------------
    !
    !------------------------------------------------------------------------
    class(extrema_prog_t), intent(inout) :: ext
    logical,               intent(inout) :: error
    !
    character(len=*), parameter :: rname='EXTREMA>GETORDER'
    !
    call cubemain_message(mainseve%trace,rname,'Welcome')
    !
    select case(ext%cube%order())
    case(code_cube_imaset)
       ext%iaxes = [1,2,3]
    case (code_cube_speset)
       ext%iaxes = [2,3,1]
    case default
       call cubemain_message(mainseve%trace,rname,'Internal error: Cube is neither in imaset or speset')
       error = .true.
       return
    end select
  end subroutine cubemain_extrema_getorder
  !
  !------------------------------------------------------------------------
  !
  subroutine cubemain_extrema_header(ext,error)
    use cubetools_header_methods
    use cubetools_arrelt_types
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(extrema_prog_t), intent(inout) :: ext
    logical,               intent(inout) :: error
    !
    type(arrelt_t) :: min,max
    character(len=*), parameter :: rname='EXTREMA>FETCH'
    !
    call cubemain_message(mainseve%trace,rname,'Welcome')
    !
    call cubetools_header_get_array_minmax(ext%cube%head,min,max,error)
    if (error)  return
    !
    ext%min                   = min%val
    ext%locmin(ext%iaxes(ix)) = min%ix
    ext%locmin(ext%iaxes(iy)) = min%iy
    ext%locmin(ext%iaxes(ic)) = min%ic
    !
    ext%max                   = max%val
    ext%locmax(ext%iaxes(ix)) = max%ix
    ext%locmax(ext%iaxes(iy)) = max%iy
    ext%locmax(ext%iaxes(ic)) = max%ic
    !
    ext%nnan  = ext%cube%head%arr%n%nan
    ext%ndata = ext%cube%head%arr%n%dat
  end subroutine cubemain_extrema_header
  !
  subroutine cubemain_extrema_data(global,error)
    use cubetools_nan
    use cubeadm_opened
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(extrema_prog_t), intent(inout) :: global
    logical,               intent(inout) :: error
    !
    type(cubeadm_iterator_t) :: itertask
    integer(kind=ndim_k) :: idim
    character(len=*), parameter :: rname='EXTREMA>DATA'
    !
    call cubemain_message(mainseve%trace,rname,'Welcome')
    !
    call global%init(error)
    if (error) return
    global%ndata = 1
    do idim=1,ndim
       global%ndata = global%ndata*(global%range(idim,2)-global%range(idim,1)+1)
    enddo
    !
    call cubeadm_datainit_all(itertask,global%range(3,1),global%range(3,2),error)
    if (error) return
    !
    !$OMP PARALLEL DEFAULT(none) SHARED(global,error) FIRSTPRIVATE(itertask)
    !$OMP SINGLE
    do while (cubeadm_dataiterate_all(itertask,error))
       if (error) exit
       !$OMP TASK SHARED(global,error) FIRSTPRIVATE(itertask)
       if (.not.error) then
          call global%loop(itertask,error)
       endif
       !$OMP END TASK
    enddo ! ie
    !$OMP END SINGLE
    !$OMP END PARALLEL
    !
    if (global%ndata.eq.global%nnan) then
       call global%init(error)
       if (error) return
       global%min = gr4nan
       global%max = gr4nan
    endif
  end subroutine cubemain_extrema_data
  !
  subroutine cubemain_extrema_loop(global,iter,error)
    use cubeadm_taskloop
    !------------------------------------------------------------------------
    !
    !------------------------------------------------------------------------
    class(extrema_prog_t),    intent(inout) :: global
    type(cubeadm_iterator_t), intent(inout) :: iter
    logical,                  intent(inout) :: error
    !
    type(extrema_prog_t) :: local
    character(len=*), parameter :: rname='EXTREMA>LOOP'
    !
    call cubemain_message(mainseve%trace,rname,'Welcome')
    !
    do while (iter%iterate_entry(error))
      call global%act(iter,local,error)
      if (error) return
      !
      ! *** JP: A better parallel construct would be to computes
      ! *** JP: all the local min and max and merge them at the end.
      ! *** JP: In fact I am unsure that the OMP directive is actually used!
      !
      ! This part has to be critical to avoid conflict betwen
      ! threads. Third dimension correction has to be applied to
      ! account for i3 being the index inside the subcube.
      !
      ! !$OMP CRITICAL
      call global%merge_local(iter%ie,local,error)
      if (error) return
      ! !$OMP END CRITICAL
    enddo  ! ientry
  end subroutine cubemain_extrema_loop
  !
  subroutine cubemain_extrema_act(global,itertask,local,error)
    use cubeadm_taskloop
    use cubeadm_subcube_types
    use cubetools_nan
    !-------------------------------------------------------------------
    ! 
    !-------------------------------------------------------------------
    class(extrema_prog_t),    intent(inout) :: global
    type(cubeadm_iterator_t), intent(in)    :: itertask
    type(extrema_prog_t),     intent(out)   :: local
    logical,                  intent(inout) :: error
    !
    type(subcube_t) :: cube
    integer(kind=data_k) :: ix,iy,iz
    character(len=*), parameter :: rname='EXTREMA>ACT'
    !
    call cubemain_message(mainseve%trace,rname,'Welcome')
    !
    call local%init(error)
    if (error) return
    !
    ! Subcubes are initialized here as their size (3rd dim) may change from
    ! from one subcube to another.
    call cube%associate('cube',global%cube,itertask,error)
    if (error) return
    !
    call cube%get(error)
    if (error) return
    do iz=1,cube%nz
       do iy=global%range(2,1),global%range(2,2)
          do ix=global%range(1,1),global%range(1,2)
             if (ieee_is_nan(cube%val(ix,iy,iz))) then
                local%nnan = local%nnan+1
             else
                if (cube%val(ix,iy,iz).gt.local%max) then
                   local%max       = cube%val(ix,iy,iz)
                   local%locmax(:) = [ix,iy,iz]
                else if (cube%val(ix,iy,iz).lt.local%min) then
                   local%min       = cube%val(ix,iy,iz)
                   local%locmin(:) = [ix,iy,iz]
                else
                   ! Does nothing
                endif
             endif
          enddo
       enddo
    enddo
  end subroutine cubemain_extrema_act
  !
  !--------------------------------------------------------------------------
  !
  subroutine cubemain_extrema_init(ext,error)
    !------------------------------------------------------------------------
    !
    !------------------------------------------------------------------------
    class(extrema_prog_t), intent(inout) :: ext
    logical,               intent(inout) :: error
    !
    character(len=*), parameter :: rname='EXTREMA>INIT'
    !
    call cubemain_message(mainseve%trace,rname,'Welcome')
    !
    ext%min =  huge(ext%min)
    ext%max = -huge(ext%max)
    ext%locmin(:) = 0
    ext%locmax(:) = 0
    ext%nnan = 0
  end subroutine cubemain_extrema_init
  !
  subroutine cubemain_extrema_merge_local(global,isubcube,local,error)
    !------------------------------------------------------------------------
    !
    !------------------------------------------------------------------------
    class(extrema_prog_t), intent(inout) :: global
    integer(kind=entr_k),  intent(in)    :: isubcube
    type(extrema_prog_t),  intent(in)    :: local
    logical,               intent(inout) :: error
    !
    character(len=*), parameter :: rname='EXTREMA>MERGE>LOCAL'
    !
    call cubemain_message(mainseve%trace,rname,'Welcome')
    !
    if (local%max.gt.global%max) then
       global%max         = local%max
       global%locmax(1:2) = local%locmax(1:2)
       global%locmax(3)   = local%locmax(3)+isubcube+global%range(3,1)-2
    endif
    if (local%min.lt.global%min) then
       global%min         = local%min
       global%locmin(1:2) = local%locmin(1:2)
       global%locmin(3)   = local%locmin(3)+isubcube+global%range(3,1)-2
    endif
    global%nnan = global%nnan+local%nnan
  end subroutine cubemain_extrema_merge_local
  !
  !------------------------------------------------------------------------
  !
  subroutine cubemain_extrema_list(ext,error)
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(extrema_prog_t), intent(in)    :: ext
    logical,               intent(inout) :: error
    !
    character(len=mess_l) :: mess
    character(len=*), parameter :: rname='EXTREMA>LIST'
    !
    call cubemain_message(mainseve%trace,rname,'Welcome')
    !
    write(mess,'(15x,a,4x,3(4x,a))') 'Value','Channel','X pixel','Y pixel'
    call cubemain_message(seve%r,rname,mess)
    write(mess,1000) 'Maximum:',ext%max,ext%locmax(ext%iaxes(ic)),&
         ext%locmax(ext%iaxes(ix)),ext%locmax(ext%iaxes(iy))
    call cubemain_message(seve%r,rname,mess)
    write(mess,1000) 'Minimum:',ext%min,ext%locmin(ext%iaxes(ic)),&
         ext%locmin(ext%iaxes(ix)),ext%locmin(ext%iaxes(iy))
    call cubemain_message(seve%r,rname,mess)
    call cubemain_message(seve%r,rname,'')
    write(mess,'(2(i0,a),x,1pg8.3,a)') ext%nnan,' NaNs out of ',ext%ndata,' elements, ',&
         100.0*ext%nnan/ext%ndata,'%'
    call cubemain_message(seve%r,rname,mess)
    call cubemain_message(seve%r,rname,'')
    !
1000 format(a,2x,1pg14.7,3(x,i10))
  end subroutine cubemain_extrema_list
  !
  subroutine cubemain_extrema_def_substruct(ext,name,struct,error)
    use cubetools_userstruct
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(extrema_prog_t), intent(in)    :: ext
    character(len=*),      intent(in)    :: name
    type(userstruct_t),    intent(inout) :: struct
    logical,               intent(inout) :: error
    !
    type(userstruct_t) :: substruct,min,max
    character(len=*), parameter :: rname='EXTREMA>DEF>SUBSTRUCT'
    !
    call cubemain_message(mainseve%trace,rname,'Welcome')
    !
    call struct%def_substruct(name,substruct,error)
    if (error) return
    call substruct%def_substruct('min',min,error)
    if (error) return
    call min%set_member('value',ext%min,error)
    if (error) return
    call min%set_member('location',ext%locmin,error)
    if (error) return
    call substruct%def_substruct('max',max,error)
    if (error) return
    call max%set_member('value',ext%max,error)
    if (error) return
    call max%set_member('location',ext%locmax,error)
    if (error) return
  end subroutine cubemain_extrema_def_substruct
end module cubemain_extrema_types
!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
