!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
module cubeadm_image_types
  use cubetools_array_types
  use cube_types
  use cubeadm_messaging
  use cubeadm_taskloop
  use cubeadm_taskloop_iteration
  !
  public :: image_t
  private
  !
  type, extends(real_2d_t) :: image_t
     type(cube_t),             private, pointer :: cube => null() ! Associated cube
     type(cubeadm_iterator_t), private, pointer :: task => null() ! Associated task iteration
   contains
     generic,   public  :: allocate   => allocate_iter,allocate_noiter
     generic,   public  :: associate  => associate_iter,associate_noiter
     procedure, public  :: get        => image_get
     procedure, public  :: put        => image_put
     procedure, public  :: put_in     => image_put_in
     procedure, public  :: blank_like => image_blank_like
     procedure, private :: tasknum    => image_task_num
     !
     procedure, private :: allocate_iter    => image_allocate_iter
     procedure, private :: allocate_noiter  => image_allocate_noiter
     procedure, private :: associate_iter   => image_associate_iter
     procedure, private :: associate_noiter => image_associate_noiter
  end type image_t
  !
contains
  !
  subroutine image_allocate_iter(image,name,cube,iterator,error)
    !-------------------------------------------------------------------
    !-------------------------------------------------------------------
    class(image_t),                   intent(out)   :: image
    character(len=*),                 intent(in)    :: name
    type(cube_t),             target, intent(in)    :: cube
    type(cubeadm_iterator_t), target, intent(in)    :: iterator
    logical,                          intent(inout) :: error
    !
    call image_allocate_noiter(image,name,cube,error)
    if (error)  return
    image%task => iterator
  end subroutine image_allocate_iter
  !
  subroutine image_allocate_noiter(image,name,cube,error)
    !-------------------------------------------------------------------
    !-------------------------------------------------------------------
    class(image_t),       intent(out)   :: image
    character(len=*),     intent(in)    :: name
    type(cube_t), target, intent(in)    :: cube
    logical,              intent(inout) :: error
    !
    character(len=*), parameter :: rname='IMAGE>ALLOCATE'
    !
    call cubeadm_message(admseve%trace,rname,'Welcome')
    !
    if (cube%iscplx()) then
       call cubeadm_message(seve%e,rname,  &
            'Invalid attempt to get a R*4 image from a C*4 cube')
       error = .true.
       return
    endif
    !
    call image%reallocate(name,&
         cube%tuple%current%desc%nx,&
         cube%tuple%current%desc%ny,&
         error)
    if (error) return
    image%cube => cube
    image%task => null()
  end subroutine image_allocate_noiter
  !
  subroutine image_associate_iter(image,name,cube,iterator,error)
    !-------------------------------------------------------------------
    !-------------------------------------------------------------------
    class(image_t),                   intent(out)   :: image
    character(len=*),                 intent(in)    :: name
    type(cube_t),             target, intent(in)    :: cube
    type(cubeadm_iterator_t), target, intent(in)    :: iterator
    logical,                          intent(inout) :: error
    !
    call image_associate_noiter(image,name,cube,error)
    if (error)  return
    image%task => iterator
  end subroutine image_associate_iter
  !
  subroutine image_associate_noiter(image,name,cube,error)
    !-------------------------------------------------------------------
    !-------------------------------------------------------------------
    class(image_t),       intent(out)   :: image
    character(len=*),     intent(in)    :: name
    type(cube_t), target, intent(in)    :: cube
    logical,              intent(inout) :: error
    !
    character(len=*), parameter :: rname='IMAGE>ASSOCIATE'
    !
    call cubeadm_message(admseve%trace,rname,'Welcome')
    !
    if (cube%iscplx()) then
       call cubeadm_message(seve%e,rname,  &
            'Invalid attempt to get a R*4 image from a C*4 cube')
       error = .true.
       return
    endif
    !
    call image%prepare_association(name,&
         cube%tuple%current%desc%nx,&
         cube%tuple%current%desc%ny,&
         error)
    if (error) return
    image%cube => cube
    image%task => null()
  end subroutine image_associate_noiter
  !
  !------------------------------------------------------------------------
  !
  subroutine image_get(image,ient,error)
    use cubeio_chan
    use cubetuple_entry
    !---------------------------------------------------------------------
    ! Get the ient image from the cube
    ! When image%val is an allocated pointer, we make a copy.
    ! In all other cases (associated or null), we make it point to the data.
    !---------------------------------------------------------------------
    class(image_t),       intent(inout) :: image
    integer(kind=entr_k), intent(in)    :: ient
    logical,              intent(inout) :: error
    ! 
    type(cube_chan_t) :: entry
    character(len=*), parameter :: rname='GET>IMAGE'
    !
    call cubeadm_message(admseve%trace,rname,'Welcome')
    !
    call cubetuple_get_chan(image%cube%user,image%cube%prog,image%cube,ient,entry,error)
    if (error) return
    !
    if (image%pointeris.eq.code_pointer_allocated) then
       image%val(:,:) = entry%r4(:,:)
    else
       image%val => entry%r4
       image%pointeris = code_pointer_associated
    endif
    image%nx = entry%nx
    image%ny = entry%ny
    !
    call cubeio_free_chan(entry,error)
    if (error) return
  end subroutine image_get
  !
  subroutine image_put(image,ient,error)
    use cubeio_chan
    use cubetuple_entry
    !---------------------------------------------------------------------
    ! Put the ient image to the cube
    ! Only use pointers => Nothing to free
    !
    ! *** JP: Maybe this one should call the next one to factorize code.
    !---------------------------------------------------------------------
    class(image_t),       intent(in)    :: image
    integer(kind=entr_k), intent(in)    :: ient
    logical,              intent(inout) :: error
    !
    type(cube_chan_t) :: entry
    character(len=*), parameter :: rname='IMAGE>PUT'
    !
    call cubeadm_message(admseve%trace,rname,'Welcome')
    !
    entry%allocated = code_pointer_associated
    entry%nx = image%nx
    entry%ny = image%ny
    entry%r4 => image%val
    entry%iscplx = .false.
    !
    call cubetuple_put_chan(image%cube%user,  &
                            image%cube%prog,  &
                            image%cube,       &
                            image%tasknum(),  &
                            ient,             &
                            entry,            &
                            error)
    if (error) return
  end subroutine image_put
  !
  subroutine image_put_in(image,cube,ient,error)
    use cubeio_chan
    use cubetuple_entry
    !---------------------------------------------------------------------
    ! Put the ient image to the cube.
    ! Only use pointers => Nothing to free.
    !
    ! This flavor, which explicitely states the output cube, should be used
    ! when the input image needs to be written in another cube without
    ! copy. See, eg, the SPLIT command. This should an exotic use compare to
    ! image_put.
    ! ---------------------------------------------------------------------
    class(image_t),       intent(in)    :: image
    type(cube_t),         intent(inout) :: cube
    integer(kind=entr_k), intent(in)    :: ient
    logical,              intent(inout) :: error
    !
    type(cube_chan_t) :: entry
    character(len=*), parameter :: rname='IMAGE>PUT>IN'
    !
    call cubeadm_message(admseve%trace,rname,'Welcome')
    !
    entry%allocated = code_pointer_associated
    entry%nx = image%nx
    entry%ny = image%ny
    entry%r4 => image%val
    entry%iscplx = .false.
    !
    call cubetuple_put_chan(cube%user,       &
                            cube%prog,       &
                            cube,            &
                            image%tasknum(), &
                            ient,            &
                            entry,           &
                            error)
    if (error) return
  end subroutine image_put_in
  !
  !-----------------------------------------------------------------------
  !
  subroutine image_blank_like(image,reference,error)
    use cubetools_nan
    !---------------------------------------------------------------------
    ! *** JP: Is it a method of the image_t type or of the real_2d_t one?
    !---------------------------------------------------------------------
    class(image_t), intent(inout) :: image
    type(image_t),  intent(in)    :: reference
    logical,        intent(inout) :: error
    !
    integer(kind=pixe_k) :: ix,iy
    character(len=*), parameter :: rname='IMAGE>BLANK>LIKE'
    !
    call cubeadm_message(admseve%trace,rname,'Welcome')
    !
    do iy=1,image%ny
       do ix=1,image%nx
          if (ieee_is_nan(reference%val(ix,iy))) image%val(ix,iy) = gr4nan
       enddo ! ix
    enddo ! iy
  end subroutine image_blank_like
  !
  function image_task_num(image)
    !-------------------------------------------------------------------
    ! Return the task number this image_t is running with
    !-------------------------------------------------------------------
    integer(kind=entr_k) :: image_task_num
    class(image_t), intent(in) :: image
    !
    if (associated(image%task)) then
      image_task_num = image%task%num
    else
      ! Assume single thread
      image_task_num = 1
    endif
  end function image_task_num
end module cubeadm_image_types
!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
