module cubetuple_finalize
  use cube_types
  use cubeio_desc
  use cubeio_interfaces_public
  use cubetuple_messaging

  public :: cubetuple_finalize_cube
  private

contains

  subroutine cubetuple_finalize_cube(cub,error)
    !---------------------------------------------------------------------
    ! 
    !---------------------------------------------------------------------
    type(cube_t), intent(inout) :: cub
    logical,      intent(inout) :: error
    !
    character(len=*), parameter :: rname='FINALIZE>CUBE'
    !
    if (.not.associated(cub%tuple%current)) then
      ! This can happen in error recovery mode
      return
    endif
    !
    if (cub%tuple%trans%do.ne.code_trans_none) then
      call cubetuple_message(seve%d,rname,  &
        'Finalizing the tuple but a transposition is pending')
      ! Two possibilities:
      ! - If the next command needs the direct access, there is no point
      !   performing this transposition.
      ! - If the next command needs the transposed access, we will re-
      !   prepare it from scratch. As of today leaving remnants breaks
      !   the transposition preparation.
      ! => forget the transposition preparation
      call cubeio_desc_reset(cub%tuple%cube(cub%tuple%trans%to)%desc,error)
      if (error)  continue
      call cubetuple_trans_reset(cub%tuple%trans,error)
      if (error)  continue
    endif
    !
    ! ZZZ Should we finalize all cubes or only the current one?
    call cubeio_finalize_cube(cub%user,cub%head,cub%tuple%current,error)
    if (error)  return
  end subroutine cubetuple_finalize_cube

end module cubetuple_finalize
