!
subroutine t_setextrema(h,rmi,jmi,rma,jma)
  use gkernel_interfaces
  use gildas_def
  use image_def
  !------------------------------------------------
  ! @ public
  !
  ! MAPPING
  !   Put extrema into the specified header
  !------------------------------------------------
  type (gildas), intent(inout), target :: h
  real(kind=4), intent(in) :: rmi     ! Value of minimum
  integer(kind=size_length), intent(in) :: jmi  ! Position of minimum
  real(kind=4), intent(in) :: rma     ! Value of maximum
  integer(kind=size_length), intent(in) :: jma  ! Position of maximum
  !
  integer(kind=8) :: ilong 
  !
  h%gil%rmax = rma
  h%gil%rmin = rmi
  ilong = jmi
  call gdf_index_to_where (ilong,h%gil%ndim,h%gil%dim,h%gil%minloc)  
  ilong = jma
  call gdf_index_to_where (ilong,h%gil%ndim,h%gil%dim,h%gil%maxloc)  
  h%gil%extr_words = def_extr_words                ! extrema computed
end subroutine t_setextrema
!
subroutine map_minmax(hmap)
  use image_def
  use gkernel_interfaces
  !
  type(gildas), intent(inout) :: hmap
  real :: rmi,rma
  logical :: error
  !
  if (hmap%gil%eval.lt.0) then
    hmap%gil%minloc = 1
    hmap%gil%maxloc = 1
    hmap%gil%minloc(1:3) = minloc(hmap%r3d)
    hmap%gil%maxloc(1:3) = maxloc(hmap%r3d)
    rma = hmap%r3d(hmap%gil%maxloc(1),hmap%gil%maxloc(2),hmap%gil%maxloc(3))
    rmi = hmap%r3d(hmap%gil%minloc(1),hmap%gil%minloc(2),hmap%gil%minloc(3))
    hmap%gil%rmax = rma
    hmap%gil%rmin = rmi
  else
    hmap%loca%addr = locwrd(hmap%r3d)
    call gdf_get_extrema (hmap,error)
  endif
  hmap%gil%extr_words = def_extr_words  ! extrema computed
end subroutine map_minmax
