!     $Id: modulePakoSwTotalPower.f90,v 1.1 2005/06/22 14:46:29 ungerech Exp $
!     
!     Family:   SWITCH 
!     Siblings:        modulePakoSwBeam.f90
!     Siblings:        modulePakoSwFrequency.f90
!     Siblings:        modulePakoSwSpecial.f90
!     Siblings:        modulePakoSwTotalPower.f90
!     Siblings:        modulePakoSwWobbler.f90
!
!----------------------------------------------------------------------
!     PAKO module for  swTotalPower
!
Module modulePakoSwTotalPower
  !
  Use modulePakoMessages
  Use modulePakoGlobalParameters
  Use modulePakoLimits
  Use modulePakoXML
  Use modulePakoDisplayText
  Use modulePakoGlobalVariables
  Use modulePakoSwBeam
!!$  Use modulePakoSwFrequency
  Use modulePakoSwWobbler
  !
  Implicit None
  Save
  Private
  Public :: swTotalPower, saveSwitching
  Public :: saveSwTotalPower, writeXMLswTotalPower
  !     
  ! *** Variables for swTotalPower ***
  Include 'inc/variables/variablesSwTotalPower.inc'
  !
Contains
!!!
  Subroutine swTotalPower(programName,line,command,                 &
       &         error)
    !
    ! *** Arguments: ***
    Include 'inc/variables/headerForCommandHandler.inc'
    !
    ! *** standard working variables   ***
    Include 'inc/variables/standardWorkingVariables.inc'
    !
    ! TBD: the following shall be replaced by a SR reading from XML:
    Include 'inc/ranges/rangesSwTotalPower.inc'
    !
    !D      Write (6,*) " module swTotalPower ---> SR: swTotalPower "
    !D      Write (6,*) "                          "
    !D      Write (6,*) "        swModeSelected:   ", swModeSelected
    !
    ! *** initialize:   ***
    If (.Not.isInitialized) Then
       Include 'inc/variables/setDefaults.inc'
       isInitialized = .True.
    Endif
    !
    ! *** set In-values = previous Values   ***
    If (.Not.ERROR) Then
       vars(iIn) = vars(iValue)
    End If
    !
    ! *** check N of Parameters: 0, n --> at  most n allowed  ***
    ! *** read Parameters, Options (to detect errors)         ***
    ! *** and check for validity and ranges                   ***
    Call checkNofParameters(command,                                 &
         &     0, 0,                                                       &
         &     nArguments,                                                 &
         &     errorNumber)
    ERROR = ERROR .Or. errorNumber
    If (.Not. ERROR) Then
       Include 'inc/options/readOptionsSwTotalPower.inc'
    End If
    !
    ! *** set defaults   ***
    If (.Not. ERROR) Then
       option = 'DEFAULTS'
       Call indexCommmandOption                                      &
            &        (command,option,commandFull,optionFull,                  &
            &        commandIndex,optionIndex,iCommand,iOption,               &
            &        errorNotFound,errorNotUnique)
       setDefaults = SIC_PRESENT(iOption,0)
       If (setDefaults) Then
          Include 'inc/variables/setDefaults.inc'
       Endif
    Endif
    !
    ! *** read Parameters, Options (again, after defaults!)   ***
    ! *** and check for validity and ranges                   ***
    If (.Not. ERROR) Then
       Include 'inc/options/readOptionsSwTotalPower.inc'
    End If
    !
    ! *** check consistency and                           ***
    ! *** store into temporary (intermediate) variables   ***
    If (.Not.ERROR) Then
       !
       If (.Not. errorInconsistent) Then
          vars(iTemp) = vars(iIn)
       End If
       !
    End If
    !
    ERROR = ERROR .Or. errorInconsistent
    !
    ! *** store from Temp into persistent variables   ***
    If (.Not.ERROR) Then
       vars(iValue) = vars(iTemp)
    End If
    !
    ! *** display values ***
    !     (Note: this is done independantly of the Error status)
    Include 'inc/display/commandDisplaySwTotalPower.inc'
    !
    ! *** set "selected" switching mode ***
    If (.Not.error) Then
       GV%switchingMode = command
       Write (6,*) " GV%switchingMode ", GV%switchingMode
       !D         Write (6,*) "        swModeSelected:   ", swModeSelected
       !D         Write (6,*) "        switchingMode:    ", switchingMode
       write (messageText,*)                                         & 
            &         'Switching Mode selected: ',                            &
            &         GV%switchingMode,                                          &
            &         ' '
       CALL pakoMessage(priorityI,severityI,command,messageText)
       swTotalPowerCommand = line(1:lenc(line))
    End If
    !
    Return
  End Subroutine swTotalPower
!!!
!!!
  Subroutine saveSwitching(programName,LINE,commandToSave,           &
       &        iUnit, ERROR)
    !
    ! *** Variables   ***
    Include 'inc/variables/headerForSaveMethods.inc'
    !
!!$      write (6,*) "   --> SR saveSwitching "
!!$      write (6,*) "       switchingMode:   ", switchingMode
    !
    Select Case (GV%switchingMode)
    Case("SWBEAM")
       call saveSwBeam(programName,LINE,commandToSave,                 &
            &        iUnit, ERROR)
!!$    Case("SWFREQUENCY")
!!$       call saveSwFrequency(programName,LINE,commandToSave,            &
!!$            &        iUnit, ERROR)
    Case("SWWOBBLER")
       call saveSwWobbler(programName,LINE,commandToSave,              &
            &        iUnit, ERROR)
    Case("SWTOTAL")
       call saveSwTotalPower(programName,LINE,commandToSave,           &
            &        iUnit, ERROR)
    Case default
       call saveSwTotalPower(programName,LINE,commandToSave,           &
            &        iUnit, ERROR)
    End Select
    !
    Return
  End Subroutine saveSwitching
!!!
!!!
  Subroutine saveSwTotalPower(programName,LINE,commandToSave,      &
       &        iUnit, ERROR)
    !
    ! *** Variables   ***
    Include 'inc/variables/headerForSaveMethods.inc'
    !
    contC = contNN
    !
    B = '\'
    S = ' '
    CMD =  programName//B//"SWTOTAL"
    lCMD = lenc(CMD)
    !
    ERROR = .false.
    !
    write (iUnit,*) "! "
    write (iUnit,*) "! ", CMD(1:lCMD)
    write (iUnit,*) CMD(1:lCMD), " -"
    !
    contC = contCN
    !
    Include 'inc/options/saveTphase.inc'
    !
    Write (iUnit,*) "!"
    !
    Return
  End Subroutine saveSwTotalPower
!!!
!!!
  Subroutine writeXMLswTotalPower(programName,LINE,commandToSave,      &
       &        iUnit, ERROR)
    !
    ! *** Variables   ***
    Include 'inc/variables/headerForSaveMethods.inc'
    !
    character (len=24) :: valueC
    real               :: value
    logical :: errorXML
    !
    ERROR = .False.
    !
    !      write (6,*)  "      modulePakoSwTotalPower --> SR: writeXMLTotalPower "
    !
    include 'inc/startXML/swTotalPower.inc'
    !
    Return
  End Subroutine writeXMLswTotalPower
!!!
End Module modulePakoSwTotalPower
!!!








