!     $Id: modulePakoSwFrequency.f90,v 1.1 2005/06/22 14:46:29 ungerech Exp $
!     
!     Family:   SWITCH 
!     Siblings:        pakoSwBeam.f
!     Siblings:        pakoSwFrequency.f
!     Siblings:        pakoSwSpecial.f
!     Siblings:        pakoSwWobbler.f
!     Siblings:        pakoSwTotalPower.f
!
!----------------------------------------------------------------------
!     PAKO module for  swFrequency
!
Module modulePakoSwFrequency
  !
  Use modulePakoMessages
  Use modulePakoGlobalParameters
  Use modulePakoLimits
  Use modulePakoXML
  Use modulePakoDisplayText
  Use modulePakoGlobalVariables
  !
  Implicit None
  Save
  Private
  Public :: swFrequency, saveSwFrequency
  !     
  ! *** Variables for swFrequency ***
  Include 'inc/variables/variablesSwFrequency.inc'
  !     
!!!   
Contains
!!!
  Subroutine swFrequency(programName,line,command,                 &
       &        error)
    !
    ! *** Arguments: ***
    Include 'inc/variables/headerForCommandHandler.inc'
    !
    ! *** standard working variables   ***
    Include 'inc/variables/standardWorkingVariables.inc'
    !
    !     TBD: the following shall be replaced by a SR reading from XML:
    Include 'inc/ranges/rangesSwFrequency.inc'
    !
    !D    Write (6,*) " module swFrequency ---> SR: swFrequency "
    !D    Write (6,*) "                          "
    !D    Write (6,*) "        swModeSelected:   ", swModeSelected
    !
    ! *** initialize:   ***
    If (.Not.isInitialized) Then
       Include 'inc/variables/swFrequencySetDefaults.inc'
       isInitialized = .True.
    Endif
    !
!!$      l = lenc(vars(iDefault)%receiverName)
!!$      write (6,*) "     l:     ",l
!!$      write (6,*) "   vars(iDefault)%receiverName   ->",                 &
!!$     &       vars(iDefault)%receiverName(1:l),"<-"
!!$      l = lenc(vars(iValue)%receiverName)
!!$      write (6,*) "     l:     ",l
!!$      write (6,*) "   vars(iValue)%receiverName   ->",                 &
!!$     &       vars(iValue)%receiverName(1:l),"<-"
!!$!
    ! *** set In-values = previous Values   ***
    If (.Not.ERROR) Then
       vars(iIn) = vars(iValue)
    End If
    !
    ! *** check N of Parameters: 0, n --> at  most n allowed  ***
    ! *** read Parameters, Options (to detect errors)         ***
    ! *** and check for validity and ranges                   ***
    call checkNofParameters(command,                                 &
         &     0, 4,                                                       &
         &     nArguments,                                                 &
         &     errorNumber)
    ERROR = ERROR .or. errorNumber
    If (.Not. ERROR) Then
       Include 'inc/parameters/parametersFoffsets.inc'      
       Include 'inc/options/readOptionsSwFrequency.inc'
    End If
    !
    ! *** set defaults   ***
    If (.Not. ERROR) Then
       option = 'DEFAULTS'
       Call indexCommmandOption                                      &
            &        (command,option,commandFull,optionFull,                  &
            &        commandIndex,optionIndex,iCommand,iOption,               &
            &        errorNotFound,errorNotUnique)
       setDefaults = SIC_PRESENT(iOption,0)
       If (setDefaults) Then
          Include 'inc/variables/swFrequencySetDefaults.inc'
       Endif
    Endif
    !
    ! *** read Parameters, Options (again, after defaults!)   ***
    ! *** and check for validity and ranges                   ***
    If (.Not. ERROR) Then
       Include 'inc/parameters/parametersFoffsets.inc'
       Include 'inc/options/readOptionsSwFrequency.inc'
    End If
    !
    ! *** check consistency and                           ***
    ! *** store into temporary (intermediate) variables   ***
    If (.Not.ERROR) Then
       !
       !TBD     INCLUDE 'inc/options/checkConsistentFoffsetsNphase.inc'
       !TBD     INCLUDE 'inc/options/checkConsistentTblankingTphase.inc'
       !
       If (.Not. errorInconsistent) Then
          vars(iTemp) = vars(iIn)
       End If
       !
    End If
    !
    ERROR = ERROR .Or. errorInconsistent
    !
    ! *** store from Temp into persistent variables   ***
    If (.Not.ERROR) Then
       vars(iValue) = vars(iTemp)
    End If
    !
    ! *** display values  ***
    !     (Note: this is done independantly of the Error status)
    Include 'inc/display/commandDisplaySwFrequency.inc'
    !
    ! *** set "selected" switching mode ***
    If (.Not.error) Then
       GV%switchingMode = command
       !D         Write (6,*) "        swModeSelected:   ", swModeSelected
       !D         Write (6,*) "        switchingMode:    ", switchingMode
       write (messageText,*)                                         &
            &         'Switching Mode selected: ',                            &
            &          GV%switchingMode ,                                          &
            &         ' '
       CALL pakoMessage(6,1,command,messageText)
    End If
    !
    Return
  End Subroutine swFrequency
!!!
  Subroutine saveSwFrequency(programName,LINE,commandToSave,       &
       &        iUnit, ERROR)
    !
    ! *** Variables   ***
    Include 'inc/variables/headerForSaveMethods.inc'
    !
    contC = contNN
    !
    B = '\'
    S = ' '
    CMD =  programName//B//"SWFREQUENCY"
    lCMD = lenc(CMD)
    !
    ERROR = .false.
    !
    write (iUnit,*) "! "
    write (iUnit,*) "! ", CMD(1:lCMD)
    write (iUnit,*) CMD(1:lCMD), " -"
    !
    contC = contCC
    !
    include 'inc/parameters/saveFoffsets.inc'
    !
    include 'inc/options/saveFunction.inc'
    include 'inc/options/saveNphases.inc'
    include 'inc/options/saveReceiver.inc'
    include 'inc/options/saveTblanking.inc'
    !
    contC = contCN
    !
    include 'inc/options/saveTphase.inc'
    !
    write (iUnit,*) "!"
    !
    Return
  End Subroutine saveSwFrequency
!!!
End Module modulePakoSwFrequency
!!!





