!
      catalogOpen = .False.
!
      error  = .False.
      errorL = .False.
      errorC = .False.
      errorR = .False.
!
! *** Source name
      If (SIC_NARG(0).Ge.1.) Then
         iOption   = 0
         iArgument = 1
         Call SIC_CH(LINE,iOption,iArgument,                           &
     &        cInput,lengthInput,.True.,errorC)
         cInputUpper = cInput
!!$         Call SIC_UPPER(cInputUpper)
      Else
         errorL = .True.
         messageText =                                                 &
     &        "no source name specified"
         Call pakoMessage(priorityE,severityE,command,messageText)
      End If
!
      error = error .Or. errorC
!
      If (errorC) Then
         messageText =                                                 &
     &        "source name invalid"
         Call pakoMessage(priorityE,severityE,command,messageText)
      Else If (.Not. errorL) Then
         vars(iIn)%sourceName = cInputUpper
      End If
!
      If (.Not. error) Then
!
! *** solar system BODY
!
         If (cInputUpper .EQ. "BODY") Then
!
            If (SIC_NARG(0).Le.8 .And. SIC_NARG(0).Ge.8) Then
!
               messageText =                                                    &
                    &        "seems to mean solar system BODY ..."
               Call pakoMessage(priorityI,severityI,command//' BODY',messageText)
               !
               !
               ! *** Body name
               iOption   = 0
               iArgument = 2
               Call SIC_CH(LINE,iOption,iArgument,                              &
                    &        cInput,lengthInput,.True.,errorC)
               cInputUpper = cInput
               !
               If (.Not. errorC .And. cInput(1:1).Ne.'*') Then
                   vars(iIn)%sourceName = cInput
               Else
                  errorL = .True.
                  messageText =                                                 &
                       &        "no body name specified"
                  Call pakoMessage(priorityE,severityE,command,messageText)
               End If
               !
               error = error .Or. errorC .Or. errorL
               !
               iArgument = 3
               If (SIC_PRESENT(0,iArgument)) Then
                  Call SIC_CH(LINE,0,iArgument,                                 &
                       &           cInput100,lengthInput,.False.,errorC)
                  If (cInput100(1:1).Ne.'*') Then
                     Call SIC_R8(LINE,iOption,iArgument,dInput,.False.,errorR)
!D                     Write (6,*) "   cInput100 :  ", cInput100(1:lengthInput)
!D                     Write (6,*) "   dInput    :  ", dInput
!D                     Write (6,*) "   errorC    :  ", errorC
!D                     Write (6,*) "   errorR    :  ", errorR
                     If (.Not. errorR) then
                        Call checkR8(command,dInput,                            &
                             &               vars%perihelionEpoch,              &
                             &               errorR)
                     Endif
                  Endif
               End If
               !
               error = error .Or. errorC .Or. errorR
               !
               iArgument = 4
               If (SIC_PRESENT(0,iArgument)) Then
                  Call SIC_CH(LINE,0,iArgument,                                 &
                       &           cInput100,lengthInput,.False.,errorC)
                  If (cInput100(1:1).Ne.'*') Then
                     Call SIC_R8(LINE,iOption,iArgument,dInput,.False.,errorR)
                     If (.Not. errorR) then
                        Call checkR8(command,dInput,                            &
                             &               vars%ascendingNode,                &
                             &               errorR)
                     Endif
                  Endif
               End If
               !
               error = error .Or. errorC .Or. errorR
               !
               iArgument = 5
               If (SIC_PRESENT(0,iArgument)) Then
                  Call SIC_CH(LINE,0,iArgument,                                 &
                       &           cInput100,lengthInput,.False.,errorC)
                  If (cInput100(1:1).Ne.'*') Then
                     Call SIC_R8(LINE,iOption,iArgument,dInput,.False.,errorR)
                     If (.Not. errorR) then
                        Call checkR8(command,dInput,                            &
                             &               vars%argumentOfPerihelion,         &
                             &               errorR)
                     Endif
                  Endif
               End If
               !
               error = error .Or. errorC .Or. errorR
               !
               iArgument = 6
               If (SIC_PRESENT(0,iArgument)) Then
                  Call SIC_CH(LINE,0,iArgument,                                 &
                       &           cInput100,lengthInput,.False.,errorC)
                  If (cInput100(1:1).Ne.'*') Then
                     Call SIC_R8(LINE,iOption,iArgument,dInput,.False.,errorR)
                     If (.Not. errorR) then
                        Call checkR8(command,dInput,                            &
                             &               vars%inclination,                  &
                             &               errorR)
                     Endif
                  Endif
               End If
               !
               error = error .Or. errorC .Or. errorR
               !
               iArgument = 7
               If (SIC_PRESENT(0,iArgument)) Then
                  Call SIC_CH(LINE,0,iArgument,                                 &
                       &           cInput100,lengthInput,.False.,errorC)
                  If (cInput100(1:1).Ne.'*') Then
                     Call SIC_R8(LINE,iOption,iArgument,dInput,.False.,errorR)
                     If (.Not. errorR) then
                        Call checkR8(command,dInput,                            &
                             &               vars%perihelionDistance,           &
                             &               errorR)
                     Endif
                  Endif
               End If
               !
               error = error .Or. errorC .Or. errorR
               !
               iArgument = 8
               If (SIC_PRESENT(0,iArgument)) Then
                  Call SIC_CH(LINE,0,iArgument,                                 &
                       &           cInput100,lengthInput,.False.,errorC)
                  If (cInput100(1:1).Ne.'*') Then
                     Call SIC_R8(LINE,iOption,iArgument,dInput,.False.,errorR)
                     If (.Not. errorR) then
                        Call checkR8(command,dInput,                            &
                             &               vars%eccentricity,                 &
                             &               errorR)
                     Endif
                  Endif
               End If
               !
               error = error .Or. errorC .Or. errorR
!
               If (.Not. ERROR) Then
                  vars(iIn)%isBody     = .True.
               End If
               !
            Else
                messageText =                                                 &
                    &        "body's name + 6 more arguments are required"
               Call pakoMessage(priorityE,severityE,command//' BODY',messageText)
               ERROR = .True.
               vars(iIn)%isBody     = .False.
            End If
         Else
            vars(iIn)%isBody     = .False.
         End If
!
! *** Look for planets or satellites if syntax is: "SOURCE something"
         If (SIC_NARG(0).Eq.1.) Then
!
            errorNotFound         = .False.
            errorNotUnique        = .False.
            choiceIndex = 0
!
            Do ii = 1,9,1
!           TBD: number of choices should be a variable
!           TBD:  match regardless of case
               If (planetNameChoices(ii) .Eq.                          &
      &            cInputUpper(1:lengthInput) ) Then
                  If (choiceIndex .Eq. 0) Then
                     choiceIndex = ii
                  Else
                     errorNotUnique = .True.
                  End If
               End If
            End Do
            errorNotFound =  choiceIndex .Eq. 0
!
            vars(iIn)%isPlanet =                                       &
      &               .Not. (errorNotUnique .Or. errorNotFound)
            If (vars(iIn)%isPlanet) Then
               vars(iIn)%isSatellite = .False.
               vars(iIn)%sourceName = planetNameChoices(choiceIndex)
            End If
!
            If (.Not. (vars(iIn)%isPlanet) ) Then
               Do ii = 1,2,1
!           TBD: number of choices should be a variable
                  If (satelliteNameChoices(ii) .Eq.                    &
      &               cInputUpper(1:lengthInput) ) Then
                     If (choiceIndex .Eq. 0) Then
                        choiceIndex = ii
                     Else
                        errorNotUnique = .True.
                     End If
                  End If
               End Do
               errorNotFound =  choiceIndex .Eq. 0
!
               vars(iIn)%isSatellite =                                 &
      &               .Not. (errorNotUnique .Or. errorNotFound)
               If (vars(iIn)%isSatellite) Then
                  vars(iIn)%isPlanet = .False.
                  vars(iIn)%sourceName =                               &
      &                       satelliteNameChoices(choiceIndex)
               End If
!
            End If
!
            If (vars(iIn)%isPlanet .Or. vars(iIn)%isSatellite) Then
!
               vars(iIn)%systemName = "PL"
               vars(iIn)%epoch      = 2000.0
               vars(iIn)%longitude%name="longitude  "
               vars(iIn)%longitude%text="  :  :  "
               vars(iIn)%longitude%rad=0.0d0
               vars(iIn)%longitude%deg=0.0d0
               vars(iIn)%longitude%hour=0.0d0
               vars(iIn)%latitude%name="latitude  "
               vars(iIn)%latitude%text="  :  :  "
               vars(iIn)%latitude%rad=0.0d0
               vars(iIn)%latitude%deg=0.0d0
               vars(iIn)%latitude%hour=0.0d0
               vars(iIn)%velocity%name="radialVelo"
               vars(iIn)%velocity%type="none"
               vars(iIn)%velocity%unit="km/s"
               vars(iIn)%velocity%value=0.0
               vars(iIn)%flux=0.0
               vars(iIn)%index=0.0
!
            End If
!
         Else If (SIC_NARG(0).Gt.1.) Then
!
            vars(iIn)%isPlanet     = .False.
            vars(iIn)%isSatellite  = .False.
!
         End If
!
      End If
!
!D      Write (6,*) "     vars(iIn)%isPlanet:    ", vars(iIn)%isPlanet   
!D      Write (6,*) "     vars(iIn)%isSatellite: ", vars(iIn)%isSatellite
!
      If (      .Not.vars(iIn)%isBody                                  &
     &    .And. .Not.vars(iIn)%isPlanet                                &
     &    .And. .Not.vars(iIn)%isSatellite ) Then
!
      If (.Not.error) Then
!
      If (SIC_PRESENT(0,2)) Then
! *** Source coordinates are in command line
!
         ii = Index(line,'/')
         If (ii.Eq.0) ii = LENC(line)+1
         cInputLong  = line(12:ii-1)                   ! skip language, command, and options
         lengthInput = LENC(cInputLong)
         Call SIC_BLANC(cInputLong,lengthInput)
!
         nPar = 1
         lPar = 12
         Call SIC_NEXT (cInputLong,cPar,lPar,nPar)     ! skip source name
         errorNotFound = .False.
!
!D         Write (6,*) "    lengthInput: ",lengthInput
!D         Write (6,*) "    cInputLong ->",cInputLong(1:lengthInput),"<-"
!D         Write (6,*) "    nPar:        ",nPar
!D         Write (6,*) "    lPar:        ",lPar
!D         Write (6,*) "    cPar       ->",cPar(1:lenc(cPar)),"<-"
!
      Else  
! *** Source coordinates should be in catalog
!
         cFile = GVsourceCatalog(1)
!
!D         Write (6,*) "    cFile ->",                                   &
!D     &                    cFile(1:lenc(cFile)),"<-"
!
         If (LENC(cFile).Eq.0) Then
            errorNotFound = .True.
            messageText =                                              &
     &        "no source catalog specified"
            Call pakoMessage(6,3,command,messageText)
         Else
! TBD: use get_lun
            Close(UNIT=10)
            Open(unit=10, action='read', file=cFile(1:lenc(cFile)),    &
                 &                 status='old', iostat=ier)
            If (ier .Gt. 0) Then
               messageText =                                           &
     &        "could not open source catalog: "//cFile(1:lenc(cFile))
               Call pakoMessage(6,3,command,messageText)
            Else
               catalogOpen = .True.
               found = .False.
               ioerr = 0
!
               Do While (.Not. found .And. ioerr.Eq.0)
                  Read(10,'(Q,A)',iostat=ioerr) lengthInput, cInputLong
!
!        ignore empty lines & comments 
                  If (lengthInput.Gt.0 .And. cInputLong(1:1).Ne.'!') Then
                     Call SIC_BLANC(cInputLong,lengthInput)
!D                     Write (6,*) "    lengthInput: ",lengthInput
!D                     Write (6,*) "    cInputLong ->",cInputLong(1:lengthInput),"<-"
                     nPar = 1
                     lPar = 36
                     Call SIC_NEXT(cInputLong,cPar,lPar,nPar)
!D                     Write (6,*) "    nPar:        ",nPar
!D                     Write (6,*) "    lPar:        ",lPar
!D                     Write (6,*) "    cPar       ->",cPar(1:lenc(cPar)),"<-"
                     If (lPar.Ne.0) Then
                        found = .False.
                        name  = vars(iIn)%sourceName
                        lname = lenc(name)
                        Call CHECKSOURCE(name,lname,cPar,lPar,found)
!D                        Write (6,*) "    lname:       ",lname
!D                        Write (6,*) "    name       ->",name(1:lenc(name)),"<-"
!D                        Write (6,*) "    lPar:        ",lPar
!D                        Write (6,*) "    cPar       ->",cPar(1:lenc(cPar)),"<-"
                     Endif
                  Endif
               Enddo
               Close(UNIT=10)
!
               If (found) Then
                  errorNotFound = .False.
                  errorSourceNotInCatalog = .False.
                  vars(iIn)%sourceName = cPar(1:lenc(cPar))
               Else
                  errorNotFound = .True.
                  errorSourceNotInCatalog = .True.
                  messageText =                                                 &
      &           "source not found in catalog: "//cFile(1:lenc(cFile))
                  Call pakoMessage(6,3,command,messageText)
               End If
!
            End If
!
         End If
!
      End If
      End If
!
      error = error .Or. errorNotFound
!
      If (.Not. ERROR) Then
!
! *** coordinate system and epoch
!
         nPar1 = nPar                                     ! position system  
         lPar  = 2
         Call SIC_NEXT (cInputLong(nPar:),cPar,lPar,nPar) ! system type ?
!
         If (lpar.Gt.0) Then
!
            ioerr = 0
!
            Call SIC_UPPER(cPar)
!
! TBD: other systems, check in systemNameChoices
            If (cPar(1:2).Eq.'EQ') Then
               cPar = "EQ"
               lPar = 12
               Call SIC_NEXT(cInputLong(nPar:),cPar2,lPar,nPar)     ! Epoch ?
               If (lPar.Gt.0) Then
                  Read(cPar2(1:lPar),'(F20.0)',iostat=ioerr) EPOCH
!D                  Write (6,*) "    ioerr:        ",ioerr
               End If
            Elseif (cPar(1:2).Eq.'GA') Then
               cPar = "GA"
            Elseif (cPar(1:2).Eq.'EC') Then
               cPar = "EC"
               lPar = 12
               Call SIC_NEXT(cInputLong(nPar:),cPar2,lPar,nPar)     ! Epoch
               If (lPar.Gt.0) Then
                  Read(cPar2(1:lPar),'(F20.0)',iostat=ioerr) EPOCH
!D                  Write (6,*) "    ioerr:        ",ioerr
               End If
            Elseif (cPar(1:2).Eq.'HO') Then
               cPar = "HO"
            Else
               cPar = "EQ"
               nPar  = nPar1
               cPar  = 'EQ'
               epoch = 1950.0
            End If
!
            If (ioerr.Eq.0) Then
               vars(iIn)%systemName = cPar(1:lenc(cPar))
               Call checkR4(command,epoch,                             &
                    vars%epoch,                                        &
                    errorR)
               If (.Not. errorR) Then
                  vars(iIn)%epoch      = epoch
               End If
               error = error .Or. errorR
            Else
               error = .True.
               messageText =                               &
                    "error decoding system name and epoch "&
                    &//cPar(1:2)//" "//cPar2(1:lPar)
               Call pakoMessage(6,3,command,messageText)
            End If
!
!D            Write (6,*) "  vars(iIn)%systemName:     ",                     &
!D                 vars(iIn)%systemName       
!D            Write (6,*) "  vars(iIn)%epoch:          ",                     &
!D                 vars(iIn)%epoch
!D!
         End If
!
      End If   ! ERROR
!
      If (.Not. ERROR) Then
         !
         ! *** longitude
         errorR = .False.
         lPar = 40
         Call SIC_NEXT(cInputLong(nPar:),cPar,lPar,nPar) 
!
!D         Write (6,*) "    cInputLong ->",cInputLong(1:lengthInput),"<-"
!D         Write (6,*) "    nPar:        ",nPar
!D         Write (6,*) "    lPar:        ",lPar
!D         Write (6,*) "    cPar       ->",cPar(1:lPar),"<-"
!
         If (lPar.Gt.0 ) Then
            Call SUFFIX(cPar,lPar,LAMBDA1,LAMBDA2)
!!$            Write (6,*) "   lambda1: ", lambda1
!!$            Write (6,*) "   lambda2: ", lambda2
            If (vars(iIn)%systemName .Eq. 'EQ') Then
               Call CVDEG(cPar,lPar,'H',LAMBDA,errorR) ! decode alpha Hours
               LAMBDA1 = LAMBDA1 /3600/12*PI
               LAMBDA2 = LAMBDA2 /3600/12*PI
            Else
               Call CVDEG(cPar,lPar,'D',LAMBDA,errorR) ! decode alpha Deg
               LAMBDA1 = LAMBDA1 /3600/180*PI
               LAMBDA2 = LAMBDA2 /3600/180*PI
            Endif
            !
            !D         Write (6,*) "   lambda: ", lambda
            !
            If (.Not. errorR) Then
               Call checkR8(command,lambda,                             &
                    vars%longitude%rad,                                        &
                    errorR)
               If (.Not. errorR) Then
                  vars(iIn)%longitude%name="longitude  "
                  vars(iIn)%longitude%text=cPar(1:12)
                  vars(iIn)%longitude%rad=lambda
                  vars(iIn)%longitude%deg=vars(iIn)%longitude%rad/degs
                  vars(iIn)%longitude%hour=vars(iIn)%longitude%rad/degs/15.0d0
               Else
                  messageText =                               &
                       "offending input: "&
                       &//cPar(1:12)
                  Call pakoMessage(6,3,command,messageText)
               End If
               error = error .Or. errorR
            End If
            !
            !D      Write (6,*) "  vars(iIn)%longitude%name: ",                      &
            !D     &               vars(iIn)%longitude%name
            !D      Write (6,*) "  vars(iIn)%longitude%text: ",                      &
            !D     &               vars(iIn)%longitude%text
            !D      Write (6,*) "  vars(iIn)%longitude%rad: ",                       &
            !D     &               vars(iIn)%longitude%rad
            !D      Write (6,*) "  vars(iIn)%longitude%hour: ",                      &
            !D     &               vars(iIn)%longitude%hour
            !D      Write (6,*) "  vars(iIn)%longitude%deg: ",                       &
            !D                     vars(iIn)%longitude%deg
            !D
!
         End If  ! lPar
      End If     ! ERROR
!
      If (.Not. ERROR) Then
!
         ! *** latitude
         errorR = .False.
         lPar = 40
         Call SIC_NEXT(cInputLong(nPar:),cPar,lPar,nPar)
!
         If (lPar.Gt.0 ) Then
            Call SUFFIX(cPar,lPar,BETA1,BETA2)
!D            Write (6,*) "   beta1: ", beta1
!D            Write (6,*) "   beta2: ", beta2
            BETA1 = BETA1 /3600/180*PI
            BETA2 = BETA2 /3600/180*PI
            Call CVDEG(cPar,lPar,'D',BETA,ERROR)       ! decode delta Deg
            !
            !D         Write (6,*) "   beta: ", beta
            !
            If (.Not. errorR) Then
               Call checkR8(command,beta,                              &
                   &vars%latitude%rad,                                 &
                   &errorR)
               If (.Not. errorR) Then
                  vars(iIn)%latitude%name="latitude  "
                  vars(iIn)%latitude%text=cPar(1:12)
                  vars(iIn)%latitude%rad=beta
                  vars(iIn)%latitude%deg=vars(iIn)%latitude%rad/degs
                  vars(iIn)%latitude%hour=vars(iIn)%latitude%rad/degs/15.0d0
               Else
                  messageText =                               &
                       "offending input: "&
                       &//cPar(1:12)
                  Call pakoMessage(6,3,command,messageText)
               End If
               error = error .Or. errorR
            End If
            !
            !D      Write (6,*) "  vars(iIn)%latitude%name: ",                      &
            !D     &               vars(iIn)%latitude%name
            !D      Write (6,*) "  vars(iIn)%latitude%text: ",                      &
            !D     &               vars(iIn)%latitude%text
            !D      Write (6,*) "  vars(iIn)%latitude%rad: ",                       &
            !D     &               vars(iIn)%latitude%rad
            !D      Write (6,*) "  vars(iIn)%latitude%hour: ",                      &
            !D     &               vars(iIn)%latitude%hour
            !D      Write (6,*) "  vars(iIn)%latitude%deg: ",                       &
            !D                     vars(iIn)%latitude%deg
            !D
!
         End If  ! lPar
      End If     ! ERROR
!
!
      If (.Not. ERROR) Then
!
! *** velocity
      nPar1 = nPar                                       ! position vSystem
      lPar = 1
      Call SIC_NEXT (cInputLong(nPar:),cPar,lPar,nPar)
!
      If (lpar.Gt.0) Then
!
         ioerr = 0
!
         Call SIC_UPPER(cPar)
!
! TBD: other systems, check in ...Choices
! TBD: revise rules for "NUL"
!
            If (cPar(1:3).Eq."LSR") Then
               cPar = "LSR"
            Elseif (cPar(1:3).Eq."HEL") Then
               cPar = "HEL"
            Elseif (cPar(1:3).Eq."EAR") Then
               cPar = "EAR"
            Elseif (cPar(1:2).Eq."NUL") Then
               cPar = "NUL"
               vars(iIn)%velocity%value=0.0D0
            Else
               cPar = "NUL"
               vars(iIn)%velocity%value=0.0D0
            End If
!
! TBD:      correct name
            vars(iIn)%velocity%name="radialVelo"
            vars(iIn)%velocity%type=cPar(1:lenc(cPar))
            vars(iIn)%velocity%unit="km/s"
!
! *** velocity value
            lPar = 12
            Call SIC_NEXT (cInputLong(nPar:),cPar,lPar,nPar)
            If (vars(iIn)%velocity%type.Ne."NUL") Then
               If (lPar.Gt.0) Then
                  Call SUFFIX(cPar,lPar,VR1,VR2)
                  ioerr = 0
                  Read(cPar(1:lPar),'(F20.0)',iostat=ioerr) VELO
               Else
                  VELO = 0.
               Endif
            Else
               VELO = 0.
            Endif
!
            Call checkR8(command,velo,                                 &
                 vars%velocity%value,                                  &
                 errorR)
            If (.Not. errorR) Then
               vars(iIn)%velocity%value=velo
            End If
            error = error .Or. errorR
!
!D      Write (6,*) "  vars(iIn)%velocity%name:  ",                     &
!D     &               vars(iIn)%velocity%name
!D      Write (6,*) "  vars(iIn)%velocity%type:  ",                     &
!D     &               vars(iIn)%velocity%type
!D      Write (6,*) "  vars(iIn)%velocity%unit:  ",                     &
!D     &               vars(iIn)%velocity%unit
!D      Write (6,*) "  vars(iIn)%velocity%value: ",                     &
!D     &               vars(iIn)%velocity%value
!
         End If  ! lPar
      End If     ! ERROR
!
!
      If (.Not. ERROR) Then
!
! *** flux
      nPar1 = nPar
      lPar = 1
      Call SIC_NEXT (cInputLong(nPar:),cPar,lPar,nPar)
!
      Call SIC_UPPER(cPar)
!
      If (cPar(1:lPar).Eq.'FLUX') Then
         lPar = 12
         Call SIC_NEXT (cInputLong(nPar:),cPar,lPar,nPar)
      Else
         lPar = 0
      Endif
      If (lPar.Gt.0) Then
         ioerr = 0
         Read(cPar(1:lPar),'(F20.0)',iostat=ioerr) FLUX
! #1
         Call SIC_NEXT (cInputLong(nPar:),cPar,lPar,nPar)
         If (lPar.Gt.0) Then
            ioerr = 0
            Read(cPar(1:lPar),'(f20.0)',iostat=ioerr) fluxIndex
         Else
            fluxIndex = 0.
         Endif
! #1
      Else
         FLUX = 0.
         fluxIndex = 0.
      Endif
!
      vars(iIn)%flux=flux
      vars(iIn)%index=fluxIndex
!
            Call checkR4(command,flux,                                 &
                 vars%flux,                                            &
                 errorR)
            errorL = errorR
            Call checkR4(command,fluxIndex,                            &
                 vars%index,                                           &
                 errorR)
            errorL = errorL .Or. errorR
            If (.Not. errorL) Then
               vars(iIn)%flux=flux
               vars(iIn)%index=fluxIndex
            End If
            error = error .Or. errorL
!
!D      Write (6,*) "  vars(iIn)%flux:           ",                      &
!D     &               vars(iIn)%flux
!D      Write (6,*) "  vars(iIn)%index:          ",                      &
!D     &               vars(iIn)%index
!
      End If     ! ERROR
!
   End If ! .Not. isPlanet
