subroutine init_clic
  use gkernel_interfaces
  use astro_interfaces
  use gildas_def
  use gbl_message
  use clic_title
  use classic_api
  ! Global
  external :: run_clic
  include 'clic_parameter.inc'
  include 'clic_clic.inc'
  include 'clic_par.inc'
  include 'clic_dheader.inc'
  ! Local
  ! vocabulaire de CLIC
  logical :: error
  integer :: mclic
  parameter (mclic=141+8)  ! +8 : SG_TABLE command + 1 ZPASSBAND - 1 TABLE /NEW
  character(len=12) :: vocab(mclic)
  character(len=20) :: version
  character(len=message_length) :: mess
  integer(kind=address_length) :: id
#if defined(CFITSIO)
  external :: run_tifits
#endif
#if defined(SDM)
  external :: run_sdm
#endif
  !
  ! Force BLOCK DATA loading
  external clicda
  ! Data
  data vocab /   &
    ' ATMOSPHERE', '/COMPRESS', '/RESET', '/NOWRITE', '/NOMONITOR',   &
    ' BLANK', '/SPW', '/RESET',            &
    ' COMPRESS', '/TRIANGLE',   &
    ' CLONE',   &
    ' COPY', '/EXTRACT',  &
    ' CURSOR',   &
    ' DIRECTORY',   &
    ' DROP',   &
    ' DUMP', '/PLOT',   &
    ' FILE', '/WINDOW', '/DIRECTORY',   &
    ' FIND',  '/TYPE', '/LINE', '/NUMBER',   &
    '/SCAN',  '/OFFSET', '/SOURCE', '/PROCEDURE',   &
    '/QUALITY',  '/TELESCOPE', '/POLAR', '/RECEIVER',   &
    '/MODE', '/LOAD',  &
    ' FLAG', '/ANTENNA', '/BASELINE', '/RESET',   &
    ' GET',  '/RECORD', '/HEADER', '/ATM',   &
    ' GRID_TOTAL', '/PLOT',   &
    ' FITS',   &
    ' HEADER', '/PLOT',   &
    ' MARK', '/ANTENNA', '/BASELINE', '/RESET',   &
    ' IGNORE',   &
    ' LIST', '/BRIEF', '/LONG', '/OUTPUT',   &
    '/FLAG', '/SHORT', '/PROJECT',  '/SOURCE', '/VARIABLE',   &
    '/FORMAT', '/OFFSET',   &
    ' MASK', '/ANTENNA', '/BASELINE', '/RESET', '/ALL', '/SPECTRAL',  &
    ' MINMAX',   &
    ' MONITOR',   &
    ' MODIFY', '/BEFORE', '/AFTER', '/OFFSET', '/RECORD',   &
    '/POLARISATION', '/ATM', '/BBAND', '/IF',   &
    ' NEW_DATA',   &
    ' PLOT', '/NOFRAME', '/RECORD',  '/IDENTIFY',   &
    '/RESET', '/NODRAW', '/APPEND', '/PHYSICAL', '/BOXES',  &
    ' POPUP',   &
    ' PRINT',   &
    ' RESIDUALS',   &
    ' SAVE',   &
    ' SET',  '/LIMITS', '/WINDOW', '/ANTENNA',   &
    '/DEFAULT', '/RESET',   &
    ' SELECT',   &
    ' SHOW',   &
    ' SOLVE', '/PLOT', '/WEIGHT', '/OUTPUT',   &
    '/RESET', '/OFFSET', '/COMPRESS', '/SEARCH',   &
    '/BREAK', '/POLYNOMIAL', '/PRINT', '/FIX',   &
    '/TOTAL', '/IGNORE',  &
    ' STORE', '/BAND', '/ANTENNA', '/BASELINE',   &
    '/RESET', '/SELF', '/RECEIVER', '/POLARISATION', '/FRACTION',   &
    ' SG_TABLE', '/ADD', '/DROP', '/FFT', '/FREQUENCY', '/NOCHECK', '/RESAMPLE', '/POLARIZATION',  &
    ' TABLE', '/RESAMPLE', '/DROP', '/COMPRESS',   &
    '/FREQUENCY', '/NOCHECK', '/SCAN', '/FFT',   &
    '/MOSAIC', &   ! /MOSAIC replaces /POSITION and /NEW was unused
    ' TAG',   &
    ' VARIABLES',   &
    ' WVR', '/CMODE', '/NOWRITE', &
    ' ZPASSBAND' /
  !
  ! TIFITS vocabulary
  integer :: mtifits
  parameter (mtifits=8)
  character(len=12) :: vocabti(mtifits)
  character(len=20) :: versionti
  data vocabti /   &
    ' READ',   &
    ' WRITE',  '/DATA',  '/NOCAL', '/HOLOGRAPHY', '/ANTENNAS',   &
    '/TELESCOPE', '/SIMULATE'/
  !
  ! SDM vocabulary
  integer :: msdm
  parameter (msdm=8)
  character(len=12) :: vocabsdm(msdm)
  character(len=20) :: versionsdm
  data vocabsdm /   &
    ' READ',   &
    ' WRITE',  '/DATA',  '/NOCAL', '/HOLOGRAPHY', '/ANTENNAS',   &
    '/TELESCOPE', '/SIMULATE'/
  save vocab, vocabti, vocabsdm
  !
  include 'clic_version.inc'
  !
  id = locwrd(clicda)
  error = gr_error()
  r_teles = ' '
  !
  ! Check COMMON alignments
  call check_commons
  !
  !      if (vocab(mclic).ne.'/NOWRITE') STOP 'Vocab. Error'
  !
  call sic_begin('CLIC','GAG_HELP_CLIC',mclic,vocab,   &
    version//' V Pietu, R.Lucas',run_clic,gr_error)
  !
#if defined(CFITSIO)
  versionti = '1.1-01 07-May-2003'
  call sic_begin('TIFITS','GAG_HELP_TIFITS',mtifits,vocabti,   &
    versionti//' R.Lucas',run_tifits,gr_error)
#endif
  !
#if defined(SDM)
  versionsdm = '0.1-01 27-Mar-2007'
  call sic_begin('SDM','GAG_HELP_ASDM',msdm,vocabsdm,   &
    versionsdm//' R.Lucas',run_sdm,gr_error)
#endif
  !
  planet_model = -1
  skind = 4
  find_needed = .true.
  m_header = (locwrd(r_lastone)-locwrd(r_xnum))/4+1
  m_dh = (locwrd(dh_averag(1,1))-locwrd(dh_void))/4+4*mnbas
  write(mess,'(3(A,I8))') 'Header ',m_header,' Data_Header ',m_dh,   &
    ' Line_Data ',mdatal
  call clic_message(seve%i,'INIT',mess)
  call astro_observatory('05:54:26.0','44:38:01.2',2.560d0,45.d0,error)
  call atm_i(error)
  call set_numbers
  allow_pol = .false.
  call sic_def_logi ('ALLOW_POL',allow_pol,.false.,error)
  call chtoby('    ',fourblanks,4)
  !
  ! Initialize conversion code
  call classic_init(error)
end subroutine init_clic
!
subroutine check_commons
  use gkernel_interfaces
  use gildas_def
  use clic_index
  use classic_api
  ! Global
  include 'clic_parameter.inc'
  include 'clic_buffers.inc'
  include 'clic_clic.inc'
  include 'clic_constant.inc'
  include 'clic_dcomp.inc'
  include 'clic_dheader.inc'
  include 'clic_display.inc'
  include 'clic_fit.inc'
  include 'clic_fits.inc'
  include 'clic_flags.inc'
  ! include 'clic_gaussdata.inc'
  include 'clic_gauss.inc'
  include 'clic_number.inc'
  ! include 'clic_panels.inc'
  include 'clic_par.inc'
  ! include 'clic_point.inc'
  include 'clic_rdata.inc'
  include 'clic_sba.inc'
  ! include 'clic_skydip.inc'
  include 'clic_stations.inc'
  include 'clic_tabbuf.inc'
  include 'clic_title.inc'
  include 'clic_virtual.inc'
  include 'clic_windowfile.inc'
  include 'clic_work.inc'
  include 'clic_xy_code.inc'
  ! Local
  logical :: error
  !
  error = .false.
  ! clic_buffers.inc:24:      COMMON /CRBAND/ S_LEV, C_LEV, C_C, C_L, TCAL_U, TCAL_L, TCAL,
  call check_iaddress(error,'CRBAND',s_lev)
  ! clic_clic.inc:226:      COMMON /SELECTION/ SELECT, CONT_SELECT,
  call check_iaddress(error,'SELECTION',select)
  ! clic_clic.inc:230:      COMMON /SASSET/
  ! clic_clic.inc:258:      COMMON /SASCET/ SLINE,SSOURC,STELES,
  ! clic_clic.inc:268:      COMMON /FITS/
  ! clic_common.inc:56:      COMMON/COM/ INTERVAL,
!! call check_caddress(error,'CARCOM',ispec)
  ! clic_common.inc:67:      COMMON/CARCOM/ ISPEC,OSPEC,DSPEC
  ! clic_dcomp.inc:47:      COMMON /DCOMP_COM/
  call check_iaddress(error,'DCOMP_COM',dcomp_void)
  call check_iaddress(error,'DH_COM',dh_void)
  ! clic_dheader.inc:49:      COMMON /DH_COM/
  call check_caddress(error,'CDISPLAY',sw1)
  call check_iaddress(error,'DISPLAY',n_boxes)
  ! clic_display.inc:117:      COMMON /CDISPLAY/ SW1, SW2, C_SETBOX, SM_X1, SM_X2, SM_Y1,
  ! clic_display.inc:121:      COMMON / DISPLAY/ N_BOXES, N_X, I_X, K_X, N_Y, I_Y, K_Y,
  call check_iaddress(error,'FITCOM',x)
  ! clic_fit.inc:27:      COMMON /FITCOM/ X,XT,DIRIN, U,WERR,ALIM,BLIM, V,
  ! clic_fits.inc:58:      COMMON /CFITS01/
  call check_iaddress(error,'CFITS01',axval)
  ! clic_fits.inc:74:      COMMON /CFITSC1/ AXTYPE,KIND,COLTYPE,COLFORM
  ! clic_flags.inc:10:      COMMON /FLAGS/ AF, BF
  call check_caddress(error,'FLAGS',af)
  ! clic_gaussdata.inc:9:      COMMON /CRGAUSS/ NDATA,RDATAX,RDATAY
  !!      call CHECK_IADDRESS(error,'CRGAUSS',ndata)
  ! clic_gauss.inc:13:      COMMON /CGUESS/ NLINE,SPAR,DELTAV,
  ! clic_gauss.inc:20:      COMMON /CPOIDS/ WFIT(MXCAN)
  ! clic_gauss.inc:25:      COMMON /CRGAUS/ NGLINE,SIGBAS,SIGRAI,PAR,ERR
  ! clic_number.inc:34:      COMMON /NUMBERS/ BASANT, ANTBAS, TRIANT, ANTTRI, BASTRI,
  ! clic_panels.inc:14:      COMMON /PANEL/ ANT_TYPE, DIAMETER, FOCUS, NPAN, NRING, RAY, C2,
  ! clic_parameter.inc:59:      COMMON /COM_SECTION/ SECTION
  ! clic_parameter.inc:174:      COMMON /PARAMS/ M_HEADER, M_DH
  ! clic_parameter.inc:184:      COMMON       /CONFIGS/ CONFIG, CONFIG_NAME, CONFIG_PATCH
  ! clic_par.inc:286:      COMMON /R_COM/
  call check_iaddress(error,'R_XNUM',r_xnum)
  ! CLIC_POINT.INC:18:      COMMON /SPOINT/
  ! clic_rdata.inc:12:      COMMON /CRDATA/ DATAC, DATAL, PASSC, PASSL,
  ! clic_rdata.inc:19:      COMMON /CRGAIN/ GAINC, GAINL, WGAINC, WGAINL,
  ! clic_sba.inc:12:      COMMON /SBA/ ZSBA, ZRSBA, WSBA, WRSBA
  ! clic_skydip.inc:14:      COMMON /CSKYDI/ PAR, EL, SKY, SIGRMS, IFE, NP,
  ! clic_stations.inc:6:      COMMON /STATIONS/ STAT89, STAT96, STAT99
  ! clic_tabbuf.inc:35:      COMMON /TABLE_COM/
  ! clic_tabbuf.inc:79:      COMMON /OUT_COM/
  ! clic_title.inc:7:      COMMON /LTITLE/ TITLE_LINES, T_INTERFERO, T_POSITION, T_QUALITY,
  ! clic_virtual.inc:28:      COMMON /VIRTUAL/
  ! clic_windowfile.inc:8:      COMMON /SELECTED/ NFILE, IFILE, HFILEDEF
  ! clic_windowfile.inc:9:      COMMON /CELECTED/ DATAFILE, CODE, HFILE, HFILEMODE
  ! clic_work.inc:6:      COMMON /WORK_SPACE/ DATA_BUFFER
  if (error) call sysexi(fatale)
end subroutine check_commons
!
subroutine check_iaddress(error,name,int)
  use gildas_def
  use gkernel_interfaces
  logical :: error                  !
  character(len=*) :: name          !
  integer :: int                    !
  ! Local
  integer(kind=address_length) :: addr
  !
  addr = locwrd(int)
  if (mod(addr,4_address_length).ne.0) then
    error = .true.
    print *,'Bad alignment ',name,addr,dble(addr)*0.25d0,addr/4
  elseif  (error) then
    print *,name,' at ',dble(addr)*0.25d0
  endif
end subroutine check_iaddress
subroutine check_caddress(error,name,int)
  use gildas_def
  logical :: error                  !
  character(len=*) :: name          !
  character(len=*) :: int           !
  ! Global
  integer(kind=address_length) :: locstr
  ! Local
  integer(kind=address_length) :: addr
  !
  addr = locstr(int)
  if (mod(addr,4_address_length).ne.0) then
    error = .true.
    print *,'Bad alignment ',name,addr,dble(addr)*0.25d0,addr/4
  elseif  (error) then
    print *,name,' at ',dble(addr)*0.25d0
  endif
end subroutine check_caddress
