!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
module cubetemplate_firstlaststride_types
  use cubetools_parameters
  use cubetemplate_messaging
  !
  public :: firstlaststride_t
  private
  !
  type firstlaststride_t
     integer(kind=indx_k) :: first  = 0
     integer(kind=indx_k) :: last   = 0
     integer(kind=indx_k) :: stride = 0
   contains
     procedure, public :: list               => cubetemplate_firstlaststride_list
     procedure, public :: intersect_axis     => cubetemplate_firstlaststride_intersect_axis
     procedure, public :: update_axis_header => cubetemplate_firstlaststride_update_axis_header
  end type firstlaststride_t
  !
contains
  !
  subroutine cubetemplate_firstlaststride_list(iter,error)
    !-------------------------------------------------------------------
    ! List 
    !-------------------------------------------------------------------
    class(firstlaststride_t), intent(in)    :: iter
    logical,                  intent(inout) :: error
    !
    character(len=*), parameter :: rname='FIRSTLASTSTRIDE>LIST'
    !
    call cubetemplate_message(templateseve%trace,rname,'Welcome')
    !
    print *,'First:  ',iter%first
    print *,'Last:   ',iter%last
    print *,'Stride: ',iter%stride
  end subroutine cubetemplate_firstlaststride_list
  !
  subroutine cubetemplate_firstlaststride_intersect_axis(iter,axis,error)
    use cubetools_axis_types
    !-------------------------------------------------------------------
    ! 
    !-------------------------------------------------------------------
    class(firstlaststride_t), intent(inout) :: iter
    type(axis_t),             intent(in)    :: axis
    logical,                  intent(inout) :: error
    !
    character(len=*), parameter :: rname='FIRSTLASTSTRIDE>INTERSECT>AXIS'
    !
    call cubetemplate_message(templateseve%trace,rname,'Welcome')
    !
    if (.not.axis%inside(iter%first)) iter%first = 1
    if (.not.axis%inside(iter%last))  iter%last = axis%n
  end subroutine cubetemplate_firstlaststride_intersect_axis
  !
  subroutine cubetemplate_firstlaststride_update_axis_header(iter,axis,error)
    use cubetools_axis_types
    !-------------------------------------------------------------------
    ! Update the header of axis according to the iterator 
    !-------------------------------------------------------------------
    class(firstlaststride_t), intent(in)    :: iter
    type(axis_t),             intent(inout) :: axis
    logical,                  intent(inout) :: error
    !
    character(len=*), parameter :: rname='FIRSTLASTSTRIDE>UPDATE>AXIS>HEADER'
    !
    call cubetemplate_message(templateseve%trace,rname,'Welcome')
    !
    axis%n = iter%last-iter%first+1
    axis%ref = axis%ref-real(iter%stride*iter%first,kind=coor_k)+1d0
  end subroutine cubetemplate_firstlaststride_update_axis_header
end module cubetemplate_firstlaststride_types
! 
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
