!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
module cubestatistics_minmax
  use cube_types
  use cubetools_parameters
  use cubetools_structure
  use cubeadm_cubeid_types
  use cubetemplate_cuberegion_types
  use cubestatistics_messaging
  !
  public :: minmax
  public :: cubestatistics_minmax_command
  private
  !
  type minmax_comm_t
     type(option_t), pointer :: comm
     type(cuberegion_comm_t) :: region
   contains
     procedure, public  :: register => cubestatistics_minmax_register
     procedure, private :: parse    => cubestatistics_minmax_parse
     procedure, private :: main     => cubestatistics_minmax_main
  end type minmax_comm_t
  type(minmax_comm_t) :: minmax  
  !
  integer(kind=4), parameter :: icube = 1
  type minmax_user_t
     type(cubeid_user_t)     :: cubeids
     type(cuberegion_user_t) :: region
   contains
     procedure, private :: toprog => cubestatistics_minmax_user_toprog
  end type minmax_user_t
  !
  type minmax_prog_t
     type(cuberegion_prog_t) :: region
     type(cube_t), pointer :: cube
     type(cube_t), pointer :: min
     type(cube_t), pointer :: max
   contains
     procedure, private :: header => cubestatistics_minmax_prog_header
     procedure, private :: data   => cubestatistics_minmax_prog_data
     procedure, private :: loop   => cubestatistics_minmax_prog_loop
     procedure, private :: act    => cubestatistics_minmax_prog_act
  end type minmax_prog_t
  !
contains
  !
  subroutine cubestatistics_minmax_command(line,error)
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    character(len=*), intent(in)    :: line
    logical,          intent(inout) :: error
    !
    type(minmax_user_t) :: user
    character(len=*), parameter :: rname='MINMAX>COMMAND'
    !
    call cubestatistics_message(statisticsseve%trace,rname,'Welcome')
    !
    call minmax%parse(line,user,error)
    if (error) return
    call minmax%main(user,error)
    if (error) continue
  end subroutine cubestatistics_minmax_command
  !
  !----------------------------------------------------------------------
  !
  subroutine cubestatistics_minmax_register(comm,error)
    use cubedag_allflags
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(minmax_comm_t), intent(inout) :: comm
    logical,              intent(inout) :: error
    !
    type(cubeid_arg_t) :: cubearg
    character(len=*), parameter :: comm_abstract = 'Compute the minimum and maximum spectra or images'
    character(len=*), parameter :: comm_help = &
         'For the moment, input and output cubes must be real'
    character(len=*), parameter :: rname='MINMAX>REGISTER'
    !
    call cubestatistics_message(statisticsseve%trace,rname,'Welcome')
    !
    call cubetools_register_command(&
         'MINMAX','[cube]',&
         comm_abstract,&
         comm_help,&
         cubestatistics_minmax_command,&
         comm%comm,error)
    if (error) return
    call cubearg%register(&
         'INPUT',&
         'Input cube',&
         strg_id,&
         code_arg_optional,&
         [flag_any],&
         error)
    if (error) return
    !
    call comm%region%register(error)
    if (error) return
  end subroutine cubestatistics_minmax_register
  !
  subroutine cubestatistics_minmax_parse(comm,line,user,error)
    !----------------------------------------------------------------------
    ! MINMAX cubname
    ! /SIZE sx [sy]
    ! /CENTER xcen ycen
    ! /RANGE zfirst zlast
    ! /SPECTRUM
    ! /IMAGE
    !----------------------------------------------------------------------
    class(minmax_comm_t), intent(in)    :: comm
    character(len=*),     intent(in)    :: line
    type(minmax_user_t),  intent(out)   :: user
    logical,              intent(inout) :: error
    !
    character(len=*), parameter :: rname='MINMAX>PARSE'
    !
    call cubestatistics_message(statisticsseve%trace,rname,'Welcome')
    !
    call cubeadm_cubeid_parse(line,comm%comm,user%cubeids,error)
    if (error) return
    call comm%region%parse(line,user%region,error)
    if (error) return
  end subroutine cubestatistics_minmax_parse
  !
  subroutine cubestatistics_minmax_main(comm,user,error)
    use cubeadm_timing
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(minmax_comm_t), intent(in)    :: comm
    type(minmax_user_t),  intent(inout) :: user
    logical,              intent(inout) :: error
    !
    type(minmax_prog_t) :: prog
    character(len=*), parameter :: rname='MINMAX>MAIN'
    !
    call cubestatistics_message(statisticsseve%trace,rname,'Welcome')
    !
    call user%toprog(comm,prog,error)
    if (error) return
    call prog%header(error)
    if (error) return
    call cubeadm_timing_prepro2process()
    call prog%data(error)
    if (error) return
    call cubeadm_timing_process2postpro()
  end subroutine cubestatistics_minmax_main
  !
  !----------------------------------------------------------------------
  !
  subroutine cubestatistics_minmax_user_toprog(user,comm,prog,error)
    use cubetools_consistency_methods
    use cubeadm_get
    !----------------------------------------------------------------------
    ! Only the dimension of the cubes are checked here on purpose for
    ! this very basic command
    !----------------------------------------------------------------------
    class(minmax_user_t), intent(in)    :: user
    type(minmax_comm_t),  intent(in)    :: comm
    type(minmax_prog_t),  intent(out)   :: prog
    logical,             intent(inout) :: error
    !
    character(len=*), parameter :: rname='MINMAX>USER>TOPROG'
    !
    call cubestatistics_message(statisticsseve%trace,rname,'Welcome')
    !
    call cubeadm_cubeid_get_header(comm%comm,icube,user%cubeids,&
         code_access_speset,code_read,prog%cube,error)
    if (error) return
    call user%region%toprog(prog%cube,prog%region,error)
    if (error) return
    call prog%region%list(error)
    if (error) return
  end subroutine cubestatistics_minmax_user_toprog
  !
  !----------------------------------------------------------------------
  !
  subroutine cubestatistics_minmax_prog_header(prog,error)
    use cubedag_allflags
    use cubeadm_clone
    use cubetools_header_methods
    !----------------------------------------------------------------------
    ! 
    !----------------------------------------------------------------------
    class(minmax_prog_t), intent(inout) :: prog
    logical,              intent(inout) :: error
    !
    integer(kind=chan_k), parameter :: one=1
    character(len=*), parameter :: rname='MINMAX>PROG>HEADER'
    !
    call cubestatistics_message(statisticsseve%trace,rname,'Welcome')
    !
    call cubeadm_clone_header(prog%cube,[flag_minimum,flag_image],prog%min,error)
    if (error) return
    call prog%region%header(prog%min,error)
    if (error) return
    call cubetools_header_put_nchan(one,prog%min%head,error)
    if (error) return
    !
    call cubeadm_clone_header(prog%cube,[flag_maximum,flag_image],prog%max,error)
    if (error) return
    call prog%region%header(prog%max,error)
    if (error) return
    call cubetools_header_put_nchan(one,prog%max%head,error)
    if (error) return
  end subroutine cubestatistics_minmax_prog_header
  !
  subroutine cubestatistics_minmax_prog_data(prog,error)
    use cubeadm_opened
    !----------------------------------------------------------------------
    ! 
    !----------------------------------------------------------------------
    class(minmax_prog_t), intent(inout) :: prog
    logical,              intent(inout) :: error
    !
    type(cubeadm_iterator_t) :: iter
    character(len=*), parameter :: rname='MINMAX>PROG>DATA'
    !
    call cubestatistics_message(statisticsseve%trace,rname,'Welcome')
    !
    call cubeadm_datainit_all(iter,error)
    if (error) return
    !$OMP PARALLEL DEFAULT(none) SHARED(prog,error) FIRSTPRIVATE(iter)
    !$OMP SINGLE
    do while (cubeadm_dataiterate_all(iter,error))
       if (error) exit
       !$OMP TASK SHARED(prog,error) FIRSTPRIVATE(iter)
       if (.not.error) &
         call prog%loop(iter,error)
       !$OMP END TASK
    enddo ! iter
    !$OMP END SINGLE
    !$OMP END PARALLEL
  end subroutine cubestatistics_minmax_prog_data
  !
  subroutine cubestatistics_minmax_prog_loop(prog,iter,error)
    use cubeadm_taskloop
    use cubeadm_spectrum_types
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(minmax_prog_t),     intent(inout) :: prog
    type(cubeadm_iterator_t), intent(inout) :: iter
    logical,                  intent(inout) :: error
    !
    type(spectrum_t) :: spe,min,max
    character(len=*), parameter :: rname='MINMAX>PROG>LOOP'
    !
    call spe%associate('cube',prog%cube,iter,error)
    if (error) return
    call spe%associate_x(error)
    if (error) return
    call min%allocate('min',prog%min,iter,error)
    if (error) return
    call max%allocate('max',prog%max,iter,error)
    if (error) return
    !
    do while (iter%iterate_entry(error))
       call prog%act(iter%ie,spe,min,max,error)
       if (error) return
    enddo ! ie
  end subroutine cubestatistics_minmax_prog_loop
  !   
  subroutine cubestatistics_minmax_prog_act(prog,ie,spectrum,spemin,spemax,error)
    use cubetools_nan
    use cubeadm_spectrum_types
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(minmax_prog_t), intent(inout) :: prog
    integer(kind=entr_k), intent(in)    :: ie
    type(spectrum_t),     intent(inout) :: spectrum
    type(spectrum_t),     intent(inout) :: spemin
    type(spectrum_t),     intent(inout) :: spemax
    logical,              intent(inout) :: error
    !
    real(kind=sign_k) :: xval,yval
    real(kind=sign_k) :: mymin,mymax
    integer(kind=chan_k) :: if,il,iz
    integer(kind=chan_k), parameter :: one=1
    character(len=*), parameter :: rname='MINMAX>PROG>ACT'
    !
    call spectrum%get(ie,error)
    if (error) return
    if = prog%region%iz%first
    il = prog%region%iz%last
    mymin = gr4nan
    mymax = gr4nan
    do iz=if,il
       xval = spectrum%x%val(iz)
       yval = spectrum%y%val(iz)
       if (ieee_is_finite(yval)) then
          if (ieee_is_finite(mymin)) then
             mymin = min(mymin,xval)
             mymax = max(mymax,xval)
          else
             mymin = xval
             mymax = xval
          endif
       endif
    enddo ! iz
    spemin%y%val(one) = mymin
    spemax%y%val(one) = mymax
    call spemin%put(ie,error)
    if (error) return
    call spemax%put(ie,error)
    if (error) return
  end subroutine cubestatistics_minmax_prog_act
end module cubestatistics_minmax
!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
