!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
! *** JP: This one could (should?) be an extension of cubeid_user_t => unclear
! 
module cubemain_ancillary_cube_types
  use cubetools_parameters
  use cubetools_structure
  use cube_types
  use cubeadm_cubeid_types
  use cubeadm_cubeprod_types
  use cubemain_messaging
  !
  public :: ancillary_cube_comm_t,ancillary_cube_user_t,ancillary_cube_prog_t
  private
  !
  type ancillary_cube_comm_t
     type(option_t), pointer :: key
     type(cubeid_arg_t), pointer :: cube
   contains
     procedure, public :: fully_register => cubemain_ancillary_cube_comm_fully_register
     procedure, public :: parse          => cubemain_ancillary_cube_comm_parse
  end type ancillary_cube_comm_t
  !
  type ancillary_cube_user_t
     logical             :: present = .false.
     type(cubeid_user_t) :: id
   contains
     procedure, public :: toprog => cubemain_ancillary_cube_user_toprog
!    procedure, public :: list   => cubemain_ancillary_cube_user_list ! *** JP: to be written
  end type ancillary_cube_user_t
  !
  type ancillary_cube_prog_t
     ! Empty type for the moment
     logical               :: do = .false.
     type(cube_t), pointer :: cube
   contains
!    procedure, public :: list => cubemain_ancillary_cube_prog_list ! *** JP: to be written
  end type ancillary_cube_prog_t
  !
contains
  !
  subroutine cubemain_ancillary_cube_comm_fully_register(comm,&
       keyname,keysyntax,keyabstract,keyhelp,&
       cubename,cubeabstract,cubeflags,&
       cubemandatory,cubestatus,cubeaccess,error)
    use cubedag_flag
    !----------------------------------------------------------------------
    ! Register a "/KEYNAME [cubeid]" key
    !----------------------------------------------------------------------
    class(ancillary_cube_comm_t), intent(inout) :: comm
    character(len=*),             intent(in)    :: keyname
    character(len=*),             intent(in)    :: keysyntax
    character(len=*),             intent(in)    :: keyabstract
    character(len=*),             intent(in)    :: keyhelp
    character(len=*),             intent(in)    :: cubename
    character(len=*),             intent(in)    :: cubeabstract
    type(flag_t),                 intent(in)    :: cubeflags(:)
    integer(kind=code_k),         intent(in)    :: cubemandatory
    integer(kind=code_k),         intent(in)    :: cubestatus
    integer(kind=code_k),         intent(in)    :: cubeaccess
    logical,                      intent(inout) :: error
    !
    type(cubeid_arg_t) :: incube
    character(len=*), parameter :: rname='ANCILLARY>CUBE>COMM>FULLY>REGISTER'
    !
    call cubemain_message(mainseve%trace,rname,'Welcome')
    !
    call cubetools_register_option(&
         keyname,&
         keysyntax,&
         keyabstract,&
         keyhelp,&
         comm%key,&
         error)
    if (error) return
    call incube%register(&
         cubename,&
         cubeabstract,&
         strg_id,&
         cubemandatory,&
         cubeflags,&
         cubestatus,&
         cubeaccess,&
         comm%cube,&
         error)
    if (error) return
  end subroutine cubemain_ancillary_cube_comm_fully_register
  !
  subroutine cubemain_ancillary_cube_comm_parse(comm,line,user,error)
    !----------------------------------------------------------------------
    ! /KEYNAME [cubeid]
    !----------------------------------------------------------------------
    class(ancillary_cube_comm_t),  intent(in)    :: comm
    character(len=*),              intent(in)    :: line
    class(ancillary_cube_user_t),  intent(inout) :: user
    logical,                       intent(inout) :: error
    !
    character(len=*), parameter :: rname='ANCILLARY>CUBE>COMM>PARSE'
    !
    call cubemain_message(mainseve%trace,rname,'Welcome')
    !
    call comm%key%present(line,user%present,error)
    if (error) return
    if (user%present) then
       call cubeadm_cubeid_parse(line,comm%key,user%id,error)
       if (error) return
    endif
  end subroutine cubemain_ancillary_cube_comm_parse
  !
  !------------------------------------------------------------------------
  !
  subroutine cubemain_ancillary_cube_user_init(user,error)
    !----------------------------------------------------------------------
    ! Initialize by setting the intent of ancillary_cube_user_t to out
    !----------------------------------------------------------------------
    class(ancillary_cube_user_t), intent(out)   :: user
    logical,                      intent(inout) :: error
    !
    character(len=*), parameter :: rname='ANCILLARY>CUBE>USER>INIT'
    !
    call cubemain_message(mainseve%trace,rname,'Welcome')
  end subroutine cubemain_ancillary_cube_user_init
  !
  subroutine cubemain_ancillary_cube_user_toprog(user,comm,prog,error,access)
    use cubeadm_get
    !----------------------------------------------------------------------
    ! Resolve cubeid into a cube
    !----------------------------------------------------------------------
    class(ancillary_cube_user_t),   intent(in)    :: user
    class(ancillary_cube_comm_t),   intent(in)    :: comm
    class(ancillary_cube_prog_t),   intent(inout) :: prog
    logical,                        intent(inout) :: error
    integer(kind=code_k), optional, intent(in)    :: access
    !
    character(len=*), parameter :: rname='ANCILLARY>CUBE>USER>TOPROG'
    !
    call cubemain_message(mainseve%trace,rname,'Welcome')
    !
    prog%do = user%present
    if (prog%do) then
       call cubeadm_cubeid_get_header(comm%cube,user%id,prog%cube,error,access)
       if (error) return
    endif
  end subroutine cubemain_ancillary_cube_user_toprog
end module cubemain_ancillary_cube_types
!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
