!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
module cubecompute_ratio
  use cubecompute_two2one_real_template
  use cubecompute_messaging
  !
  public :: cubecompute_ratio_register
  private
  !
  type(two2one_real_comm_t) :: ratio
  !
contains
  !
  subroutine cubecompute_ratio_register(error)
    use cubedag_allflags
    !----------------------------------------------------------------------
    ! Register the command:
    !  - register command in SIC,
    !  - register help, arguments, etc in CUBE internal structures,
    !  - register the processing engine in the compute_two2one frame.
    !----------------------------------------------------------------------
    logical, intent(inout) :: error
    !
    character(len=*), parameter :: rname='RATIO>REGISTER'
    !
    call cubecompute_message(computeseve%trace,rname,'Welcome')
    !
    call ratio%register_syntax(&
         'RATIO','numerator','denominator',&
         [flag_ratio],cubecompute_ratio_command,error)
    if (error) return
    call ratio%register_act(cubecompute_ratio_prog_act,error)
    if (error) return
  end subroutine cubecompute_ratio_register
  !
  subroutine cubecompute_ratio_command(line,error)
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    character(len=*), intent(in)    :: line
    logical,          intent(inout) :: error
    !
    type(two2one_real_user_t) :: user
    character(len=*), parameter :: rname='RATIO>COMMAND'
    !
    call cubecompute_message(computeseve%trace,rname,'Welcome')
    !
    call ratio%parse(line,user,error)
    if (error) return
    call ratio%main(user,error)
    if (error) continue
  end subroutine cubecompute_ratio_command
  !
  !----------------------------------------------------------------------
  !
  subroutine cubecompute_ratio_prog_act(prog,ie,numerator,denominator,ratio,error)
    use cubetools_parameters
    use cubeadm_image_types
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(two2one_real_prog_t), intent(inout) :: prog
    integer(kind=entr_k),       intent(in)    :: ie
    type(image_t),              intent(inout) :: numerator
    type(image_t),              intent(inout) :: denominator
    type(image_t),              intent(inout) :: ratio
    logical,                    intent(inout) :: error
    !
    integer(kind=pixe_k) :: ix,iy
    integer(kind=pixe_k) :: jx,jy
    character(len=*), parameter :: rname='RATIO>PROG>ACT'
    !
    call numerator%get(ie,error)
    if (error) return
    call denominator%get(ie,error)
    if (error) return
    do iy=prog%region%iy%first,prog%region%iy%last
       jy = iy-prog%region%iy%first+1
       do ix=prog%region%ix%first,prog%region%ix%last
          jx = ix-prog%region%ix%first+1
          ratio%val(jx,jy) = numerator%val(ix,iy)/denominator%val(ix,iy)
       enddo ! ix
    enddo ! iy
    call ratio%put(ie-prog%region%iz%first+1,error)
    if (error) return
  end subroutine cubecompute_ratio_prog_act
end module cubecompute_ratio
!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
