!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
module cubecompute_product
  use cubecompute_two2one_real_template
  use cubecompute_messaging
  !
  public :: cubecompute_product_register
  private
  !
  type(two2one_real_comm_t) :: product
  !
contains
  !
  subroutine cubecompute_product_register(error)
    use cubedag_allflags
    !----------------------------------------------------------------------
    ! 
    !----------------------------------------------------------------------
    logical, intent(inout) :: error
    !
    character(len=*), parameter :: rname='PRODUCT>REGISTER'
    !
    call cubecompute_message(computeseve%trace,rname,'Welcome')
    !
    call product%register_syntax(&
         'PRODUCT','factor1','factor2',&
         [flag_product],cubecompute_product_command,error)
    if (error) return
    call product%register_act(cubecompute_product_prog_act,error)
    if (error) return
  end subroutine cubecompute_product_register
  !
  subroutine cubecompute_product_command(line,error)
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    character(len=*), intent(in)    :: line
    logical,          intent(inout) :: error
    !
    type(two2one_real_user_t) :: user
    character(len=*), parameter :: rname='PRODUCT>COMMAND'
    !
    call cubecompute_message(computeseve%trace,rname,'Welcome')
    !
    call product%parse(line,user,error)
    if (error) return
    call product%main(user,error)
    if (error) continue
  end subroutine cubecompute_product_command
  !
  !----------------------------------------------------------------------
  !
  subroutine cubecompute_product_prog_act(prog,ie,factor1,factor2,product,error)
    use cubetools_parameters
    use cubeadm_image_types
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(two2one_real_prog_t), intent(inout) :: prog
    integer(kind=entr_k),       intent(in)    :: ie
    type(image_t),              intent(inout) :: factor1
    type(image_t),              intent(inout) :: factor2
    type(image_t),              intent(inout) :: product
    logical,                    intent(inout) :: error
    !
    integer(kind=pixe_k) :: ix,iy
    integer(kind=pixe_k) :: jx,jy
    character(len=*), parameter :: rname='PRODUCT>PROG>ACT'
    !
    call factor1%get(ie,error)
    if (error) return
    call factor2%get(ie,error)
    if (error) return
    do iy=prog%region%iy%first,prog%region%iy%last
       jy = iy-prog%region%iy%first+1
       do ix=prog%region%ix%first,prog%region%ix%last
          jx = ix-prog%region%ix%first+1
          product%val(jx,jy) = factor1%val(ix,iy)/factor2%val(ix,iy)
       enddo ! ix
    enddo ! iy
    call product%put(ie-prog%region%iz%first+1,error)
    if (error) return
  end subroutine cubecompute_product_prog_act
end module cubecompute_product
!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
