!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
module cubego_view
  use cubetools_structure
  use cubetools_topic
  use cubeadm_cubeid_types
  use cubego_messaging
  !
  public :: view,cubego_view_command
  private
  !
  type :: view_comm_t
     type(option_t), pointer :: comm
     type(topic_opt_t)       :: inter
     type(option_t), pointer :: new
   contains
     procedure, public  :: register => cubego_view_register
     procedure, private :: parse    => cubego_view_parse
     procedure, private :: main     => cubego_view_main
  end type view_comm_t
  type(view_comm_t) :: view
  !
  integer(kind=4), parameter :: icube = 1
  type :: view_user_t
     type(cubeid_user_t) :: cubeids
     logical :: donew = .false.
     logical :: dointer = .true.
   contains
     procedure, private :: toprog => cubego_view_user_toprog
  end type view_user_t
  !
  type view_prog_t
     logical :: donew = .false.
     logical :: dointer = .true.
   contains
     procedure, private :: act => cubego_view_prog_act
  end type view_prog_t
  !
contains
  !
  subroutine cubego_view_command(line,error)
    use gkernel_interfaces
    !---------------------------------------------------------------------
    !
    !---------------------------------------------------------------------
    character(len=*), intent(in)    :: line
    logical,          intent(inout) :: error
    !
    type(view_user_t) :: user
    character(len=*),parameter :: rname='VIEW>COMMAND'
    !
    call cubego_message(goseve%trace,rname,'Welcome')
    !
    call view%parse(line,user,error)
    if (error) return
    call view%main(user,error)
    if (error) return
    ! Force insertion in SIC stack ! *** JP Why?
    if (sic_lire().eq.0) call sic_insert(line)
  end subroutine cubego_view_command
  !
  !----------------------------------------------------------------------
  !
  subroutine cubego_view_register(view,error)
    use cubedag_allflags
    !---------------------------------------------------------------------
    ! 
    !---------------------------------------------------------------------
    class(view_comm_t), intent(inout) :: view
    logical,            intent(inout) :: error
    !
    type(cubeid_arg_t) :: cubearg
    character(len=*), parameter :: comm_abstract = &
         'Interactive view of a cube'
    character(len=*), parameter :: comm_help = &
         strg_id
    character(len=*), parameter :: rname='VIEW>REGISTER'
    !
    call cubego_message(goseve%trace,rname,'Welcome')
    !
    call cubetools_register_command(&
         'VIEW','[cube]',&
         comm_abstract,&
         comm_help,&
         cubego_view_command,&
         view%comm,error)
    if (error) return
    call cubearg%register( &
         'CUBE', &
         'Cube to be viewed',  &
         strg_id,&
         code_arg_optional,  &
         [flag_any], &
         error)
    if (error) return
    !
    call view%inter%register(&
         'INTERACTIVE',&
         'Enable or disable the interactive mode',&
         error)
    if (error) return
    !
    call cubetools_register_option(&
         'NEW','',&
         'New implementation',&
         strg_id,&
         view%new,error)
    if (error) return
  end subroutine cubego_view_register
  !
  subroutine cubego_view_parse(view,line,user,error)
    !---------------------------------------------------------------------
    ! 
    !---------------------------------------------------------------------
    class(view_comm_t), intent(inout) :: view
    character(len=*),   intent(in)    :: line
    type(view_user_t),  intent(out)   :: user
    logical,            intent(inout) :: error
    !
    character(len=*), parameter :: rname='VIEW>PARSE'
    !
    call cubego_message(goseve%trace,rname,'Welcome')
    !
    call cubeadm_cubeid_parse(line,view%comm,user%cubeids,error)
    if (error) return
    call view%inter%parse(line,error)
    if (error) return
    call view%new%present(line,user%donew,error)
    if (error) return
  end subroutine cubego_view_parse
  !
  subroutine cubego_view_main(view,user,error)
    !---------------------------------------------------------------------
    ! 
    !---------------------------------------------------------------------
    class(view_comm_t), intent(in)    :: view
    type(view_user_t),  intent(in)    :: user
    logical,            intent(inout) :: error
    !
    type(view_prog_t) :: prog
    character(len=*), parameter :: rname='VIEW>MAIN'
    !
    call cubego_message(goseve%trace,rname,'Welcome')
    !
    call user%toprog(view,prog,error)
    if (error) return
    call prog%act(error)
    if (error) return
  end subroutine cubego_view_main
  !
  !----------------------------------------------------------------------
  !
  subroutine cubego_view_user_toprog(user,view,prog,error)
    use cubetools_user2prog
    use cubego_buffer
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(view_user_t), intent(in)    :: user
    type(view_comm_t),  intent(in)    :: view    
    type(view_prog_t),  intent(out)   :: prog
    logical,            intent(inout) :: error
    !
    character(len=*), parameter :: rname='VIEW>USER>TOPROG'
    !
    call cubego_message(goseve%trace,rname,'Welcome')
    !
    call cubeadm_cubeid_user2prog(view%comm,user%cubeids,cubes,error)
    if (error) return
    call cubes%defstruct(cubego,error)
    if (error) return
    if (view%inter%do) then
       prog%dointer = view%inter%enabled
    else
       prog%dointer = .true.
    endif
    prog%donew = user%donew
  end subroutine cubego_view_user_toprog
  !
  !----------------------------------------------------------------------
  !
  subroutine cubego_view_prog_act(prog,error)
    use gkernel_interfaces
    ! *** JP start backward compatibility
    use cubego_buffer
    ! *** JP stop backward compatibility
    !---------------------------------------------------------------------
    !
    !---------------------------------------------------------------------
    class(view_prog_t), intent(in)    :: prog
    logical,            intent(inout) :: error
    !
    character(len=mess_l) :: exec
    character(len=*), parameter :: rname='VIEW>PROG>ACT'
    !
    call cubego_message(goseve%trace,rname,'Welcome')
    !
    if (prog%donew) then
       call exec_program('@ q-view.cube')
       if (prog%dointer) call exec_program('@ l-ctrl-master-loop')
    else
       ! *** JP start backward compatibility
       write (exec,'(a,i0)') 'let name ',cubes%id(icube)
       call exec_program(trim(exec))
       call exec_program('@ q-old-view.cube')
       call exec_program('let name ""')
       ! *** JP stop backward compatibility
    endif
  end subroutine cubego_view_prog_act
end module cubego_view
!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
