module cubeadm_remove
  use cubetools_structure
  use cube_types
  use cubedag_allflags
  use cubeadm_cubeid_types
  use cubeadm_messaging
  !
  public :: cubeadm_remove_command,cubeadm_remove_register
  private
  !
  type :: remove_comm_t
     type(option_t), pointer :: remove
  end type remove_comm_t
  type(remove_comm_t) :: comm
  !
  type remove_user_t
     type(cubeid_user_t)  :: cubeid
  end type remove_user_t
  !
  integer(kind=4), parameter :: icube = 1
  type remove_prog_t
     type(cubeid_prog_t)  :: cubeid
  end type remove_prog_t
  !
contains
  !
  subroutine cubeadm_remove_register(error)
    !-------------------------------------------------------------------
    ! Register ADM\REMOVE command and its options
    !-------------------------------------------------------------------
    logical,          intent(inout) :: error
    !
    character(len=*), parameter :: comm_help = strg_id
    !
    type(cubeid_arg_t) :: cubearg
    character(len=*), parameter :: rname='REMOVE>REGISTER'
    !
    call cubeadm_message(admseve%trace,rname,'Welcome')
    !
    ! Command
    call cubetools_register_command(&
         'REMOVE','[cube]',&
         'Remove a cube from the DAG',&
         comm_help,&
         cubeadm_remove_command,&
         comm%remove,error)
    if (error) return
    call cubearg%register( &
         'CUBE', &
         '[CubeID]',  &
         strg_id,&
         code_arg_optional,  &
         [flag_any], &
         error)
    if (error) return
  end subroutine cubeadm_remove_register
  !
  subroutine cubeadm_remove_command(line,error)
    !-------------------------------------------------------------------
    ! Support routine for command REMOVE
    !-------------------------------------------------------------------
    character(len=*), intent(in)    :: line
    logical,          intent(inout) :: error
    !
    type(remove_user_t) :: user
    type(remove_prog_t) :: prog
    character(len=*), parameter :: rname='REMOVE>COMMAND'
    !
    call cubeadm_message(admseve%trace,rname,'Welcome')
    !
    call cubeadm_remove_parse(line,user,error)
    if (error) return
    call cubeadm_remove_cube(user,prog,error)
    if (error) return
  end subroutine cubeadm_remove_command
  !
  subroutine cubeadm_remove_parse(line,user,error)
    use cubetools_disambiguate
    !-------------------------------------------------------------------
    ! Parsing facility for command
    !   REMOVE CubeID
    !-------------------------------------------------------------------
    character(len=*),    intent(in)    :: line
    type(remove_user_t), intent(out)   :: user
    logical,             intent(inout) :: error
    !
    character(len=*), parameter :: rname='REMOVE>PARSE'
    !
    call cubeadm_message(admseve%trace,rname,'Welcome')
    !
    call cubeadm_cubeid_parse(line,comm%remove,user%cubeid,error)
    if (error) return
  end subroutine cubeadm_remove_parse
  !
  subroutine cubeadm_remove_cube(user,prog,error)
    use cubedag_history
    use cubedag_dag
    !-------------------------------------------------------------------
    ! 
    !-------------------------------------------------------------------
    type(remove_user_t), intent(in)    :: user
    type(remove_prog_t), intent(out)   :: prog
    logical,             intent(inout) :: error
    !
    character(len=*), parameter :: rname='REMOVE>MAIN'
    !
    call cubeadm_message(admseve%trace,rname,'Welcome')
    !
    call cubeadm_remove_user2prog(user,prog,error)
    if (error) return
    call cubedag_history_removenode(prog%cubeid%id(icube),error)
    if (error) return
    call cubedag_dag_removenode(prog%cubeid%id(icube),error)
    if (error) return
  end subroutine cubeadm_remove_cube
  !
  subroutine cubeadm_remove_user2prog(user,prog,error)
    use cubedag_history
    !-------------------------------------------------------------------
    ! 
    !-------------------------------------------------------------------
    type(remove_user_t), intent(in)    :: user
    type(remove_prog_t), intent(out)   :: prog
    logical,             intent(inout) :: error
    !
    character(len=*), parameter :: rname='REMOVE>USER2PROG'
    !
    call cubeadm_message(admseve%trace,rname,'Welcome')
    !
    call cubeadm_cubeid_user2prog(comm%remove,user%cubeid,prog%cubeid,error)
    if (error) return
  end subroutine cubeadm_remove_user2prog
end module cubeadm_remove
