!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
module cubeadm_find
  use cubetools_structure
  use cubedag_parameters
  use cubedag_flag
  use cubedag_find
  use cube_types
  use cubeadm_messaging
  !
  public :: cubeadm_find_command,cubeadm_find_register
  public :: cubeadm_find_node
  private
  !
  type :: find_comm_t
     type(option_t), pointer :: find        
     type(option_t), pointer :: entry       
     type(option_t), pointer :: observatory 
     type(option_t), pointer :: source      
     type(option_t), pointer :: line        
     type(option_t), pointer :: family      
     type(option_t), pointer :: flag
     type(option_t), pointer :: identifier       
  end type find_comm_t
  type(find_comm_t) :: comm
  !
  ! *** JP: Can't we use a generic interface mecanism to alias the definition?
  !
contains
  !
  subroutine cubeadm_find_register(error)
    !---------------------------------------------------------------------
    ! 
    !---------------------------------------------------------------------
    logical,          intent(inout) :: error
    !
    type(standard_arg_t) :: stdarg
    character(len=*), parameter :: comm_abstract = &
         'Search for cubes on the DAG'
    character(len=*), parameter :: comm_help = &
         'Search the DAG to build a current Index, according to&
         & selection criteria defined by the options. If no options&
         & are given the current index will contains all cubes on the&
         & DAG.'
    character(len=*), parameter :: rname='FIND>REGISTER'
    !
    call cubeadm_message(admseve%trace,rname,'Welcome')
    !
    call cubetools_register_command(&
         'FIND','',&
         comm_abstract,&
         comm_help,&
         cubeadm_find_command,&
         comm%find,error)
    if (error) return
    !
    call cubetools_register_option(&
         'ENTRY','n1 [n2]',&
         'search for the specified range of entry numbers',&
         strg_id,&
         comm%entry,error)
    if (error) return
    call stdarg%register( &
         'n1',  &
         'First entry in range', &
         strg_id,&
         code_arg_mandatory, &
         error)
    if (error) return
    call stdarg%register( &
         'n2',  &
         'Second entry in range', &
         strg_id,&
         code_arg_optional, &
         error)
    if (error) return
    !
    call cubetools_register_option(&
         'OBSERVATORY','name',&
         'search for the specified observatory',&
         strg_id,&
         comm%observatory,error)
    if (error) return
    call stdarg%register( &
         'name',  &
         'Observatory name', &
         strg_id,&
         code_arg_mandatory, &
         error)
    if (error) return
    ! 
    call cubetools_register_option(&
         'SOURCE','name',&
         'search by source name',&
         strg_id,&
         comm%source,error)
    if (error) return
    call stdarg%register( &
         'name',  &
         'Source name', &
         strg_id,&
         code_arg_mandatory, &
         error)
    if (error) return
    !
    call cubetools_register_option(&
         'LINE','name',&
         'search by line name',&
         strg_id,&
         comm%line,error)
    if (error) return
    call stdarg%register( &
         'name',  &
         'Line name', &
         strg_id,&
         code_arg_mandatory, &
         error)
    if (error) return
    !
    call cubetools_register_option(&
         'FAMILY','name',&
         'search for the specified family name',&
         strg_id,&
         comm%family,error)
    if (error) return
    call stdarg%register( &
         'name',  &
         'Family name', &
         strg_id,&
         code_arg_mandatory, &
         error)
    if (error) return
    !
    call cubetools_register_option('FLAG',&
         'flag',&
         'search for the specified flag pattern',&
         strg_id,&
         comm%flag,error)
    if (error) return
    call stdarg%register( &
         'flag',  &
         'Flag pattern', &
         strg_id,&
         code_arg_mandatory, &
         error)
    if (error) return
    !
    call cubetools_register_option(&
         'IDENTIFIER','id1 [id2]',&
         'search for the specified range of identifiers',&
         strg_id,&
         comm%identifier,error)
    if (error) return
    call stdarg%register( &
         'id1',  &
         'First identifier in range', &
         strg_id,&
         code_arg_mandatory, &
         error)
    if (error) return
    call stdarg%register( &
         'id2',  &
         'Second identifier in range', &
         strg_id,&
         code_arg_optional, &
         error)
    if (error) return
  end subroutine cubeadm_find_register
  !
  subroutine cubeadm_find_command(line,error)
    use cubedag_find
    !---------------------------------------------------------------------
    ! Support for command
    !  ADM\FIND
    !---------------------------------------------------------------------
    character(len=*), intent(in)    :: line
    logical,          intent(inout) :: error
    !
    type(user_find_t) :: fuser
    !
    call cubeadm_find_parse(line,fuser,error)
    if (error) return
    call cubedag_find_command(fuser,error)
    if (error)  return
  end subroutine cubeadm_find_command
  !
  subroutine cubeadm_find_parse(line,fuser,error)
    use cubedag_find
    !---------------------------------------------------------------------
    !  Parse the fuser input for selection criteria
    !---------------------------------------------------------------------
    character(len=*),  intent(in)    :: line   !
    type(user_find_t), intent(out)   :: fuser  !
    logical,           intent(inout) :: error  !
    ! Local
    character(len=*), parameter :: rname='FIND>PARSE'
    !
    ! /ENTRY [min|*] [max|*]
    fuser%centr(1) = strg_star
    call cubetools_getarg(line,comm%entry,1,fuser%centr(1),.not.mandatory,error)
    if (error)  return
    fuser%centr(2) = fuser%centr(1)
    call cubetools_getarg(line,comm%entry,2,fuser%centr(2),.not.mandatory,error)
    if (error)  return
    !
    ! /IDENTIFIER [number|*]
    fuser%ciden = strg_star
    call cubetools_getarg(line,comm%identifier,1,fuser%ciden,.not.mandatory,error)
    if (error)  return
    !
    ! /OBSERVATORY [obsname|*]
    fuser%cobse = strg_star
    call cubetools_getarg(line,comm%observatory,1,fuser%cobse,.not.mandatory,error)
    if (error)  return
    !
    ! /SOURCE [sourcename|*]
    fuser%csour = strg_star
    call cubetools_getarg(line,comm%source,1,fuser%csour,.not.mandatory,error)
    if (error)  return
    !
    ! /LINE [linename|*]
    fuser%cline = strg_star
    call cubetools_getarg(line,comm%line,1,fuser%cline,.not.mandatory,error)
    if (error)  return
    !
    ! /FAMILY [familyname|*]  (case-sensitive search)
    fuser%cfami = strg_star
    call cubetools_getarg(line,comm%family,1,fuser%cfami,.not.mandatory,error)
    if (error)  return
    !
    ! /FLAG [flagpattern|*]
    fuser%ccflag = strg_star
    call cubetools_getarg(line,comm%flag,1,fuser%ccflag,.not.mandatory,error)
    if (error)  return
  end subroutine cubeadm_find_parse
  !
  subroutine cubeadm_find_node(rname,identifier,flags,node,error)
    use gkernel_interfaces
    use cubedag_types
    use cubedag_index
    use cubeadm_setup
    !---------------------------------------------------------------------
    ! Search in Current indeX the cube whose identifier name is given as
    ! argument.
    ! ZZZ There should be a way to indicate which is to be selected in
    !     case of non-unique answer.
    !---------------------------------------------------------------------
    character(len=*),             intent(in)    :: rname
    character(len=*),             intent(in)    :: identifier  ! ID number or family name
    type(flag_t),                 intent(in)    :: flags(:)
    class(cubedag_node_object_t), pointer       :: node
    logical,                      intent(inout) :: error
    ! Local
    type(cubedag_find_t) :: find
    type(cubedag_optimize_t) :: mycx
    character(len=message_length) :: mess
    integer(kind=iden_l) :: idnum
    integer(kind=4) :: ier,iflag
    !
    node => null()
    !
    if (identifier.ne.'') then
      ! Guess if it is an ID number or a FAMILY name
      read(identifier,*,iostat=ier)  idnum
      ! ZZZ This method is not fully satisfying, as this does not support
      ! e.g. SIC variables or more general integer expression. sic_math_inte
      ! deals with this, but raises an annoying error when encountering a
      ! FAMILY name.
      if (ier.eq.0) then
        find%iiden = idnum
      else
        find%cfami = identifier
      endif
    endif
    !
    allocate(find%iflags(size(flags)),stat=ier)
    if (failed_allocate(rname,'iflags',ier,error)) return
    do iflag=1,size(flags)
      find%iflags(iflag) = flags(iflag)
    enddo
    if (cubset%index%default.eq.code_index_dag) then
      call cubedag_find_ix2optx(find,mycx,error)
      if (error)  return
    else
      call cubedag_find_cx2optx(find,mycx,error)
      if (error)  return
    endif
    !
    if (mycx%next.le.1) then
!       if (any(flags.ne.code_flag_any)) then
!         mess = ' with flag '//dag_flag_names(flags(1))
!       else
        mess = ''
!       endif
      mess = 'No '//trim(identifier)//' cube'//trim(mess)//' in '//  &
        trim(indexname(cubset%index%default))//' index'
      call cubeadm_message(seve%e,rname,mess)
      error = .true.
      return
    elseif (mycx%next.gt.2) then
      call cubeadm_message(seve%w,rname,'More than one matching cube, using latest one')
    endif
    !
    node => mycx%object(mycx%next-1)%p
    !
    ! Clean
    ! 'mycx' has only allocatable arrays => automatic clean
    !
  end subroutine cubeadm_find_node
  !
  subroutine cubeadm_find_cube(rname,identifier,flags,cube,error)
    use cubedag_types
    !---------------------------------------------------------------------
    ! Search in Current indeX the cube whose identifier name is given as
    ! argument.
    ! ZZZ There should be a way to indicate which is to be selected in
    !     case of non-unique answer.
    !---------------------------------------------------------------------
    character(len=*),     intent(in)    :: rname
    character(len=*),     intent(in)    :: identifier  ! ID number or family name
    type(flag_t),         intent(in)    :: flags(:)
    type(cube_t),         pointer       :: cube
    logical,              intent(inout) :: error
    ! Local
    class(cubedag_node_object_t), pointer :: dno
    !
    cube => null()
    !
    call cubeadm_find_node(rname,identifier,flags,dno,error)
    if (error)  return
    cube => cubetuple_cube_ptr(dno,error)
    if (error)  return
  end subroutine cubeadm_find_cube

end module cubeadm_find
!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
