!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
module cubetuple_init
  use cube_types
  use cubeio_interfaces_public
  !
  public :: cubetuple_cube_init,cubetuple_set_current
  private
  !
contains
  !
  subroutine cubetuple_cube_init(tuple,error)
    !---------------------------------------------------------------------
    ! Initialize a cubeio_t
    !---------------------------------------------------------------------
    type(cubetuple_t), intent(inout) :: tuple
    logical,           intent(inout) :: error
    ! Local
    integer(kind=4) :: iaccess
    !
    do iaccess=1,cubetuple_naccess
      call cubeio_cube_init(tuple%cube(iaccess),error)
      if (error)  return
    enddo
    tuple%current => null()
    !
    call cubetuple_trans_reset(tuple%trans,error)
    if (error)  return
  end subroutine cubetuple_cube_init
  !
  subroutine cubetuple_set_current(tuple,error)
    !---------------------------------------------------------------------
    ! Set the pointer to current cube
    !---------------------------------------------------------------------
    type(cubetuple_t), target, intent(inout) :: tuple
    logical,                   intent(inout) :: error
    !
    ! Assume no one is used yet, use first arbitrarily
    tuple%current => tuple%cube(1)
    tuple%trans%do = code_trans_none
  end subroutine cubetuple_set_current
end module cubetuple_init
!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
