module cubetools_help
  !---------------------------------------------------------------------
  ! Support module for help
  !---------------------------------------------------------------------
  !
  ! Parameters
  integer(kind=4), parameter :: terminal_max_width=90
  integer(kind=4), parameter :: file_default_width=74  ! for e.g. COLLECT
  !
  ! Dynamic
  integer(kind=4) :: current_width=terminal_max_width
  !
  public :: help_width,strg_dash
  public :: cubetools_help_terminal_width,cubetools_help_file_width
  private
  !
contains
  !
  function help_width()
    !-------------------------------------------------------------------
    ! Return the help string width adapted to the terminal size.
    ! Leave 2 blank characters to the left and to the right of the
    ! terminal.
    !-------------------------------------------------------------------
    integer(kind=4) :: help_width
    help_width = current_width-4
  end function help_width
  !
  function strg_dash()
    !-------------------------------------------------------------------
    ! Return a string of dashes of length tt_width
    !-------------------------------------------------------------------
    character(len=:), allocatable :: strg_dash
    strg_dash = repeat('-',current_width)  ! Implicit allocation
  end function strg_dash
  !
  subroutine cubetools_help_terminal_width()
    use gkernel_interfaces
    !-------------------------------------------------------------------
    ! Set the current help width so that it is adapted to the current
    ! terminal, if any
    !-------------------------------------------------------------------
    if (sic_isatty().eq.1) then
      ! Interactive session in a terminal
      current_width = min(sic_ttyncol(),terminal_max_width)
    else
      ! Non-interactive session, e.g. batch mode redirected to file
      current_width = file_default_width
    endif
  end subroutine cubetools_help_terminal_width
  !
  subroutine cubetools_help_file_width()
    !-------------------------------------------------------------------
    ! Set the current help width so that it is adapted for ouput to a
    ! file, for e.g. command COLLECT
    !-------------------------------------------------------------------
    current_width = file_default_width
  end subroutine cubetools_help_file_width
  !
end module cubetools_help
