!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
module cubetemplate_fullcube
  use cube_types
  use cubetools_structure
  use cubeadm_cubeid_types
  use cubemain_sperange_types
  use cubetemplate_messaging
  !
  public :: fullcube
  public :: cubetemplate_fullcube_command
  private
  !
  type :: fullcube_comm_t
     type(option_t), pointer :: comm  
     type(option_t), pointer :: factor
     type(sperange_opt_t)    :: range
   contains
     procedure, public  :: register => cubetemplate_fullcube_register
     procedure, private :: parse    => cubetemplate_fullcube_parse
     procedure, private :: main     => cubetemplate_fullcube_main
  end type fullcube_comm_t
  type(fullcube_comm_t) :: fullcube
  !
  integer(kind=4), parameter :: icube = 1
  type fullcube_user_t
     type(cubeid_user_t)   :: cubeids
     type(sperange_user_t) :: range
     character(len=argu_l) :: factor
   contains
     procedure, private :: toprog => cubetemplate_fullcube_user_toprog
  end type fullcube_user_t
  !
  type fullcube_prog_t
     type(sperange_prog_t) :: range
     real(kind=sign_k)     :: factor
     type(cube_t), pointer :: incube
     type(cube_t), pointer :: oucube
   contains
     procedure, private :: header => cubetemplate_fullcube_prog_header
     procedure, private :: data   => cubetemplate_fullcube_prog_data
     procedure, private :: act    => cubetemplate_fullcube_prog_act
  end type fullcube_prog_t
  !
contains
  !
  subroutine cubetemplate_fullcube_command(line,error)
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    character(len=*), intent(in)    :: line
    logical,          intent(inout) :: error
    !
    type(fullcube_user_t) :: user
    character(len=*), parameter :: rname='FULLCUBE>COMMAND'
    !
    call cubetemplate_message(templateseve%trace,rname,'Welcome')
    !
    call fullcube%parse(line,user,error)
    if (error) return
    call fullcube%main(user,error)
    if (error) continue
  end subroutine cubetemplate_fullcube_command
  !
  !----------------------------------------------------------------------
  !
  subroutine cubetemplate_fullcube_register(fullcube,error)
    use cubedag_allflags
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(fullcube_comm_t), intent(inout) :: fullcube
    logical,                intent(inout) :: error
    !
    type(cubeid_arg_t) :: cubearg
    type(standard_arg_t) :: stdarg
    character(len=*), parameter :: comm_abstract = 'Template command for working with fullcubes'
    character(len=*), parameter :: comm_help = &
         'Input and output cube ares real'
    character(len=*), parameter :: rname='FULLCUBE>REGISTER'
    !
    call cubetemplate_message(templateseve%trace,rname,'Welcome')
    !
    call cubetools_register_command(&
         'FULLCUBE','[cube]',&
         comm_abstract,&
         comm_help,&
         cubetemplate_fullcube_command,&
         fullcube%comm,error)
    if (error) return
    call cubearg%register(&
         'CUBE',&
         'Signal cube',&
         strg_id,&
         code_arg_optional,&
         [flag_any],&
         error)
    if (error) return
    !
    call fullcube%range%register(&
         'RANGE',&
         'Define velocity range(s)',&
         error)
    if (error) return
    !
    call cubetools_register_option(&
         'FACTOR','factor',&
         'Multiply data by a factor',&
         strg_id,&
         fullcube%factor,error)
    if (error) return
    call stdarg%register(&
         'factor',&
         'factor',&
         'default is 1',&
         code_arg_mandatory, error)
    if (error) return
  end subroutine cubetemplate_fullcube_register
  !
  subroutine cubetemplate_fullcube_parse(fullcube,line,user,error)
    !----------------------------------------------------------------------
    ! fullcube cubname
    ! /RANGE vfirst vlast
    ! /FACTOR factor
    !----------------------------------------------------------------------
    class(fullcube_comm_t), intent(in)    :: fullcube
    character(len=*),       intent(in)    :: line
    type(fullcube_user_t),  intent(out)   :: user
    logical,                intent(inout) :: error
    !
    character(len=*), parameter :: rname='FULLCUBE>PARSE'
    !
    call cubetemplate_message(templateseve%trace,rname,'Welcome')
    !
    call cubeadm_cubeid_parse(line,fullcube%comm,user%cubeids,error)
    if (error) return
    call fullcube%range%parse(line,user%range,error)
    if (error) return
    call cubetemplate_fullcube_parse_factor(line,fullcube%factor,user%factor,error)
    if (error) return
  end subroutine cubetemplate_fullcube_parse
  !
  subroutine cubetemplate_fullcube_parse_factor(line,opt,user,error)
    !----------------------------------------------------------------------
    ! /FACTOR factor
    !----------------------------------------------------------------------
    character(len=*), intent(in)    :: line
    type(option_t),   intent(in)    :: opt
    character(len=*), intent(out)   :: user
    logical,          intent(inout) :: error
    !
    logical :: present
    integer(kind=4), parameter :: iarg=1
    character(len=*), parameter :: rname='FULLCUBE>PARSE>FACTOR'
    !
    call cubetemplate_message(templateseve%trace,rname,'Welcome')
    !
    call opt%present(line,present,error)
    if (error) return
    if (present) then
       call cubetools_getarg(line,opt,iarg,user,mandatory,error)
       if (error) return
    else
       user = strg_star
    endif
  end subroutine cubetemplate_fullcube_parse_factor
  !
  subroutine cubetemplate_fullcube_main(fullcube,user,error)    
    use cubeadm_timing
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(fullcube_comm_t), intent(in)    :: fullcube
    type(fullcube_user_t),  intent(inout) :: user
    logical,                intent(inout) :: error
    !
    type(fullcube_prog_t) :: prog
    character(len=*), parameter :: rname='FULLCUBE>MAIN'
    !
    call cubetemplate_message(templateseve%trace,rname,'Welcome')
    !
    call user%toprog(prog,error)
    if (error) return
    call prog%header(error)
    if (error) return
    call cubeadm_timing_prepro2process()
    call prog%data(error)
    if (error) return
    call cubeadm_timing_process2postpro()
  end subroutine cubetemplate_fullcube_main
  !
  !----------------------------------------------------------------------
  !
  subroutine cubetemplate_fullcube_user_toprog(user,prog,error)
    use cubetools_user2prog
    use cubetools_unit
    use cubeadm_get
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(fullcube_user_t), intent(in)    :: user
    type(fullcube_prog_t),  intent(out)   :: prog
    logical,                intent(inout) :: error
    !
    real(kind=sign_k), parameter :: default=1.0
    type(unit_user_t) :: nounit
    character(len=*), parameter :: rname='FULLCUBE>USER>TOPROG'
    !
    call cubetemplate_message(templateseve%trace,rname,'Welcome')
    !
    call cubeadm_cubeid_get_header(fullcube%comm,icube,user%cubeids,&
         code_access_fullset,code_read,prog%incube,error)
    if (error) return
    !
    call user%range%toprog(prog%incube,prog%range,error)
    if (error) return
    !
    call cubetools_unit_get(strg_star,code_unit_unk,nounit,error)
    if (error) return
    call cubetools_user2prog_resolve_star(user%factor,nounit,default,prog%factor,error)
    if (error) return
  end subroutine cubetemplate_fullcube_user_toprog
  !
  !----------------------------------------------------------------------
  !
  subroutine cubetemplate_fullcube_prog_header(prog,error)
    use cubedag_allflags
    use cubeadm_clone
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(fullcube_prog_t), intent(inout) :: prog
    logical,                intent(inout) :: error
    !
    character(len=*), parameter :: rname='FULLCUBE>PROG>HEADER'
    !
    call cubetemplate_message(templateseve%trace,rname,'Welcome')
    !
    call cubeadm_clone_header(prog%incube,flag_template,prog%oucube,error)
    if (error) return
  end subroutine cubetemplate_fullcube_prog_header
  !
  subroutine cubetemplate_fullcube_prog_data(prog,error)
    use cubeadm_opened
    use cubeadm_entryloop
    use cubemain_subcube_real
    !----------------------------------------------------------------------
    ! Structure is simplified compared to other cases because only one task
    ! can work on a full cube at a time by construction!
    !----------------------------------------------------------------------
    class(fullcube_prog_t), intent(inout) :: prog
    logical,                intent(inout) :: error
    !
    integer(kind=entr_k) :: isubcube
    type(cubeadm_iterator_t) :: iter
    type(subcube_iterator_t) :: subiter
    ! *** SB: as of today we rely on the subcube_t, but we could
    !         introduce a fullcube_t (extended from subcube_t, with
    !         nothing more added) just for clarity.
    type(subcube_t) :: insub,ousub
    character(len=*), parameter :: rname='FULLCUBE>PROG>DATA'
    !
    call cubetemplate_message(templateseve%trace,rname,'Welcome')
    !
    ! 1. Open in and out cubes
    ! 2. Prepare parallel tasking (here only one task)
    ! 2. Define iterator of entries (here only one subcube)
    ! 3. Command feedback 
    call cubeadm_datainit_all(iter,error)
    if (error) return
    ! Loop on task => Only one task, ie, one iteration
    do while (cubeadm_dataiterate_all(iter,error))
       ! Loop on subcubes.
       do isubcube=iter%first,iter%last
          ! 1. Trap CTRL-C
          ! 2. Timing feedback.
          call cubeadm_entryloop_iterate(isubcube,error)
          if (error) return
          ! Define the dimensions of the current subcube
          call subiter%init(iter,isubcube,error)
          if (error) return
          ! Prepare the input subcube for the next get
          call insub%init(prog%incube,error)
          if (error) return
          ! Prepare the output subcube for the next put
          call ousub%reallocate(prog%oucube,subiter,error)
          if (error) return
          ! Get next input subcube
          call insub%get(prog%incube,subiter,error)
          if (error)  return
          ! Does the computation
          call prog%act(insub,ousub,error)
          if (error) return
          ! Put next output subcube
          call ousub%put(prog%oucube,subiter,error)
          if (error) return
       enddo ! isubcube
    enddo ! ie
  end subroutine cubetemplate_fullcube_prog_data
  !   
  subroutine cubetemplate_fullcube_prog_act(prog,insub,ousub,error)
    use cubemain_subcube_real
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(fullcube_prog_t), intent(inout) :: prog
    type(subcube_t),        intent(inout) :: insub
    type(subcube_t),        intent(inout) :: ousub
    logical,                intent(inout) :: error
    !
    integer(kind=indx_k) :: ix,iy,iz
    character(len=*), parameter :: rname='FULLCUBE>PROG>ACT'
    !
    do iz=1,insub%n3
       do iy=1,insub%n2
          do ix=1,insub%n1
             ousub%data(ix,iy,iz) = prog%factor*insub%data(ix,iy,iz)
          enddo ! ix
       enddo ! iy
    enddo ! iz
  end subroutine cubetemplate_fullcube_prog_act
end module cubetemplate_fullcube
!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
