!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
module cubemain_stitch
  use cubetools_structure
  use cubeadm_index
  use cube_types
  use cubemain_messaging
  use cubemain_auxiliary
  use cubemain_merge
  use cubemain_identifier
  !
  ! We declare the stitch_comm_t to be an extension of the
  ! merge_comm_t as they have the same options and also the same parsing
  ! routine
  type, extends(merge_comm_t) :: stitch_comm_t
     ! No options to add
   contains
     procedure, public  :: register     => cubemain_stitch_register
     procedure, public  :: main         => cubemain_stitch_main
  end type stitch_comm_t
  type(stitch_comm_t) :: stitch
  !
  ! No user type defined here as the user type would be exactly the
  ! same as in the CUBE\MERGE, hence we re-use that type, specially
  ! since we need to call CUBE\MERGE via a filled user type
  !
  type :: stitch_prog_t 
     type(index_t)           :: original   ! Unprocessed cubes
     type(index_t)           :: resampled  ! Resampled cubes
     integer(kind=4)         :: mergedid   ! Merged cube id
     type(identifier_user_t) :: family     ! Family name
   contains
     procedure, private :: init      => cubemain_stitch_prog_init
     procedure, private :: execute   => cubemain_stitch_prog_execute
     procedure, private :: loop      => cubemain_stitch_prog_loop
     procedure, private :: reproject => cubemain_stitch_prog_reproject
     procedure, private :: resample  => cubemain_stitch_prog_resample
     procedure, private :: average   => cubemain_stitch_prog_average
  end type stitch_prog_t
  !
contains
  !
  subroutine cubemain_stitch_command(line,error)
    !----------------------------------------------------------------------
    ! 
    !----------------------------------------------------------------------
    character(len=*), intent(in)    :: line
    logical,          intent(inout) :: error
    !
    type(merge_user_t) :: user
    character(len=*), parameter :: rname = 'STITCH>COMMAND'
    !
    call cubemain_message(mainseve%trace,rname,'Welcome')
    !
    call stitch%parse(line,user,error)
    if (error) return
    !
    call stitch%main(user,error)
    if (error) return
  end subroutine cubemain_stitch_command
  !
  !----------------------------------------------------------------------
  !
  subroutine cubemain_stitch_register(merge,error)
    use cubetools_unit
    use cubedag_allflags
    use cubemain_identifier
    !----------------------------------------------------------------------
    ! FORTRAN standards oblige me to put the same name as in merge for
    ! the object. This code is a copy of the register code in
    ! CUBE\MERGE maybe the two commands should be merged in a single
    ! one?
    ! ----------------------------------------------------------------------
    class(stitch_comm_t), intent(inout) :: merge
    logical,              intent(inout) :: error
    !
    character(len=*), parameter :: rname = 'STITCH>REGISTER'
    !
    call cubemain_message(mainseve%trace,rname,'Welcome')
    !
    call cubetools_register_command(&
         'STITCH','',&
         'Stitch cubes from the current index',&
         'Stitch the cubes in the current index. Several aspects of the output cube can&
         & be controlled: its axes (/LAXIS, /MAXIS and /FAXIS), its&
         & projection (/PTYPE, /PCENTER and /PANGLE) as well as its&
         & reference frequency and line. A reference can be used to&
         & define the spectral and spatial characteristics of the&
         & stitched cube (/LIKE). If no options are given the axes&
         & will be chosen in a way to cover all the data in all cubes&
         & in the index. By default the family name of the output&
         & cube will be the same of the first cube in the current &
         & index, this can be changed with the usage of option &
         &/FAMILY.', &
         cubemain_stitch_command, merge%comm,error)
    if (error) return
    !
    call merge%family%register(&
         'Define the new family name for products',&
         .not.changeflags,error)
    if (error) return
    !
    call cubemain_auxiliary_register(&
         'LIKE',&
         'Stitch cubes onto a template cube',&
         strg_id,&
         'Reference cube',&
         [flag_cube],&
         code_arg_mandatory, &
         merge%like,error)
    if (error) return
    !
    call merge%freq%register(&
         'Define line name and frequency of the stitched cube',&
         error)
    if (error) return
    !
    call merge%faxis%register(&
         code_unit_freq, &
         'FAXIS',&
         'Define the frequency axis of the stitched cube',&
         error)
    if (error) return
    !
    call merge%ptype%register(&
         'PTYPE',&
         'Define the new projection type',&
         error)
    if (error) return
    call merge%pcenter%register(&
         'PCENTER',&
         'Define the new projection center',&
         error)
    if (error) return
    call merge%pangle%register(&
         'PANGLE',&
         'Define the new projection angle',&
         error)
    if (error) return
    !
    call merge%laxis%register(&
         code_unit_fov, &
         'LAXIS',&
         'Define the L axis of the stitched cube',&
         error)
    if (error) return
    call merge%maxis%register(&
         code_unit_fov, &
         'MAXIS',&
         'Define the M axis of the stitched cube',&
         error)
    if (error) return
  end subroutine cubemain_stitch_register
  !
  subroutine cubemain_stitch_main(merge,user,error)
    !----------------------------------------------------------------------
    ! FORTRAN standards oblige me to put the same name as in merge for
    ! the object.
    !----------------------------------------------------------------------
    class(stitch_comm_t), intent(in)    :: merge
    type(merge_user_t),   intent(in)    :: user
    logical,              intent(inout) :: error
    !
    type(stitch_prog_t) :: prog
    character(len=*), parameter :: rname = 'STITCH>MAIN'
    !
    call cubemain_message(mainseve%trace,rname,'Welcome')
    !
    call prog%init(user,error)
    if (error) return
    call prog%execute(error)
    if (error) return
  end subroutine cubemain_stitch_main
  !
  !----------------------------------------------------------------------
  !
  subroutine cubemain_stitch_prog_init(prog,user,error)
    use cubeadm_get
    use cubeadm_opened
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(stitch_prog_t), intent(inout) :: prog
    class(merge_user_t),  intent(in)    :: user
    logical,              intent(inout) :: error
    !
    type(cube_t), pointer :: cube
    character(len=*), parameter :: rname = 'STITCH>PROG>INIT'
    !
    !
    prog%family = user%family
    call stitch%merge_comm_t%main(user,error)
    if (error) return
    call cubeadm_finalize_all('TMP','STITCH MERGE',error) 
    if (error) return 
    !
    call prog%original%get_from_current(code_access_imaset,code_read_head,error)
    if (error) return
    call cubeadm_finalize_all('TMP','STITCH MERGE',error) 
    if (error) return
    call cubeadm_get_last_cube(cube,error)
    if (error) return
    prog%mergedid = cube%node%id
  end subroutine cubemain_stitch_prog_init
  !
  subroutine cubemain_stitch_prog_execute(prog,error)
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(stitch_prog_t), intent(inout) :: prog
    logical,              intent(inout) :: error
    !
    character(len=*), parameter :: rname = 'STITCH>PROG>EXECUTE'
    !
    call prog%loop(error)
    if (error) return
    !
    call prog%average(error)
    if (error) return
  end subroutine cubemain_stitch_prog_execute
  !
  subroutine cubemain_stitch_prog_loop(prog,error)
    use cubeadm_get
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(stitch_prog_t), intent(inout) :: prog
    logical,              intent(inout) :: error
    !
    integer(kind=4) :: icub
    type(cube_t), pointer :: cube
    character(len=*), parameter :: rname = 'STITCH>PROG>LOOP'
    !
    ! VVV This is only the expected architecture
    do icub=1, prog%original%n
       cube => prog%original%get_cube(icub,error)
       if (error) return
       call prog%reproject(cube%node%id,error)
       if (error) return
       call cubeadm_get_last_cube(cube,error)
       if (error) return
       call prog%resample(cube%node%id,error)
       if (error) return
       call cubeadm_get_last_cube(cube,error)
       if (error) return
       call prog%resampled%put_cube(icub,cube,error)
       if (error) return
    end do
  end subroutine cubemain_stitch_prog_loop
  !
  subroutine cubemain_stitch_prog_reproject(prog,inid,error)
    use cubedag_allflags
    use cubeadm_opened
    use cubemain_reproject
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(stitch_prog_t), intent(inout) :: prog
    integer(kind=4),      intent(in)    :: inid
    logical,              intent(inout) :: error
    !
    type(reproject_user_t) :: user
    character(len=16) :: writeid
    character(len=*), parameter :: rname = 'STITCH>PROG>LOOP'
    !
    write(writeid,'(i0)') inid
    call user%cubeids%fill(writeid,error)
    if (error) return
    write(writeid,'(i0)') prog%mergedid
    call user%like%id%fill(writeid,error)
    if (error) return
    user%like%do    = .true.
    user%spafra%do  = .false.
    user%ptype%do   = .false.
    user%pcenter%do = .false.
    user%pangle%do  = .false.
    user%newx%do    = .false.
    user%newy%do    = .false.
    user%flag       = flag_reproject
    user%newx%n     = strg_star
    user%newx%ref   = strg_star
    user%newx%val   = strg_star
    user%newx%inc   = strg_star
    user%newx%unit  = strg_star
    user%newy%n     = strg_star
    user%newy%ref   = strg_star
    user%newy%val   = strg_star
    user%newy%inc   = strg_star
    user%newy%unit  = strg_star
    !
    call reproject%main(user,error)
    if (error) return
    call cubeadm_finalize_all('TMP','STITCH REPROJECT',error) 
    if (error) continue 
  end subroutine cubemain_stitch_prog_reproject
  !
  subroutine cubemain_stitch_prog_resample(prog,inid,error)
    use cubeadm_opened
    use cubemain_resample
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(stitch_prog_t), intent(inout) :: prog
    integer(kind=4),      intent(in)    :: inid
    logical,              intent(inout) :: error
    !
    type(resample_user_t) :: user
    character(len=16) :: writeid
    character(len=*), parameter :: rname = 'STITCH>PROG>LOOP'
    !
    write(writeid,'(i0)') inid
    call user%cubeids%fill(writeid,error)
    if (error) return
    write(writeid,'(i0)') prog%mergedid
    call user%like%id%fill(writeid,error)
    if (error) return
    user%like%do    = .true.
    user%dofreq     = .true.
    user%axis%do    = .false.
    user%axis%n     = strg_star
    user%axis%ref   = strg_star
    user%axis%val   = strg_star
    user%axis%inc   = strg_star
    user%axis%unit  = strg_star
    !
    call resample%main(user,error)
    if (error) return
    call cubeadm_finalize_all('TMP','STITCH RESAMPLE',error) 
    if (error) continue 
  end subroutine cubemain_stitch_prog_resample
  !
  subroutine cubemain_stitch_prog_average(prog,error)
    use cubedag_allflags
    use cubemain_average
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(stitch_prog_t), intent(in)    :: prog
    logical,              intent(inout) :: error
    !
    type(average_user_t) :: user
    character(len=*), parameter :: rname = 'STITCH>PROG>AVERAGE'
    !
    !
    user%index_code = code_given_index
    call prog%resampled%copy(user%inindex,error)
    if (error) return
    user%flag     = flag_stitch
    user%doweight = .false.
    user%donoise  = .false.
    user%family   = prog%family
    !
    call average%main(user,error)
    if (error) return
  end subroutine cubemain_stitch_prog_average
end module cubemain_stitch
