module cubeio_transpose
  use cubeio_messaging
  use cubeio_chanblock
  use cubeio_pixblock
  use cubeio_types

  public :: cubeio_transpose_memory,cubeio_transpose_disk
  private

contains
  !
  subroutine cubeio_transpose_memory(cubset,cubdef,  &
    head,cubin,cubout,error)
    use cubetools_help
    !-------------------------------------------------------------------
    ! Perform the transposition from input cube in memory to output cube
    ! in memory.
    !-------------------------------------------------------------------
    type(cube_setup_t),  intent(in)    :: cubset
    type(cube_define_t), intent(in)    :: cubdef
    type(cube_header_t), intent(inout) :: head
    type(cubeio_cube_t), intent(inout) :: cubin
    type(cubeio_cube_t), intent(inout) :: cubout
    logical,             intent(inout) :: error
    ! Local
    character(len=*), parameter :: rname='TRANSPOSE>MEMORY'
    !
    call cubeio_message(ioseve%trans,rname,strg_dash())
    call cubeio_message(ioseve%trans,rname,'Automatic transposition in memory')
    !
    ! NB: input and output file names are useless (no meaning) for
    ! memory transposition
    call cubeio_transpose_engine(cubset,cubdef,code_buffer_memory,  &
      '','',head,cubin,cubout,error)
    if (error)  return
    !
    call cubeio_message(ioseve%trans,rname,strg_dash())
  end subroutine cubeio_transpose_memory
  !
  subroutine cubeio_transpose_disk(cubset,cubdef,directname,transname,  &
    head,cubin,cubout,error)
    use cubetools_help
    !-------------------------------------------------------------------
    ! Perform the transposition from input cube on disk to output cube
    ! on disk.
    !-------------------------------------------------------------------
    type(cube_setup_t),  intent(in)    :: cubset
    type(cube_define_t), intent(in)    :: cubdef
    character(len=*),    intent(in)    :: directname
    character(len=*),    intent(in)    :: transname
    type(cube_header_t), intent(inout) :: head
    type(cubeio_cube_t), intent(inout) :: cubin
    type(cubeio_cube_t), intent(inout) :: cubout
    logical,             intent(inout) :: error
    ! Local
    character(len=*), parameter :: rname='TRANSPOSE>DISK'
    !
    call cubeio_message(ioseve%trans,rname,strg_dash())
    call cubeio_message(ioseve%trans,rname,'Automatic transposition from '//  &
      trim(directname)//' to '//transname)
    !
    call cubeio_transpose_engine(cubset,cubdef,code_buffer_disk,  &
      directname,transname,head,cubin,cubout,error)
    if (error)  return
    !
    call cubeio_message(ioseve%trans,rname,strg_dash())
  end subroutine cubeio_transpose_disk
  !
  subroutine cubeio_transpose_engine(cubset,cubdef,buffering,  &
    directname,transname,head,cubin,cubout,error)
    use cubeio_interfaces_public
    !-------------------------------------------------------------------
    !
    !-------------------------------------------------------------------
    type(cube_setup_t),   intent(in)    :: cubset
    type(cube_define_t),  intent(in)    :: cubdef
    integer(kind=code_k), intent(in)    :: buffering
    character(len=*),     intent(in)    :: directname
    character(len=*),     intent(in)    :: transname
    type(cube_header_t),  intent(inout) :: head  ! Reloaded...
    type(cubeio_cube_t),  intent(inout) :: cubin
    type(cubeio_cube_t),  intent(inout) :: cubout
    logical,              intent(inout) :: error
    ! Local
    character(len=*), parameter :: rname='TRANSPOSE'
    type(cubeio_chanblock_t) :: chanblock
    integer(kind=chan_k) :: fchan,lchan,stepnchan
    type(cube_define_t) :: cubindef,cuboutdef
    type(cubeio_pixblock_t) :: pixblock
    integer(kind=pixe_k) :: fypix,lypix,fpix,lpix,stepypix
    !
    ! Input description
    call cubeio_cube_define_copy(cubdef,cubindef)
    call cubeio_cube_define_buffering(cubindef,buffering,error)
    if (error)  return
    call cubeio_cube_define_action(cubindef,code_read,error)
    if (error)  return
    if (buffering.eq.code_buffer_disk) then
      call cubeio_cube_define_filename(cubindef,directname,error)
      if (error)  return
      call cubeio_get_header(cubset,cubindef,head,cubin,error)
      if (error)  return
    else
      ! In memory mode, do not reload the header (as this can be a
      ! memory-only cube!). Just reset the descriptor access.
      call cubeio_set_descriptor_external(cubset,cubindef,.true.,cubin,error)
      if (error)  return
    endif
    !
    ! Output description
    call cubeio_cube_define_copy(cubdef,cuboutdef)
    call cubeio_cube_define_filename(cuboutdef,transname,error)
    if (error)  return
    call cubeio_cube_define_buffering(cuboutdef,buffering,error)
    if (error)  return
    call cubeio_cube_define_action(cuboutdef,code_write,error)
    if (error)  return
    call cubeio_clone_cube_header(cubset,cuboutdef,head,cubout,error)
    if (error)  return
    !
    select case (cubout%desc%order)
    case (code_cube_imaset)
      ! Guess the internal buffer size
      ! ZZZ This should be automatic i.e cubeio_iterate_chan("as much as you can")
      if (buffering.eq.code_buffer_memory) then
        stepnchan = cubin%desc%nc
      else
        call cubeio_max_chan_block(cubset,cubin,cubset%buff%block,'SET\BUFFER /BLOCK',  &
          stepnchan,error)
        if (error)  return
      endif
      lchan = 0
      do while (lchan.lt.cubin%desc%nc)
        fchan = lchan+1
        lchan = min(lchan+stepnchan,cubin%desc%nc)
        ! Load from buffer to channel block
        call cubeio_iterate_chan(cubset,cubindef,head,cubin,fchan,lchan,error)
        if (error)  return
        call cubeio_get_chanblock(cubset,cubindef,head,cubin,fchan,lchan,chanblock,error)
        if (error)  return
        ! Copy the channel block to the output data
        call cubeio_iterate_chan(cubset,cuboutdef,head,cubout,fchan,lchan,error)
        if (error)  return
        call cubeio_put_chanblock(cubset,cuboutdef,head,cubout,fchan,lchan,chanblock,error)
        if (error)  return
      enddo
      call cubeio_flush_any_block(cubset,head,cubout,cubout%block,error)
      if (error)  return
      call cubeio_free_chanblock(chanblock,error)
      if (error)  return
      !
    case (code_cube_speset)
      ! Guess the internal buffer size
      ! ZZZ This should be automatic i.e cubeio_iterate_pix("as much as you can")
      if (buffering.eq.code_buffer_memory) then
        stepypix = cubin%desc%ny
      else
        call cubeio_max_y_block(cubset,cubin,cubset%buff%block,'SET\BUFFER /BLOCK',  &
          stepypix,error)
        if (error)  return
      endif
      lypix = 0
      do while (lypix.lt.cubin%desc%ny)
        fypix = lypix+1
        lypix = min(lypix+stepypix,cubin%desc%ny)
        fpix = (fypix-1)*cubin%desc%nx+1
        lpix = lypix*cubin%desc%nx
        ! Load from buffer to pixel block
        call cubeio_iterate_pix(cubset,cubindef,head,cubin,fypix,lypix,error)
        if (error)  return
        call cubeio_get_pixblock(cubset,cubindef,head,cubin,fpix,lpix,pixblock,error)
        if (error)  return
        ! Copy the pixel block to the output data
        call cubeio_iterate_pix(cubset,cuboutdef,head,cubout,fypix,lypix,error)
        if (error)  return
        call cubeio_put_pixblock(cubset,cuboutdef,head,cubout,fpix,lpix,pixblock,error)
        if (error)  return
      enddo
      call cubeio_flush_any_block(cubset,head,cubout,cubout%block,error)
      if (error)  return
      call cubeio_free_pixblock(pixblock,error)
      if (error)  return
      !
    case default
      call cubeio_message(seve%e,rname,'Unsupported order')
      error = .true.
      return
    end select
    !
    call cubeio_block_free(cubin%block,error)
    if (error)  continue
    call cubeio_block_free(cubout%block,error)
    if (error)  continue
    !
    ! ---
    ! The code below is disabled: the descriptors are left as they are to
    ! reflect the reality, in particular it might be that a disk file was
    ! loaded in memory and transposed in memory => the output cube is
    ! available in memory only.
    ! ---
    ! Reset the descriptors from the original cubset/cubdef
    ! NB: both cubes are 'old' files (i.e. cubes accessed in read mode for
    !     the pending command)
    ! call cubeio_set_descriptor_external(cubset,cubdef,.true.,cubin,error)
    ! if (error)  return
    ! call cubeio_set_descriptor_external(cubset,cubdef,.true.,cubout,error)
    ! if (error)  return
    ! ---
    !
  end subroutine cubeio_transpose_engine

end module cubeio_transpose
