!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!--------------------------------------------------------------------------
! Routines to manage the CUBE package
!--------------------------------------------------------------------------
!
module cube_package
  use gkernel_interfaces ! Absolutely needs to be here
  !
  public :: cube_pack_set
  private
  !
contains
  !
  subroutine cube_pack_set(pack)
    use gpack_def
    !----------------------------------------------------------------------
    ! 
    !----------------------------------------------------------------------
    type(gpack_info_t), intent(out) :: pack
    !
    pack%name='cube'
    pack%ext = '.cube'
    pack%depend(1:1) = (/ locwrd(greg_pack_set) /)
    pack%init=locwrd(cube_pack_init)
    pack%on_exit=locwrd(cube_pack_on_exit)
    pack%authors='J.Pety, S.Bardeau, V.deSouzaMagalhaes'
  end subroutine cube_pack_set
  !
  subroutine cube_pack_init(gpack_id,error)
    use sic_def ! Definition of backslash
    !
    use cubetools_nan
    use cubetools_structure
    use cubeadm_init
    use cubeset_init
    use cubego_init
    !
    use cubeadm_language
    use cubeedit_language
    use cubefield_language
    use cubefit_language
    use cubego_language
    use cubehelp_language
    use cubecompute_language
    use cubemain_language
    use cubeset_language
    use cubetemplate_language
    !
    use cube_messaging
    use cubeadm_messaging
    use cubedag_messaging
    use cubeedit_messaging
    use cubefield_messaging
    use cubefit_messaging
    use cubefitsio_messaging
    use cubego_messaging
    use cubecompute_messaging
    use cubeio_messaging
    use cubemain_messaging
    use cubeset_messaging
    use cubetemplate_messaging
    use cubetools_messaging
    use cubetuple_messaging
    !----------------------------------------------------------------------
    ! 
    !----------------------------------------------------------------------
    integer(kind=4), intent(in)    :: gpack_id
    logical,         intent(inout) :: error
    !
    logical :: devcube
    character(len=12) :: status
    !
    call sic_getenv('GAG_CUBE_DEV',status)
    devcube = status.eq."YES"
    !
    ! CUBE structure
    if (.not.sic_varexist('cube'))  call sic_defstructure('cube',.true.,error)
    !
    ! Library initializations (must come after CUBE structure)
    call cubetools_nan_init()  ! IEEE NaNs
    call cubeadm_library_init(error)
    if (error) return
    call cubeset_library_init(error)
    if (error) return
    call cubego_library_init(error)
    if (error) return
    !
    ! Language initializations (must come after libraries)
    call cubetools_register_package('CUBE','CUBE package',error)
    if (error) return
    ! Languages by alphabetical order of the SIC language name...
    call cubeadm_register_language(error)
    if (error) return
    call cubemain_register_language(error)
    if (error) return
    call cubeedit_register_language(error)
    if (error) return
    call cubego_register_language(error)
    if (error) return
    call cubehelp_register_language(error)
    if (error) return
    call cubeset_register_language(error)
    if (error) return
    call cubecompute_register_language(error)
    if (error) return
    if (devcube) then
       call cubefield_register_language(error)
       if (error) return
    endif
    call cubefit_register_language(error)
    if (error) return
    ! *** JP: We should have an environmental way to activate or deactivate
    ! *** JP: this language for developpers
    if (devcube) then
       call cubetemplate_register_language(error)
       if (error) return
    endif
    ! *** JP
    !
    ! One time initialization
    call classic_message_set_id(gpack_id)
    call cubefitsio_message_set_id(gpack_id)
    call cubetools_message_set_id(gpack_id)
    call cubeio_message_set_id(gpack_id)
    call cubetuple_message_set_id(gpack_id)
    call cubeadm_message_set_id(gpack_id)
    call cubedag_message_set_id(gpack_id)
    call cubeset_message_set_id(gpack_id)
    call cubemain_message_set_id(gpack_id)
    call cubecompute_message_set_id(gpack_id)
    if (devcube) call cubetemplate_message_set_id(gpack_id)
    if (devcube) call cubefield_message_set_id(gpack_id)
    call cubefit_message_set_id(gpack_id)
    call cubego_message_set_id(gpack_id)
    call cubeedit_message_set_id(gpack_id)
    call cube_message_set_id(gpack_id)
    !
    call exec_program('sic'//backslash//'sic priority 1 help edit go adm set 2 compute cube fit')
  end subroutine cube_pack_init
  !
  subroutine cube_pack_on_exit(error)
    use cubedag_library
    !----------------------------------------------------------------------
    ! 
    !----------------------------------------------------------------------
    logical, intent(inout) :: error
    !
    ! *** JP I don't understand why the cubedag_exit is here and
    ! *** JP cubedag_init is in lib/adm/init.f90?
    call cubedag_exit(error)
  end subroutine cube_pack_on_exit
end module cube_package
!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
