subroutine ase45(p,t,d,ha)
  ! J CERNICHARO
  !
  !	ATMOSFERA U.S. 1962 MES DE ENERO 45 GRADOS DE LATITUD NORTE
  !	HA ES LA ALTURA A LA QUE SE QUIEREN CALCULAR LA PRESION,
  !	(MILIBARES),LA TEMPERATURA (K) Y LA DENSIDAD (GR/M**3)
  !	HA DEBE ESTAR EN KM
  !
  !	P === PRESION
  !	T === TEMPERATURA
  !	D === DENSIDAD
  !
  real p,t,d,ha
  real pr(91),te(91),den(91)
  integer i0,i1,i2,j
  real x1,x2,x3,y1,y2,y3,a,b,c
  data te/  &
    272.150,268.650,265.154,261.654,255.668,249.674,243.686,237.698,   &
    231.710,225.728,219.746,219.159,218.661,218.163,217.665,217.167,   &
    216.670,216.172,215.675,215.178,215.150,215.150,215.150,215.150,   &
    215.150,215.150,215.150,215.150,215.852,216.644,217.437,218.230,   &
    219.022,221.723,224.789,227.855,230.921,233.987,237.049,240.112,   &
    243.175,246.235,249.294,252.354,255.414,258.470,261.527,264.580,   &
    265.650,265.650,265.650,265.650,265.650,264.526,262.560,260.594,   &
    258.628,256.664,254.698,252.736,250.772,248.810,246.848,244.886,   &
    242.926,240.932,238.874,236.818,234.762,232.706,230.650,228.596,   &
    226.543,224.491,222.439,220.387,218.336,216.286,214.236,212.187,   &
    210.150,210.150,210.150,210.150,210.150,210.150,210.150,210.150,   &
    210.150,210.150,210.150/
  data pr/  &
    .101800e04,.897340e03,.789746e03,.693761e03,.608132e03,.531322e03,  &
    .462749e03,.401636e03,.347333e03,.299257e03,.256837e03,.219907e03,  &
    .188249e03,.161092e03,.137803e03,.117839e03,.100747e03,.861032e02,  &
    .735727e02,.628431e02,.536674e02,.458314e02,.391458e02,.334355e02,  &
    .285581e02,.243961e02,.208407e02,.178034e02,.152146e02,.130097e02,  &
    .111307e02,.952848e01,.816277e01,.700062e01,.601741e01,.518290e01,  &
    .447305e01,.386792e01,.335147e01,.290933e01,.253005e01,.220437e01,  &
    .192389e01,.168188e01,.147270e01,.129175e01,.113478e01,.998513,     &
    .879632,.774975,.682770,.601612,.530101,.467019,.411144,.361607,    &
    .317729,.278938,.244604,.214337,.187596,.164042,.143293,.125033,    &
    .108996,.949100e-01,.825474e-01,.717187e-01,.622342e-01,            &
    .539367e-01,.466861e-01,.403641e-01,.348523e-01,.3006e-01,          &
    .258872e-01,.223e-01,.191221e-01,.164020e-01,.140484e-01,           &
    .120146e-01,.102596e-01,.875578e-02,.747237e-02,.637812e-02,        &
    .544411e-02,.464687e-02,.396639e-02,.338610e-02,.289071e-02,        &
    .246780e-02,.210710e-02/
  data den/  &
    .130098e04,.116211e04,.103651e04,.922974e03,.828225e03,       &
    .741093e03,.661404e03,.588557e03,.522172e03,.461856e03,       &
    .407161e03,.349556e03,.299915e03,.257234e03,.220550e03,       &
    .189031e03,.161984e03,.138758e03,.118838e03,.101741e03,       &
    .868975e02,.742096e02,.633844e02,.541483e02,.462409e02,       &
    .395018e02,.337449e02,.288270e02,.245552e02,.209198e02,       &
    .178331e02,.152106e02,.129834e02,.109993e02,.932552e01,       &
    .792416e01,.674806e01,.575870e01,.492532e01,.422101e01,       &
    .362450e01,.311870e01,.268847e01,.232179e01,.200867e01,       &
    .174103e01,.151159e01,.131472e01,.115353e01,.101629e01,       &
    .895370,.788942,.695164,.615041,.545511,.483404,.427977,      &
    .378600,.334562,.295439,.260605,.229681,.202224,.177869,      &
    .156306,.137232,.120385,.105501,.923507e-01,.807449e-01,      &
    .705135e-01,.615126e-01,.535945e-01,.466437e-01,.405427e-01,  &
    .351939e-01,.305104e-01,.264185e-01,.228440e-01,.197255e-01,  &
    .170075e-01,.145146e-01,.123870e-01,.105731e-01,.902476e-02,  &
    .770318e-02,.657513e-02,.561318e-02,.479197e-02,.409090e-02,  &
    .349296e-02/
  !
  !	INTERPOLACION PARABOLICA ENTRE TRES PUNTOS
  !
  !	CALL POLI2
  !
  i1=ha+1
  i0=i1-1
  i2=i1+1
  if (i0.gt.0)  go to 10
  i1=i1+1
  i2=i2+1
  i0=i0+1
10 x1=i0-1
  x2=i1-1
  x3=i2-1
  do 3 j=1,3
    go to (5,6,7)j
5   y1=pr(i0)
    y2=pr(i1)
    y3=pr(i2)
    call poli2_4(x1,x2,x3,y1,y2,y3,a,b,c)
    p=a+b*ha+c*ha**2
    go to 3
6   y1=te(i0)
    y2=te(i1)
    y3=te(i2)
    call poli2_4(x1,x2,x3,y1,y2,y3,a,b,c)
    t=a+b*ha+c*ha*ha
    go to 3
7   y1=den(i0)
    y2=den(i1)
    y3=den(i2)
    call poli2_4(x1,x2,x3,y1,y2,y3,a,b,c)
    d=a+b*ha+c*ha**2
3   continue
  return
end subroutine ase45
