!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
module cubeset_output
  use cubetools_structure
  use cubetools_setup_types
  use cubeset_messaging
  use cubetools_topic
  !
  public :: output,cubeset_output_command
  private
  !
  type :: output_comm_t
     type(option_t), pointer :: comm
     type(topic_opt_t)       :: extrema
     type(topic_opt_t)       :: write
     type(option_t), pointer :: defaults
   contains
     procedure, public  :: register => cubeset_output_register
     procedure, private :: parse    => cubeset_output_parse
     procedure, private :: main     => cubeset_output_main
     procedure, private :: list     => cubeset_output_list
  end type output_comm_t
  type(output_comm_t) :: output
  !
  type :: output_user_t
     logical :: list
     logical :: dodefaults
  end type output_user_t
  !
contains
  !
  subroutine cubeset_output_command(line,error)
    !---------------------------------------------------------------------
    ! Support routine for command
    ! OUTPUT Mode
    !---------------------------------------------------------------------
    character(len=*), intent(in)    :: line
    logical,          intent(inout) :: error
    !
    type(output_user_t) :: user
    character(len=*), parameter :: rname='OUTPUT>COMMAND'
    !
    call cubeset_message(setseve%trace,rname,'Welcome')
    !
    call output%parse(line,user,error)
    if (error) return
    call output%main(user,error)
    if (error) return
  end subroutine cubeset_output_command
  !
  !----------------------------------------------------------------------
  !
  subroutine cubeset_output_register(output,error)
    !---------------------------------------------------------------------
    ! 
    !---------------------------------------------------------------------
    class(output_comm_t), intent(inout) :: output
    logical,              intent(inout) :: error
    !
    character(len=*), parameter :: comm_abstract = &
         'Set how output cubes are handled'
    character(len=*), parameter :: comm_help = &
         '/EXTREMA Enables or disables the automatic computation&
         &/update of the extrema section in the header of the output&
         & cubes. Default is ON. /WRITE Enables or disables&
         & writing the cubes from memory to disk at the end of the&
         & processing commands. This makes sense for memory mode only.&
         & Default is ON.'
    character(len=*), parameter :: rname='OUTPUT>REGISTER'
    !
    call cubeset_message(setseve%trace,rname,'Welcome')
    !
    call cubetools_register_command(&
         'OUTPUT','',&
         comm_abstract,&
         comm_help,&
         cubeset_output_command,&
         output%comm,error)
    if (error) return
    !
    call output%extrema%register(&
         'EXTREMA',&
         'Enable or disable automatic extema calculation',&
         error)
    if (error) return
    call output%write%register(&
         'WRITE',&
         'Enable or disable flush to disk in disk mode',&
         error)
    if (error) return
    !
    call cubetools_register_option(&
         'DEFAULTS','',&
         'Reset output defaults',&
         strg_id,&
         output%defaults,error)
    if (error) return
  end subroutine cubeset_output_register
  !
  subroutine cubeset_output_parse(output,line,user,error)
    use cubeadm_setup
    !---------------------------------------------------------------------
    !
    !---------------------------------------------------------------------
    class(output_comm_t), intent(inout) :: output
    character(len=*),     intent(in)    :: line
    type(output_user_t),  intent(out)   :: user
    logical,              intent(inout) :: error
    !
    character(len=*), parameter :: rname='OUTPUT>PARSE'
    !
    call cubeset_message(setseve%trace,rname,'Welcome')
    !
    user%list = cubetools_nopt().eq.0
    !
    if (user%list) then
       ! nothing to do
    else
       call output%extrema%parse(line,error)
       if (error) return
       call output%write%parse(line,error)
       if (error) return
       call output%defaults%present(line,user%dodefaults,error)
       if (error) return
    endif
  end subroutine cubeset_output_parse
  !
  subroutine cubeset_output_main(output,user,error)
    use cubeadm_setup
    !---------------------------------------------------------------------
    !
    !---------------------------------------------------------------------
    class(output_comm_t), intent(inout) :: output
    type(output_user_t),  intent(in)    :: user
    logical,              intent(inout) :: error
    !
    character(len=*), parameter :: rname='OUTPUT>MAIN'
    !
    call cubeset_message(setseve%trace,rname,'Welcome')
    !
    if (user%list) then
       call output%list(error)
       if (error) return
    else
       if (user%dodefaults) then
          cubset%output%extrema  = .true.
          cubset%output%write    = .true.
       endif
       !
       if (output%extrema%do) cubset%output%extrema = output%extrema%enabled
       if (output%write%do)   cubset%output%write   = output%write%enabled
    endif
  end subroutine cubeset_output_main
  !
  subroutine cubeset_output_list(output,error)
    use cubeadm_setup
    !---------------------------------------------------------------------
    !
    !---------------------------------------------------------------------
    class(output_comm_t), intent(in)    :: output
    logical,              intent(inout) :: error
    !
    character(len=message_length) :: mess
    character(len=*), parameter :: rname='OUTPUT>LIST'
    !
    call cubeset_message(seve%r,rname,'  Output')
    write(mess,'(a,l)') '    EXTREMA: ',cubset%output%extrema
    call cubeset_message(seve%r,rname,mess)
    write(mess,'(a,l)') '    WRITE:   ',cubset%output%write
    call cubeset_message(seve%r,rname,mess)
  end subroutine cubeset_output_list
end module cubeset_output
!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
