subroutine set_pass (qsb,qband,qbt,qntch,pc,pl,error)
  use gildas_def
  use classic_api  
  !---------------------------------------------------------------------
  ! Computes the passband calibration factors
  ! Baseline or Antenna based.
  !---------------------------------------------------------------------
  integer :: qsb                    !
  integer :: qband                  !
  integer :: qbt                    !
  integer :: qntch                  !
  complex :: pc(qband,qsb,qbt)      !
  complex :: pl(qntch,qsb,qbt)      !
  logical :: error                  !
  ! Global
  include 'clic_parameter.inc'
  include 'clic_clic.inc'
  include 'clic_display.inc'
  include 'clic_number.inc'
  include 'clic_par.inc'
  ! Local
  real*8 :: xx, yamp, ypha, aa(0:mbpcdeg), ap(0:mbpcdeg)
  real*8 :: ak1, ak2
  complex :: apc(mcch,2,mnant), apl(mlch,2,mnant)
  ! number of channels
  integer :: nc, nl
  integer :: i, isb, ib, ic, k, it, ib1, ib2, ib3, ndeg, ia, ja
  integer :: inbc, j, isb1, isb2
  logical :: freq, same
  !
  !------------------------------------------------------------------------
  ! Code:
  if (do_pass_memory) then
    if (do_pass_antenna) then
      call  sub_store_pass_ant (.false.,error)
      if (error) goto 999
    else
      call  sub_store_pass (.false.,error)
      if (error) goto 999
    endif
  elseif (do_pass_antenna .and. iand(r_abpc,1).eq.0) then
    call message(6,2,'SET_PASS',   &
      'No Antenna RF Passband stored with the data')
    return
  elseif (.not.do_pass_antenna .and. iand(r_bpc,1).eq.0) then
    call message(6,2,'SET_PASS',   &
      'No Baseline RF Passband stored with the data')
    return
  endif
  freq = do_pass_freq
  nc = r_nband
  nl = r_lband
  !
  ! Check if solution was derived from same coefficients
  call check_coefficients_solution(do_pass_antenna,do_pass_freq,same)
  if (same) then
    call message(1,1,'SET_PASS', 'RF recomputation not needed')
    return
  else
    call message(1,1,'SET_PASS', 'Computing RF solution')
  endif
  ! Antenna based
  if (do_pass_antenna) then
    do i=1, nc             ! loop on continuun subbands
      ! Number of sidebands.
      if (r_lnsb.eq.1) then
        isb1 = r_sband(1,i)
        isb2 = isb1
      else 
        isb1 = 1
        isb2 = 2 
      endif
      !
      do isb=isb1, isb2
        do ia = 1, r_nant
          !
          ! Find NBC entry
          inbc = r_bb(i)
          !
          if (freq) then
            do j=0, r_abpfdeg
              aa(j) = r_abpfamp(inbc,isb,ia,j)
              ap(j) = r_abpfpha(inbc,isb,ia,j)
            enddo
            ak1 = r_abpflim(inbc,1)
            ak2 = r_abpflim(inbc,2)
            ndeg = r_abpfdeg
          endif
          !
          ! Continuum, by channel
          if (.not.freq) then
            yamp = r_abpccamp(inbc,isb,ia,i)
            ypha = r_abpccpha(inbc,isb,ia,i)
          ! Antenna-based calibration is done on log: default value
          ! should be zero, not 1
          !                     IF (YAMP.EQ.0) YAMP = 1.0
          ! Continuum, by frequency
          else
            xx = r_cfcen(i)
            xx = (2*xx-ak1-ak2)/(ak2-ak1)
            xx = min(1d0,max(-1d0,xx))
            call mth_getpol('SET_PASS',   &
              ndeg+1, aa, xx, yamp, error)
            if (error) goto 999
            call mth_getpol('SET_PASS',   &
              ndeg+1, ap, xx, ypha, error)
            if (error) goto 999
          endif
          apc(i,isb,ia) = exp(cmplx(-yamp,-ypha))
        enddo
        do ib=1, r_nbas
          ia = r_iant(ib)
          ja = r_jant(ib)
          pc(i,isb,ib) =   &
            apc(i,isb,ja)*conjg(apc(i,isb,ia))
        enddo
      enddo
    enddo
    !
    ! Line, by channel or frequency
    ! initialise, because of the unassigned channels due to possible
    ! narrow-band channels ...
    do ia = 1, r_nant
      do isb =1, 2
        do i=1, qntch
          apl(i,isb,ia) = cmplx(1.0,0.0)
        enddo
      enddo
    enddo
    k = 1
    do ic=1, nl
      ! Number of sidebands.
      if (r_lnsb.eq.1) then
        isb1 = r_lsband(1,ic)
        isb2 = isb1
      else 
        isb1 = 1
        isb2 = 2 
      endif
      !
      !
      inbc = r_bb(ic)
      !
      do isb=isb1, isb2
        do ia=1, r_nant
          k = r_lich(ic)+1
          if (freq) then
            do j=0, r_abpfdeg
              aa(j) = r_abpfamp(inbc,isb,ia,j)
              ap(j) = r_abpfpha(inbc,isb,ia,j)
            enddo
            ak1 = r_abpflim(inbc,1)
            ak2 = r_abpflim(inbc,2)
            ndeg = r_abpfdeg
          endif
          !
          if (.not.freq) then
            do i=0, r_abpcdeg
              aa(i) = r_abpclamp(inbc,isb,ia,ic,i)
              ap(i) = r_abpclpha(inbc,isb,ia,ic,i)
            enddo
            ak1 = k
            ak2 = k+r_lnch(ic)-1
            ndeg = r_abpcdeg
          endif
          do i=1, r_lnch(ic)
            if (freq) then
              xx = r_lfcen(ic) + (i-r_lcench(ic))*r_lfres(ic)
              xx = (2*xx-ak1-ak2)/(ak2-ak1)
            else
              xx= (2*k-ak1-ak2)/(ak2-ak1)
            endif
            xx = min(1d0,max(-1d0,xx))
            call mth_getpol('SET_PASS',   &
              ndeg+1, aa, xx, yamp, error)
            if (error) goto 999
            call mth_getpol('SET_PASS',   &
              ndeg+1, ap, xx, ypha, error)
            if (error) goto 999
            apl(k,isb,ia) = exp(cmplx(-yamp,-ypha))
            k = k + 1
          enddo
        enddo
        do ib = 1, r_nbas
          ia = r_iant(ib)
          ja = r_jant(ib)
          do i = r_lich(ic)+1, r_lich(ic)+r_lnch(ic)
            pl(i,isb,ib) =   &
              apl(i,isb,ja)*conjg(apl(i,isb,ia))
          enddo
        enddo
      enddo
    enddo
  !
  ! Baseline based
  else
    do i=1, nc
      !
      inbc = r_bb(i)
      ! Number of sidebands.
      if (r_lnsb.eq.1) then
        isb1 = r_lsband(1,i)
        isb2 = isb1
      else 
        isb1 = 1
        isb2 = 2
      endif
      !
      do isb=isb1, isb2
        do ib = 1, r_nbas
          if (freq) then
            do j=0, r_bpfdeg   ! default to continuum polyn.
              aa(j) = r_bpfamp(inbc,isb,ib,j)
              ap(j) = r_bpfpha(inbc,isb,ib,j)
            enddo
            ak1 = r_bpflim(inbc,1)
            ak2 = r_bpflim(inbc,2)
            ndeg = r_bpfdeg
          endif
          !
          ! Continuum, by channel
          if (.not.freq) then
            yamp = r_bpccamp(inbc,isb,ib,i)
            ypha = r_bpccpha(inbc,isb,ib,i)
            if (yamp.eq.0) yamp = 1.0
            if (yamp.ne.0) then
              pc(i,isb,ib) = 1./yamp*exp(cmplx(0.d0,-ypha))
            else
              pc(i,isb,ib) = 1.0
            endif
          ! Continuum, by frequency
          else
            xx = r_cfcen(i)
            xx = (2*xx-ak1-ak2)/(ak2-ak1)
            xx = min(1d0,max(-1d0,xx))
            call mth_getpol('SET_PASS',   &
              ndeg+1, aa, xx, yamp, error)
            if (error) goto 999
            call mth_getpol('SET_PASS',   &
              ndeg+1, ap, xx, ypha, error)
            if (error) goto 999
          endif
          if (yamp.ne.0) then
            pc(i,isb,ib) = 1./yamp*exp(cmplx(0.d0,-ypha))
          else
            pc(i,isb,ib) = 1.0
          endif
        enddo
     enddo
   enddo 
   !
   ! Line, by channel or frequency
   k=1
   do ic=1, nl
     !
     inbc = r_bb(ic)
     ! Number of sidebands.
     if (r_lnsb.eq.1) then
       isb1 = r_lsband(1,ic)
       isb2 = isb1
     else 
       isb1 = 1
       isb2 = 2
     endif
     do isb = isb1, isb2
       do ib =1, r_nbas
          if (freq) then
            do j=0, r_bpfdeg   ! default to continuum polyn.
              aa(j) = r_bpfamp(inbc,isb,ib,j)
              ap(j) = r_bpfpha(inbc,isb,ib,j)
            enddo
            ak1 = r_bpflim(inbc,1)
            ak2 = r_bpflim(inbc,2)
            ndeg = r_bpfdeg
          endif
          !
          if (k .lt. r_lich(ic)+1) then
            do i=k, r_lich(ic)
              pl(i,isb,ib) = cmplx(1.0,0.0)
            enddo
            k = r_lich(ic)+1
          endif
          if (k .gt. r_lich(ic)+r_lnch(ic)) k = r_lich(ic)+1
          if (.not.freq) then
            do i=0, r_bpcdeg
              aa(i) = r_bpclamp(inbc,isb,ib,ic,i)
              ap(i) = r_bpclpha(inbc,isb,ib,ic,i)
            enddo
            ak1 = k
            ak2 = k+r_lnch(ic)-1
            ndeg = r_bpcdeg
          endif
          do i=1, r_lnch(ic)
            if (freq) then
              xx = r_lfcen(ic) + (i-r_lcench(ic))*r_lfres(ic)
              xx = (2*xx-ak1-ak2)/(ak2-ak1)
            else
              xx= (2*k-ak1-ak2)/(ak2-ak1)
            endif
            xx = min(1d0,max(-1d0,xx))
            call mth_getpol('SET_PASS',   &
              ndeg+1, aa, xx, yamp, error)
            if (error) goto 999
            call mth_getpol('SET_PASS',   &
              ndeg+1, ap, xx, ypha, error)
            if (error) goto 999
            if (yamp.ne.0) then
              pl(k,isb,ib) = 1d0/yamp*exp(cmplx(0d0,-ypha))
            else
              pl(k,isb,ib) = 1.0
            endif
            k = k + 1
          enddo
        enddo
      enddo
    enddo
  !
  endif
  !
  ! Store coefficients used to compute solution
  call store_coefficients_solution(do_pass_antenna,do_pass_freq)
  !
  ! Compute also for triangles, if any
  if (r_ntri.le.0) return
  do it = 1, r_ntri
    ib1 = bastri(1,it)
    ib2 = bastri(2,it)
    ib3 = bastri(3,it)
    !
    ! Number of sidebands.
    do ic=1, nc
      if (r_lnsb.eq.1) then
        isb1 = r_lsband(1,ic)
        isb2 = isb1
      else 
        isb1 = 1
        isb2 = 2
      endif
      !
      do isb=isb1, isb2
        pc(i,isb,r_nbas+it) = pc(i,isb,ib1)   &
          * conjg(pc(i,isb,ib2)) * pc(i,isb,ib3)
      enddo
    enddo
    do ic=1, nl
      if (r_lnsb.eq.1) then
        isb1 = r_lsband(1,ic)
        isb2 = isb1
      else 
        isb1 = 1
        isb2 = 2
      endif
      !
      do isb=isb1, isb2
        do i=r_lich(ic)+1, r_lich(ic)+r_lnch(ic)
          pl(i,isb,r_nbas+it) = pl(i,isb,ib1)   &
            * conjg(pl(i,isb,ib2)) * pl(i,isb,ib3)
        enddo
      enddo
    enddo
  enddo
  return
999 error = .true.
  return
end subroutine set_pass
!
subroutine store_coefficients_solution(antenna,freq)
  use clic_rf_solution
  !
  logical  :: antenna
  logical  :: freq
  !
  include 'clic_par.inc'
  !
  integer :: ia,ibb,ic,il,isb,isb1,isb2,j
  !
  rf%antenna = antenna
  rf%freq    = freq
  !
  if (antenna) then
    rf%ant%nant = r_nant
    rf%ant%nc   = r_nband
    rf%ant%nl   = r_lband
    rf%ant%nsb  = r_lnsb
    rf%ant%nbb  = r_nbb
    do il=1, rf%ant%nl
      rf%ant%isb(il) = r_lsband(1,il)
      rf%ant%ibb(il) = r_bb(il)
    enddo
    if (freq) then
      rf%ant%freq%deg = r_abpfdeg
      do il=1, rf%ant%nl
        if (rf%ant%nsb.eq.1) then
          isb1 = rf%ant%isb(il)
          isb2 = isb1
        else
          isb1 = 1
          isb2 = 2
        endif
        ! 
        ibb = rf%ant%ibb(il)
        !
        rf%ant%freq%lim(ibb,:) = r_abpflim(ibb,:)
        do isb=isb1, isb2
          do ia=1, rf%ant%nant
            do j=0, rf%ant%freq%deg
              rf%ant%freq%amp(ibb,isb,ia,j) = r_abpfamp(ibb,isb,ia,j)
              rf%ant%freq%pha(ibb,isb,ia,j) = r_abpfpha(ibb,isb,ia,j)
            enddo
          enddo
        enddo
      enddo 
    else
      do ic=1, rf%ant%nc
        if (rf%ant%nsb.eq.1) then
          isb1 = rf%ant%isb(ic)
          isb2 = isb1
        else
          isb1 = 1
          isb2 = 2
        endif
        ! 
        ibb = rf%ant%ibb(ic)
        !
        do isb=isb1, isb2
          do ia=1, rf%ant%nant
            rf%ant%chan%camp(ibb,isb,ia,ic) = r_abpccamp(ibb,isb,ia,ic)
            rf%ant%chan%cpha(ibb,isb,ia,ic) = r_abpccpha(ibb,isb,ia,ic)
          enddo
        enddo       
      enddo 
      rf%ant%chan%deg = r_abpcdeg
      do il=1, rf%ant%nl
        if (rf%ant%nsb.eq.1) then
          isb1 = rf%ant%isb(il)
          isb2 = isb1
        else
          isb1 = 1
          isb2 = 2
        endif
        ! 
        ibb = rf%ant%ibb(il)
        !
        do isb=isb1, isb2
          do ia=1, rf%ant%nant
            do j=0, rf%ant%chan%deg
              rf%ant%chan%lamp(ibb,isb,ia,il,j) = r_abpclamp(ibb,isb,ia,il,j)
              rf%ant%chan%lpha(ibb,isb,ia,il,j) = r_abpclpha(ibb,isb,ia,il,j)
            enddo
          enddo
        enddo
      enddo
    endif
  else
    rf%bas%nbas = r_nbas
    rf%bas%nc   = r_nband
    rf%bas%nl   = r_lband
    rf%bas%nsb  = r_lnsb
    rf%bas%nbb  = r_nbb
    do il=1, rf%bas%nl
      rf%bas%isb(il) = r_lsband(1,il)
      rf%bas%ibb(il) = r_bb(il)
    enddo
    if (freq) then
      rf%bas%freq%deg = r_bpfdeg
      do il=1, rf%bas%nl
        if (rf%bas%nsb.eq.1) then
          isb1 = rf%bas%isb(il)
          isb2 = isb1
        else
          isb1 = 1
          isb2 = 2
        endif
        ! 
        ibb = rf%bas%ibb(il)
        !
        rf%bas%freq%lim(ibb,:) = r_bpflim(ibb,:)
        do isb=isb1, isb2
          do ia=1, rf%bas%nbas
            do j=0, rf%bas%freq%deg
              rf%bas%freq%amp(ibb,isb,ia,j) = r_bpfamp(ibb,isb,ia,j)
              rf%bas%freq%pha(ibb,isb,ia,j) = r_bpfpha(ibb,isb,ia,j)
            enddo
          enddo
        enddo
      enddo 
    else
      do ic=1, rf%bas%nc
        if (rf%bas%nsb.eq.1) then
          isb1 = rf%bas%isb(ic)
          isb2 = isb1
        else
          isb1 = 1
          isb2 = 2
        endif
        ! 
        ibb = rf%bas%ibb(ic)
        !
        do isb=isb1, isb2 
          do ia=1, rf%bas%nbas
            rf%bas%chan%camp(ibb,isb,ia,ic) = r_bpccamp(ibb,isb,ia,ic)
            rf%bas%chan%cpha(ibb,isb,ia,ic) = r_bpccpha(ibb,isb,ia,ic)
          enddo
        enddo       
      enddo 
      rf%bas%chan%deg = r_bpcdeg
      do il=1, rf%bas%nl
        if (rf%bas%nsb.eq.1) then
          isb1 = rf%bas%isb(il)
          isb2 = isb1
        else
          isb1 = 1
          isb2 = 2
        endif
        ! 
        ibb = rf%bas%ibb(il)
        !
        do isb=isb1, isb2
          do ia=1, rf%bas%nbas
            do j=0, rf%bas%chan%deg
              rf%bas%chan%lamp(ibb,isb,ia,il,j) = r_bpclamp(ibb,isb,ia,il,j)
              rf%bas%chan%lpha(ibb,isb,ia,il,j) = r_bpclpha(ibb,isb,ia,il,j)
            enddo
          enddo
        enddo
      enddo
    endif
  endif
  return
end subroutine store_coefficients_solution

subroutine check_coefficients_solution(antenna,freq,equal)
  use clic_rf_solution
  !
  logical  :: antenna
  logical  :: freq
  logical  :: equal
  !
  include 'clic_par.inc'
  !
  integer :: ia,ibb,ic,il,isb,isb1,isb2,j
  !
  equal = .false.
  !
  if ((antenna.neqv.rf%antenna).or.(freq.neqv.rf%freq)) return
  !
  if (antenna) then
    !
    ! Antenna-based
    if (rf%ant%nant .ne. r_nant ) return
    if (rf%ant%nc   .ne. r_nband) return
    if (rf%ant%nl   .ne. r_lband) return
    if (rf%ant%nsb  .ne. r_lnsb)  return
    if (rf%ant%nbb  .ne. r_nbb)   return
    if (any(rf%ant%isb(1:r_lband).ne.r_lsband(1,1:r_lband))) return
    if (any(rf%ant%ibb(1:r_lband).ne.r_bb(1:r_lband))) return
    !
    if (freq) then
      !
      ! By frequency
      if (rf%ant%freq%deg .ne. r_abpfdeg ) return
      do il=1, rf%ant%nl
        if (rf%ant%nsb.eq.1) then
          isb1 = rf%ant%isb(il)
          isb2 = isb1
        else
          isb1 = 1
          isb2 = 2
        endif
        ! 
        ibb = rf%ant%ibb(il)
        !
        if (any(rf%ant%freq%lim(ibb,:).ne.r_abpflim(ibb,:))) return
        do isb=isb1, isb2
          if (any(rf%ant%freq%amp(ibb,isb,1:r_nant,1:r_abpfdeg) &
             .ne. r_abpfamp(ibb,isb,1:r_nant,1:r_abpfdeg))) return
          if (any(rf%ant%freq%pha(ibb,isb,1:r_nant,1:r_abpfdeg) &
             .ne. r_abpfpha(ibb,isb,1:r_nant,1:r_abpfdeg))) return
        enddo
      enddo 
    else
      !
      ! By channel
      do ic=1, rf%ant%nc
        if (rf%ant%nsb.eq.1) then
          isb1 = rf%ant%isb(ic)
          isb2 = isb1
        else
          isb1 = 1
          isb2 = 2
        endif
        ! 
        ibb = rf%ant%ibb(ic)
        !
        do isb=isb1, isb2
          if (any(rf%ant%chan%camp(ibb,isb,1:r_nant,ic) &
             .ne. r_abpccamp(ibb,isb,1:r_nant,ic))) return
          if (any(rf%ant%chan%cpha(ibb,isb,1:r_nant,ic) &
             .ne. r_abpccpha(ibb,isb,1:r_nant,ic))) return
        enddo
      enddo
      if (rf%ant%chan%deg .ne. r_abpcdeg ) return
      do il=1, rf%ant%nl
        if (rf%ant%nsb.eq.1) then
          isb1 = rf%ant%isb(il)
          isb2 = isb1
        else
          isb1 = 1
          isb2 = 2
        endif
        ! 
        ibb = rf%ant%ibb(il)
        !
        do isb=isb1, isb2
          if (any(rf%ant%chan%lamp(ibb,isb,1:r_nant,il,1:r_abpfdeg) &
             .ne. r_abpclamp(ibb,isb,1:r_nant,il,1:r_abpfdeg))) return
          if (any(rf%ant%chan%lpha(ibb,isb,1:r_nant,il,1:r_abpfdeg) &
             .ne. r_abpclpha(ibb,isb,1:r_nant,il,1:r_abpfdeg))) return
        enddo
      enddo
    endif
  else
    !
    ! Baseline-based
    if (rf%bas%nbas .ne. r_nbas ) return
    if (rf%bas%nc   .ne. r_nband) return
    if (rf%bas%nl   .ne. r_lband) return
    if (rf%bas%nsb  .ne. r_lnsb)  return
    if (rf%bas%nbb  .ne. r_nbb)   return
    if (any(rf%bas%isb(1:r_lband).ne.r_lsband(1,1:r_lband))) return
    if (any(rf%bas%ibb(1:r_lband).ne.r_bb(1:r_lband))) return
    !
    if (freq) then
      !
      ! By frequency
      if (rf%bas%freq%deg .ne. r_bpfdeg ) return
      do il=1, rf%bas%nl
        if (rf%bas%nsb.eq.1) then
          isb1 = rf%bas%isb(il)
          isb2 = isb1
        else
          isb1 = 1
          isb2 = 2
        endif
        ! 
        ibb = rf%bas%ibb(il)
        !
        if (any(rf%bas%freq%lim(ibb,:).ne.r_bpflim(ibb,:))) return
        do isb=isb1, isb2
          if (any(rf%bas%freq%amp(ibb,isb,1:r_nbas,1:r_bpfdeg) &
             .ne. r_bpfamp(ibb,isb,1:r_nbas,1:r_bpfdeg))) return
          if (any(rf%bas%freq%pha(ibb,isb,1:r_nbas,1:r_bpfdeg) &
             .ne. r_bpfpha(ibb,isb,1:r_nbas,1:r_bpfdeg))) return
        enddo
      enddo 
    else
      !
      ! By channel
      do ic=1, rf%bas%nc
        if (rf%bas%nsb.eq.1) then
          isb1 = rf%bas%isb(ic)
          isb2 = isb1
        else
          isb1 = 1
          isb2 = 2
        endif
        ! 
        ibb = rf%bas%ibb(ic)
        !
        do isb=isb1, isb2
          if (any(rf%bas%chan%camp(ibb,isb,1:r_nbas,ic) &
             .ne. r_bpccamp(ibb,isb,1:r_nbas,ic))) return
          if (any(rf%bas%chan%cpha(ibb,isb,1:r_nbas,ic) &
             .ne. r_bpccpha(ibb,isb,1:r_nbas,ic))) return
        enddo
      enddo
      if (rf%bas%chan%deg .ne. r_bpcdeg ) return
      do il=1, rf%bas%nl
        if (rf%bas%nsb.eq.1) then
          isb1 = rf%bas%isb(il)
          isb2 = isb1
        else
          isb1 = 1
          isb2 = 2
        endif
        ! 
        ibb = rf%bas%ibb(il)
        !
        do isb=isb1, isb2
          if (any(rf%bas%chan%lamp(ibb,isb,1:r_nbas,il,1:r_bpfdeg) &
             .ne. r_bpclamp(ibb,isb,1:r_nbas,il,1:r_bpfdeg))) return
          if (any(rf%bas%chan%lpha(ibb,isb,1:r_nbas,il,1:r_bpfdeg) &
             .ne. r_bpclpha(ibb,isb,1:r_nbas,il,1:r_bpfdeg))) return
        enddo
      enddo
    endif
  endif
  equal = .true.
  return
end subroutine check_coefficients_solution
!
subroutine set_spidx (qsb,qband,qbt,qntch,pc,pl,idx,error)
  use gildas_def
  use classic_api
  !---------------------------------------------------------------------
  ! Computes the passband spectral index correction
  !---------------------------------------------------------------------
  integer :: qsb                    !
  integer :: qband                  !
  integer :: qbt                    !
  integer :: qntch                  !
  complex :: pc(qband,qsb,qbt)      !
  complex :: pl(qntch,qsb,qbt)      !
  real    :: idx
  logical :: error                  !
  ! Global
  include 'clic_parameter.inc'
  include 'clic_clic.inc'
  include 'clic_display.inc'
  include 'clic_number.inc'
  include 'clic_par.inc'
  ! Local
  real*8 :: xx, yamp, ypha, aa(0:mbpcdeg), ap(0:mbpcdeg)
  real*8 :: ak1, ak2
  complex :: apc(mcch,2,mnant), apl(mlch,2,mnant)
  ! number of channels
  integer :: nc, nl, old_spidx
  integer :: i, isb, ib, ic, k, it, ib1, ib2, ib3, ndeg, ia, ja
  integer :: inbc, j, isb1, isb2
  integer, save :: old_idx 
  real :: freq, ref
  !
  !------------------------------------------------------------------------
  ! Code:
  if (idx.eq.0) return
  nc = r_nband
  nl = r_lband
  ref = r_flo1+r_isb*r_fif1
  !
  ! Check if correction was computed for the same spectral index
  if (old_idx.eq.idx) return
  do i = 1, nc
    ! Number of sidebands.
    if (r_lnsb.eq.1) then
      isb1 = r_sband(1,i)
      isb2 = isb1
    else
      isb1 = 1
      isb2 = 2
    endif
    !
    do isb=isb1, isb2
      freq = r_flo1+(3-2*isb)*(r_flo2(i) &
           + r_band2(i)*(r_flo2bis(i)+r_band2bis(i)*r_lfcen(i)))
      pc(i,isb,1:qbt) = cmplx((freq/ref)**idx,0)
    enddo
  enddo
  do ic =1, nl
    ! Number of sidebands.
    if (r_lnsb.eq.1) then
      isb1 = r_sband(1,ic)
      isb2 = isb1
    else
      isb1 = 1
      isb2 = 2
    endif
    !
    do isb=isb1, isb2
      k = r_lich(ic)+1
      do i=1, r_lnch(ic)
        freq = r_flo1+(3-2*isb)*(r_flo2(ic) &
           + r_band2(ic)*(r_flo2bis(ic)+r_band2bis(ic)*r_lfcen(ic) &
           + (i-r_lcench(ic))*r_lfres(ic)))
        pl(k,isb,1:qbt) = cmplx((freq/ref)**-idx,0)
        k = k + 1
      enddo
    enddo
  enddo
  old_idx = idx
  return
end subroutine set_spidx

