# This scripts retrieves the proper options to be used to link against
# the libpython, in a machine-independant way. It invokes the official
# script python-config (which thankfully deals with all the details).

# From now on avoid duplicating python-config, which evolves on its own.
# Invoke 'python-config --ldflags --embed'. The embed option (under
# Python 3) adds the libpython itself, whose name is highly
# unpredictible under the variety of machines and configurations we
# support
import subprocess
output = subprocess.check_output(['python-config', '--ldflags','--embed'])
output = output.decode('utf-8')
#print(output)

args = output.split()

output = ''
for arg in args:
  # Discard /usr/lib* path which causes troubles on the link command
  # line, as it basically overrides all other custom paths coming after
  # it. No need to put these paths on command line, they are found
  # implicitly by the linker.
  if arg not in ['-L/usr/lib','-L/usr/lib32','-L/usr/lib64']:
    output += arg+' '

print(output)
