!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
module cubemain_template_spe_inplace
  use cube_types
  use cubemain_messaging
  use cubetools_structure
  use cubeadm_cubeid_types
  !
  public :: cubemain_template_spe_inplace_command
  private
  !
  integer(kind=4), parameter :: icube = 1 
  type(option_t), pointer :: template
  !
  type template_user_t
     type(cubeid_user_t)   :: incube
  end type template_user_t
  type template_prog_t
     type(cube_t), pointer :: cube
  end type template_prog_t
  !
contains
  !
  subroutine cubemain_template_spe_inplace_command(opt,line,error)
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    type(option_t),pointer, intent(in)    :: opt
    character(len=*),       intent(in)    :: line
    logical,                intent(inout) :: error
    !
    type(template_user_t) :: user
    type(template_prog_t) :: prog
    character(len=*), parameter :: rname='TEMPLATE>COMMAND'
    !
    call cubemain_message(mainseve%trace,rname,'Welcome')
    !
    template => opt
    call cubemain_template_spe_inplace_parse(line,user,error)
    if (error) return
    call cubemain_template_spe_inplace_main(user,prog,error)
    if (error) continue
  end subroutine cubemain_template_spe_inplace_command
  !
  subroutine cubemain_template_spe_inplace_parse(line,user,error)
    use cubetools_parse
    !----------------------------------------------------------------------
    ! TEMPLATE cubname
    !----------------------------------------------------------------------
    character(len=*),      intent(in)    :: line
    type(template_user_t), intent(out)   :: user
    logical,               intent(inout) :: error
    !
    character(len=*), parameter :: rname='TEMPLATE>PARSE'
    !
    call cubemain_message(mainseve%trace,rname,'Welcome')
    !
    call cubeadm_cubeid_parse(line,template,user%incube,error)
    if (error) return
  end subroutine cubemain_template_spe_inplace_parse
  !
  subroutine cubemain_template_spe_inplace_main(user,prog,error)
    use cubeadm_get
    use cubeadm_timing
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    type(template_user_t), intent(in)    :: user
    type(template_prog_t), intent(inout) :: prog
    logical,               intent(inout) :: error
    !
    character(len=*), parameter :: rname='TEMPLATE>MAIN'
    !
    call cubemain_message(mainseve%trace,rname,'Welcome')
    !
    call cubeadm_cubeid_get_header(template,icube,user%incube,code_access_speset,code_update,prog%cube,error)
    if (error) return
    call cubemain_template_spe_inplace_header(user,prog,error)
    if (error) return
    call cubeadm_timing_prepro2process()
    call cubemain_template_spe_inplace_data(prog,error)
    if (error) return
    call cubeadm_timing_process2postpro()
  end subroutine cubemain_template_spe_inplace_main
  !
  subroutine cubemain_template_spe_inplace_header(user,prog,error)
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    type(template_user_t), intent(in)    :: user
    type(template_prog_t), intent(inout) :: prog
    logical,               intent(inout) :: error
    !
    character(len=*), parameter :: rname='TEMPLATE>HEADER'
    !
    call cubemain_message(mainseve%trace,rname,'Welcome')
    !
    prog%cube%head%spa%source = 'COUCOU'
  end subroutine cubemain_template_spe_inplace_header
  !
  subroutine cubemain_template_spe_inplace_data(prog,error)
    use cubeadm_opened
    !----------------------------------------------------------------------
    ! 
    !----------------------------------------------------------------------
    type(template_prog_t), intent(inout) :: prog
    logical,               intent(inout) :: error
    !
    type(cubeadm_iterator_t) :: iter
    character(len=*), parameter :: rname='TEMPLATE>DATA'
    !
    call cubemain_message(mainseve%trace,rname,'Welcome')
    !
    call cubeadm_datainit_all(iter,error)
    if (error) return
    !$OMP PARALLEL DEFAULT(none) SHARED(prog,error) FIRSTPRIVATE(iter)
    !$OMP SINGLE
    do while (cubeadm_dataiterate_all(iter,error))
       if (error)  exit
       !$OMP TASK
       if (.not.error)  &
         call cubemain_template_spe_inplace_spectrum_loop(prog,iter%first,iter%last,error)
       !$OMP END TASK
    enddo
    !$OMP END SINGLE
    !$OMP END PARALLEL
  end subroutine cubemain_template_spe_inplace_data
  !
  subroutine cubemain_template_spe_inplace_spectrum_loop(prog,first,last,error)
    use cubeadm_entryloop
    use cubemain_spectrum
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    type(template_prog_t), intent(inout) :: prog
    integer(kind=entr_k),  intent(in)    :: first
    integer(kind=entr_k),  intent(in)    :: last
    logical,               intent(inout) :: error
    !
    integer(kind=entr_k) :: ie
    type(spectrum_t) :: spec
    character(len=*), parameter :: rname='TEMPLATE>SPECTRUM>LOOP'
    !
    call cubemain_spectrum_init(prog%cube,spec,error)
    if (error) goto 10
    !
    do ie=first,last
      call cubeadm_entryloop_iterate(ie,error)
      if (error)  goto 10
      call cubemain_template_spe_inplace_spectrum(prog,ie,spec,error)
      if (error)  goto 10
    enddo
    !
10  continue
    call cubemain_spectrum_free(spec,error)
    if (error)  continue
  end subroutine cubemain_template_spe_inplace_spectrum_loop
  !
  subroutine cubemain_template_spe_inplace_spectrum(prog,ie,spec,error)
    use cubemain_spectrum
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    type(template_prog_t), intent(inout) :: prog
    integer(kind=entr_k),  intent(in)    :: ie
    type(spectrum_t),      intent(inout) :: spec
    logical,               intent(inout) :: error
    !
    integer(kind=chan_k) :: ic,nc
    character(len=*), parameter :: rname='TEMPLATE>SPECTRUM'
    !
    nc = prog%cube%head%arr%n%c
    !
    call cubemain_spectrum_get(prog%cube,ie,spec,error)
    if (error)  return
    do ic=1,nc
      spec%t(ic) = spec%t(ic)+1
    enddo ! ic
    ! While the spectrum is a pointer to the data, putting it is
    ! still needed because:
    ! 1) this call ensures the extrema section is up-to-date
    ! 2) in disk mode, the data buffers must be flagged as modified
    !    to ensure they are flushed back to disk.
    call cubemain_spectrum_put(prog%cube,ie,spec,error)
    if (error)  return
  end subroutine cubemain_template_spe_inplace_spectrum
end module cubemain_template_spe_inplace
!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
