!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
module cubetemplate_fullcube2fullcube
  use cube_types
  use cubetools_structure
  use cubeadm_cubeid_types
  use cubeadm_cubeprod_types
  use cubetemplate_factor_types
  use cubetopology_cuberegion_types
  use cubetemplate_messaging
  !
  public :: fullcube2fullcube
  public :: cubetemplate_fullcube2fullcube_command
  private
  !
  type :: fullcube2fullcube_comm_t
     type(option_t), pointer :: comm  
     type(factor_comm_t)     :: factor
     type(cuberegion_comm_t) :: region
     type(cubeid_arg_t), pointer :: incube
     type(cube_prod_t),  pointer :: oucube
  contains
     procedure, public  :: register => cubetemplate_fullcube2fullcube_comm_register
     procedure, private :: parse    => cubetemplate_fullcube2fullcube_comm_parse
     procedure, private :: main     => cubetemplate_fullcube2fullcube_comm_main
  end type fullcube2fullcube_comm_t
  type(fullcube2fullcube_comm_t) :: fullcube2fullcube
  !
  type fullcube2fullcube_user_t
     type(cubeid_user_t)     :: cubeids
     type(factor_user_t)     :: factor
     type(cuberegion_user_t) :: region
   contains
     procedure, private :: toprog => cubetemplate_fullcube2fullcube_user_toprog
  end type fullcube2fullcube_user_t
  !
  type fullcube2fullcube_prog_t
     type(cuberegion_prog_t) :: region
     type(factor_prog_t)     :: factor
     type(cube_t), pointer   :: incube
     type(cube_t), pointer   :: oucube
   contains
     procedure, private :: header => cubetemplate_fullcube2fullcube_prog_header
     procedure, private :: data   => cubetemplate_fullcube2fullcube_prog_data
     procedure, private :: act    => cubetemplate_fullcube2fullcube_prog_act
  end type fullcube2fullcube_prog_t
  !
contains
  !
  subroutine cubetemplate_fullcube2fullcube_command(line,error)
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    character(len=*), intent(in)    :: line
    logical,          intent(inout) :: error
    !
    type(fullcube2fullcube_user_t) :: user
    character(len=*), parameter :: rname='FULLCUBE2FULLCUBE>COMMAND'
    !
    call cubetemplate_message(templateseve%trace,rname,'Welcome')
    !
    call fullcube2fullcube%parse(line,user,error)
    if (error) return
    call fullcube2fullcube%main(user,error)
    if (error) continue
  end subroutine cubetemplate_fullcube2fullcube_command
  !
  !----------------------------------------------------------------------
  !
  subroutine cubetemplate_fullcube2fullcube_comm_register(comm,error)
    use cubedag_allflags
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(fullcube2fullcube_comm_t), intent(inout) :: comm
    logical,                         intent(inout) :: error
    !
    type(cubeid_arg_t) :: incube
    type(cube_prod_t) :: oucube
    character(len=*), parameter :: comm_abstract = 'Template command to access input/output data per fullcube'
    character(len=*), parameter :: comm_help = 'Input and output cube are real'
    character(len=*), parameter :: rname='FULLCUBE2FULLCUBE>COMM>REGISTER'
    !
    call cubetemplate_message(templateseve%trace,rname,'Welcome')
    !
    call cubetools_register_command(&
!         'FULLCUBE2FULLCUBE','[cubeid]',& ! *** JP: SIC limitation?
         'FULCUBE2FULCUBE','[cubeid]',&
         comm_abstract,&
         comm_help,&
         cubetemplate_fullcube2fullcube_command,&
         comm%comm,&
         error)
    if (error) return
    call incube%register(&
         'INPUT',&
         'Signal cube',&
         strg_id,&
         code_arg_optional,&
         [flag_any],&
         code_read,&
         code_access_fullset,&
         comm%incube,&
         error)
    if (error) return
    call comm%factor%register(error)
    if (error) return
    call comm%region%register(error)
    if (error) return
    !
    ! Products
    call oucube%register(&
         'OUTPUT',&
         'Output cube',&
         strg_id,&
         [flag_template],&
         comm%oucube,&
         error)
    if (error)  return
  end subroutine cubetemplate_fullcube2fullcube_comm_register
  !
  subroutine cubetemplate_fullcube2fullcube_comm_parse(comm,line,user,error)
    !----------------------------------------------------------------------
    ! fulcube2fulcube cubeid
    !----------------------------------------------------------------------
    class(fullcube2fullcube_comm_t), intent(in)    :: comm
    character(len=*),                intent(in)    :: line
    type(fullcube2fullcube_user_t),  intent(out)   :: user
    logical,                         intent(inout) :: error
    !
    character(len=*), parameter :: rname='FULLCUBE2FULLCUBE>COMM>PARSE'
    !
    call cubetemplate_message(templateseve%trace,rname,'Welcome')
    !
    call cubeadm_cubeid_parse(line,comm%comm,user%cubeids,error)
    if (error) return
    call comm%region%parse(line,user%region,error)
    if (error) return
    call comm%factor%parse(line,user%factor,error)
    if (error) return
  end subroutine cubetemplate_fullcube2fullcube_comm_parse
  !
  subroutine cubetemplate_fullcube2fullcube_comm_main(comm,user,error) 
    use cubeadm_timing
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(fullcube2fullcube_comm_t), intent(in)    :: comm
    type(fullcube2fullcube_user_t),  intent(inout) :: user
    logical,                         intent(inout) :: error
    !
    type(fullcube2fullcube_prog_t) :: prog
    character(len=*), parameter :: rname='FULLCUBE2FULLCUBE>COMM>MAIN'
    !
    call cubetemplate_message(templateseve%trace,rname,'Welcome')
    !
    call user%toprog(comm,prog,error)
    if (error) return
    call prog%header(comm,error)
    if (error) return
    call cubeadm_timing_prepro2process()
    call prog%data(error)
    if (error) return
    call cubeadm_timing_process2postpro()
  end subroutine cubetemplate_fullcube2fullcube_comm_main
  !
  !----------------------------------------------------------------------
  !
  subroutine cubetemplate_fullcube2fullcube_user_toprog(user,comm,prog,error)
    use cubeadm_get
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(fullcube2fullcube_user_t), intent(in)    :: user
    type(fullcube2fullcube_comm_t),  intent(in)    :: comm
    type(fullcube2fullcube_prog_t),  intent(out)   :: prog
    logical,                         intent(inout) :: error
    !
    character(len=*), parameter :: rname='FULLCUBE2FULLCUBE>USER>TOPROG'
    !
    call cubetemplate_message(templateseve%trace,rname,'Welcome')
    !
    call cubeadm_cubeid_get_header(comm%incube,user%cubeids,prog%incube,error)
    if (error) return
    call user%factor%toprog(prog%factor,error)
    if (error) return
    call user%region%toprog(prog%incube,prog%region,error)
    if (error) return
    ! User feedback about the interpretation of his command line
    call prog%factor%list(error)
    if (error) return
    call prog%region%list(error)
    if (error) return
  end subroutine cubetemplate_fullcube2fullcube_user_toprog
  !
  !----------------------------------------------------------------------
  !
  subroutine cubetemplate_fullcube2fullcube_prog_header(prog,comm,error)
    use cubeadm_clone
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(fullcube2fullcube_prog_t), intent(inout) :: prog
    type(fullcube2fullcube_comm_t),  intent(in)    :: comm
    logical,                         intent(inout) :: error
    !
    character(len=*), parameter :: rname='FULLCUBE2FULLCUBE>PROG>HEADER'
    !
    call cubetemplate_message(templateseve%trace,rname,'Welcome')
    !
    call cubeadm_clone_header(comm%oucube,prog%incube,prog%oucube,error)
    if (error) return
    call prog%factor%header(prog%oucube,error)
    if (error) return
    call prog%region%header(prog%oucube,error)
    if (error) return
  end subroutine cubetemplate_fullcube2fullcube_prog_header
  !
  subroutine cubetemplate_fullcube2fullcube_prog_data(prog,error)
    use cubeadm_opened
    use cubeadm_taskloop
    use cubeadm_subcube_types
    !----------------------------------------------------------------------
    ! Structure is simplified compared to other cases because only one task
    ! can work on a full cube at a time by construction!
    !----------------------------------------------------------------------
    class(fullcube2fullcube_prog_t), intent(inout) :: prog
    logical,                         intent(inout) :: error
    !
    type(cubeadm_iterator_t) :: iter
    ! *** SB: as of today we rely on the subcube_t, but we could
    !         introduce a fullcube2fullcube_t (extended from subcube_t, with
    !         nothing more added) just for clarity.
    type(subcube_t) :: insub,ousub
    character(len=*), parameter :: rname='FULLCUBE2FULLCUBE>PROG>DATA'
    !
    call cubetemplate_message(templateseve%trace,rname,'Welcome')
    !
    ! 1. Open in and out cubes
    ! 2. Prepare parallel tasking (here only one task)
    ! 2. Define iterator of entries (here only one subcube)
    ! 3. Command feedback 
    call cubeadm_datainit_all(iter,error)
    if (error) return
    ! Loop on task => Only one task, ie, one iteration
    do while (cubeadm_dataiterate_all(iter,error))
       ! Loop on subcubes.
       do while (iter%iterate_entry(error))
          ! Prepare the input subcube for the next get
          call insub%associate('insub',prog%incube,iter,error)
          if (error) return
          ! Prepare the output subcube for the next put
          call ousub%allocate('ousub',prog%oucube,iter,error)
          if (error) return
          ! Get next input subcube
          call insub%get(error)
          if (error) return
          ! Does the computation
          call prog%act(insub,ousub,error)
          if (error) return
          ! Put next output subcube
          call ousub%put(error)
          if (error) return
       enddo  ! ientry
    enddo ! itask
  end subroutine cubetemplate_fullcube2fullcube_prog_data
  !   
  subroutine cubetemplate_fullcube2fullcube_prog_act(prog,insub,ousub,error)
    use cubeadm_subcube_types
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(fullcube2fullcube_prog_t), intent(inout) :: prog
    type(subcube_t),                 intent(inout) :: insub
    type(subcube_t),                 intent(inout) :: ousub
    logical,                         intent(inout) :: error
    !
    integer(kind=indx_k) :: ix,iy,iz
    character(len=*), parameter :: rname='FULLCUBE2FULLCUBE>PROG>ACT'
    !
    do iz=1,insub%nz
       do iy=1,insub%ny
          do ix=1,insub%nx
             ousub%val(ix,iy,iz) = prog%factor%val*insub%val(ix,iy,iz)
          enddo ! ix
       enddo ! iy
    enddo ! iz
  end subroutine cubetemplate_fullcube2fullcube_prog_act
end module cubetemplate_fullcube2fullcube
!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
