subroutine clean_beam (line,error)
  use gkernel_interfaces
  use clean_def
  use clean_arrays
  use gbl_message
  character(len=*) line
  logical error
  integer jplane
  character(len=message_length) :: chain
  character(len=3) :: rname = 'FIT'
  !
  if (hbeam%loca%size.eq.0) then
    call map_message(seve%e,rname,'No Dirty Beam')
    error = .true.
    return
  endif
  jplane = method%iplane
  call sic_i4 (line,0,1,jplane,.false.,error)
  if (error) return
  jplane = min(hbeam%gil%dim(4),max(1,jplane))
  if (hbeam%gil%dim(4).gt.1) then
    write(chain,'(A,I4,A,I4)') 'Fitting beam # ',jplane,' /',hbeam%gil%dim(4)
    call map_message(seve%i,rname,chain)
  endif
  method%major = 0.0
  method%minor = 0.0
  method%angle = 0.0
  method%thresh = 0.30
  call sic_get_real('THRESHOLD',method%thresh,error)
  !
  call get_clean (method, hbeam, dbeam(:,:,1,jplane),error)
end subroutine clean_beam
!
subroutine new_dirty_beam
  use gkernel_interfaces
  use clean_def
  use clean_arrays
  !
  ! needed when a new dirty map is computed by command uv_map:
  logical :: error
  error = .false.
  !
  if (allocated(dclean)) deallocate(dclean)
  call sic_delvariable ('CLEAN',.false.,error)
  hclean%loca%size = 0
  !
  if (allocated(dresid)) deallocate(dresid)
  call sic_delvariable ('RESIDUAL',.false.,error)
  hresid%loca%size = 0
  !
  if (allocated(dcct)) deallocate(dcct)
  call sic_delvariable ('CCT',.false.,error)
  hcct%loca%size = 0
  !
  if (allocated(dsky)) deallocate(dsky)
  call sic_delvariable ('SKY',.false.,error)
  hsky%loca%size = 0
end subroutine new_dirty_beam
