! include 'lib/util_modules.f90'
!
program mx
  use gildas_def
  use gkernel_interfaces
  use mapping_interfaces
  use image_def
  !---------------------------------------------------------------------
  ! GILDAS: 	UVMAP + CLEAN in a single step
  !
  ! Input:
  !	a UV table		'UV_TABLE'.UVT		Slot X
  ! 	several parameters
  ! Output:
  !	a residual UV table	'UV_TABLE'.UVT-MX	    Hu
  !	a residual data cube	'MAP-NAME'.LMV-RES	Hr
  !	a clean data cube	'MAP-NAME'.LMV-MX	      Hc
  !	a dirty beam		'MAP-NAME'.BEAM		Virtual Hb
  !	a clean component table	'MAP-NAME'.LMV-CCT	Hcct
  !
  ! All planes are processed together
  !---------------------------------------------------------------------
  ! Local 
  type(gildas) :: hu,hb,hr,hc,hcct
  ! 
  integer :: sblock, ier
  logical :: error
  !
  real, allocatable :: grid(:,:), xcoor(:), ycoor(:)
  real, allocatable :: work(:)
  integer :: nx,ny
  real :: cpu0, cpu1, rms
  character(len=80) :: chain
  call gagout('I-MX, Version 2.2  1-Feb-2014')
  !
  ! Read command file
  call mx_get_parameters(nx,ny)
  !
  call gagout('I-MX,  Producing a single beam for all channels')
  !
  ! Compute maximum number of plane map at once
  call gag_cpu(cpu0)
  sblock = max(64*64*64/(nx*ny),4) 
  write(chain,'(A,I4,A)') 'I-MX,  Blocking factor = ',sblock,   &
      & ' planes'
  call gagout(chain)
  allocate (grid(nx,ny), xcoor(nx), ycoor(ny), work(2*max(nx,ny)), &
      & stat=ier)
  call mx_uvmap (hu, hb, hr, grid, xcoor, ycoor, work,   &
      &    sblock, cpu0, rms)
  call gdf_write_data (hb, hb%r2d, error)
  !
  call gag_cpu(cpu1)
  write(chain,'(A,F11.2)') 'I-MX,  Finished UV_MAP at ',cpu1-cpu0
  call gagout(chain)
  !
  ! Define clean beam
  call mx_fit_beam (hb,error)
  if (error) then
    call sysexi (fatale)
  endif
  !
  ! Open input maps for cleaning
  call mx_open_clean (hr,hc,hcct,rms,error)
  if (error) goto 99
  !
  ! Perform the cleaning
  call mx_local_clean (hu,hb,hr,hc,hcct,grid, xcoor, ycoor, work, &
  & sblock, cpu0)
  !
  ! Free all images
  call gdf_write_data (hu, hu%r2d, error)
  call gdf_write_data (hc, hc%r3d, error)
  call gdf_write_data (hcct, hcct%r3d, error)
  call gdf_write_data (hr, hr%r3d, error)
  stop 'I-MX,  Normal successful completion'
  !
  99    call sysexi(fatale)
  !
!  contains
!  !
!  include 'lib/clean_mx.f90'
!  include 'lib/cycle_mx.f90'
!  include 'lib/read_mx.f90'
!  include 'lib/map_mx.f90'
!  include 'lib/sort_mx.f90'
end program mx
