!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
module cubeadm_import
  use cubetools_structure
  use cubedag_parameters
  use cubedag_link_type
  use cubedag_node_type
  use cubedag_node
  use cubedag_dag
  use cubeadm_messaging
  use cubeadm_directory_type
  !
  type(cubedag_link_t) :: im  ! List of imported cubes
  !
  public :: cubeadm_import_command,cubeadm_import_register,cubeadm_head_to_node
  private
  !
  type :: import_comm_t
     type(option_t), pointer :: import
     type(option_t), pointer :: mapping
     type(option_t), pointer :: class
  end type import_comm_t
  type(import_comm_t) :: comm
  !
  type import_user_t
     logical :: domapping = .false.
     logical :: doclass   = .false.
  end type import_user_t
  type(import_user_t) :: user
  !
contains
  !
  subroutine cubeadm_import_register(error)
    !---------------------------------------------------------------------
    ! 
    !---------------------------------------------------------------------
    logical, intent(inout) :: error
    !
    type(standard_arg_t) :: stdarg
    character(len=*), parameter :: comm_abstract = &
         'Import files into the DAG'
    character(len=*), parameter :: comm_help = &
         'With a file pattern as argument (e.g. raw/*{.lmv|.fits}),&
         & import files using this pattern (pattern is assumed&
         & relative from current directory, if relevant).'&
         & //strg_cr//strg_cr//&
         &'With a&
         & directory name as argument, import all files (*.*, only&
         & Gildas Data Format or FITS format files are imported) from&
         & this directory (no recursion).'&
         & //strg_cr//strg_cr//&
         & 'Without argument, import files from the RAW directory.'
    character(len=*), parameter :: rname='IMPORT>REGISTER'
    !
    call cubeadm_message(admseve%trace,rname,'Welcome')
    !
    call cubetools_register_command(&
         'IMPORT','[Directory|FilePattern]',&
         comm_abstract,&
         comm_help,&
         cubeadm_import_command,&
         comm%import,error)
    if (error) return
    call stdarg%register( &
         'Target',  &
         'Import target, a directory or a File Pattern', &
         strg_id,&
         code_arg_optional, &
         error)
    if (error) return
    !
    call cubetools_register_option(&
         'MAPPING','',&
         'Import MAPPING files with flags based on extension',&
         strg_id,&
         comm%mapping,error)
    if (error) return
    !
    call cubetools_register_option(&
         'CLASS','',&
         'Import CLASS files with flags based on extension',&
         strg_id,&
         comm%class,error)
    if (error) return
  end subroutine cubeadm_import_register
  !
  subroutine cubeadm_import_command(line,error)
    use cubedag_find
    use cubedag_history
    use cubeadm_setup
    use gkernel_interfaces
    !---------------------------------------------------------------------
    ! Support routine for command:
    !   IMPORT
    !   IMPORT Directory
    !   IMPORT Pattern
    !---------------------------------------------------------------------
    character(len=*), intent(in)    :: line
    logical,          intent(inout) :: error
    !
    character(len=file_l) :: argum
    integer(kind=4) :: nc
    type(cubedag_find_t) :: criter
    logical :: do_cx
    type(cubedag_link_t) :: void
    integer(kind=entr_k) :: hid
    character(len=*), parameter :: rname='IMPORT>COMMAND'
    !
    if (comm%import%getnarg().ge.1) then
      call cubetools_getarg(line,comm%import,1,argum,.not.mandatory,error)
      if (error) return
    else
      argum = dir%raw
    endif
    !
    call comm%mapping%present(line,user%domapping,error)
    if (error) return
    call comm%class%present(line,user%doclass,error)
    if (error) return
    !
    if (user%domapping.and.user%doclass) then
       call cubeadm_message(seve%e,rname,'Options /MAPPING and /CLASS conflict with each other')
       error = .true.
       return
    endif
    !
    nc = len_trim(argum)
    if (gag_isdir(argum(1:nc)).eq.0) then
       do_cx = cubset%index%default.eq.code_index_current
       call cubeadm_import_directory(argum,nc,error)
    else
       do_cx = cubset%index%default.eq.code_index_current
       call cubeadm_import_pattern(argum,error)
    endif
    if (error) return
    !
    if (do_cx) then
      ! Implicitly FIND everything in current index
      call cubedag_find_ix2cx(criter,error)
      if (error) return
    endif
    !
    ! Insert in history
    call cubedag_history_add_tohx('IMPORT',line,void,im,hid,error)
    if (error) return
    call cubedag_node_history(im,hid,error)
    if (error) return
    !
    call cubeadm_imported_reset()
    !
  end subroutine cubeadm_import_command
  !
  subroutine cubeadm_import_directory(dirname,nc,error)
    !---------------------------------------------------------------------
    ! Import *.* files from a directory into the DAG
    !---------------------------------------------------------------------
    character(len=*), intent(in)    :: dirname
    integer(kind=4),  intent(in)    :: nc
    logical,          intent(inout) :: error
    !
    character(len=*), parameter :: rname='IMPORT>DIRECTORY'
    !
    if (dirname(nc:nc).eq.'/') then
      call cubeadm_import_pattern(dirname(1:nc)//'*.*',error)
    else
      call cubeadm_import_pattern(dirname(1:nc)//'/*.*',error)
    endif
    if (error) return
  end subroutine cubeadm_import_directory
  !
  recursive subroutine cubeadm_import_pattern(pattern,error)
    use gkernel_types
    use gkernel_interfaces
    !---------------------------------------------------------------------
    ! Import files given a pattern into the DAG
    !---------------------------------------------------------------------
    character(len=*), intent(in)    :: pattern
    logical,          intent(inout) :: error
    !
    integer(kind=4) :: nfile,ifile,filekind,nimported,nskipped,nc,myseve
    logical :: skipped
    character(len=file_l), allocatable :: filelist(:)
    character(len=mess_l) :: mess
    type(time_t) :: time
    character(len=*), parameter :: rname='IMPORT>PATTERN'
    !
    ! Get the file names
    call gag_directory('.',trim(pattern),filelist,nfile,error)
    if (error) return
    !
    call gtime_init(time,nfile,error)
    if (error) return
    !
    ! Import the GDF and FITS files in the DAG
    nimported = 0
    nskipped = 0
    do ifile=1,nfile
      call gtime_current(time)
      nc = len_trim(filelist(ifile))
      if (gag_isdir(filelist(ifile)(1:nc)).eq.0) then
        ! This is a directory. NB: this is not precisely a recursion
        ! as cubeadm_import_directory imports "somedir/*.*"
        call cubeadm_import_directory(filelist(ifile),nc,error)
        if (error) error = .false.  ! Skip errors indexing file
      else
        ! This is not a directory (regular file...)
        call gag_file_guess(rname,filelist(ifile),filekind,error)
        if (error) error = .false.  ! Skip errors indexing file
        if (filekind.eq.1 .or. filekind.eq.2) then
          call cubeadm_import_onefile(filelist(ifile),skipped,error)
          if (error) exit
          if (skipped) then
            nskipped = nskipped+1
          else
            nimported = nimported+1
          endif
        endif
      endif
    enddo
    deallocate(filelist)
    !
    write(mess,'(I0,A,A)')  nimported,' new file(s) imported from ',trim(pattern)
    if (nimported.le.0) then
      myseve = seve%w
    else
      myseve = seve%r
    endif
    if (nskipped.gt.0) then
      write(mess,'(A,A,I0,A)')  &
        trim(mess),', skipped ',nskipped,' duplicate file(s)'
    endif
    call cubeadm_message(myseve,rname,mess)
  end subroutine cubeadm_import_pattern
  !
  subroutine cubeadm_import_onefile(filename,skipped,error)
    use gkernel_interfaces
    use cube_types
    use cubedag_allflags
    use cubedag_tuple
    use cubeio_file
    use cubetuple_format
    use cubetuple_uv
    use cubeadm_engine_types
    use cubeadm_cubeid_types
    use cubeadm_setup
    !---------------------------------------------------------------------
    !
    !---------------------------------------------------------------------
    character(len=*), intent(in)    :: filename
    logical,          intent(out)   :: skipped
    logical,          intent(inout) :: error
    !
    character(len=base_l) :: filebase,cubeid
    type(flag_t), allocatable :: flags(:)
    character(len=exte_l) :: fileext
    integer(kind=4) :: ier
    integer(kind=code_k) :: code_ftype
    type(cubeio_file_t), pointer :: file
    class(format_t), pointer :: fo
    class(cubedag_node_object_t), pointer :: dno
    character(len=*), parameter :: rname='IMPORT>ONEFILE'
    !
    skipped = .true.
    if (cubedag_dag_contains(filename))  return
    !
    call sic_parse_name(filename,filebase,fileext)
    if (user%domapping) then
       call cubedag_mapping_ext2flag(fileext,flags,error)
       if (error) return
    else if (user%doclass) then
       call cubedag_class_ext2flag(fileext,flags,error)
       if (error) return
    else
       ! No special flags
    endif
    if (.not.allocated(flags)) then
      allocate(flags(1),stat=ier)
      if (failed_allocate(rname,'flags',ier,error)) return
      flags(:) = [flag_cube]
    endif
    call cubeadm_cubeid_familyflags2string(filebase,flags,cubeid,error)
    if (error) return
    !
    file => file_allocate_new(error)
    if (error) return
    call file%read_header(filename,cubeid,error)
    if (error) return
    !
    if (file%is_cube()) then
      code_ftype = code_ftype_cube
      fo => cube_allocate_new(cubset,error)
      if (error) return
    elseif (file%is_uvt()) then
      code_ftype = code_ftype_uv
      fo => uv_allocate_new(cubset,error)
      if (error) return
    else
      ! Clean before skipping
      call file%close(error)
      call file%free(error)
      deallocate(file)
      return
    endif
    call fo%attach_file(file,error)
    if (error) return
    !
    ! Attach a new cube to the DAG and set its attributes
    dno => fo
    call cubedag_dag_newbranch(dno,code_ftype,error)
    if (error) return
    call cubedag_node_set_origin(dno,code_origin_imported,error)
    if (error) return
    call cubedag_node_set_family(dno,filebase,error)
    if (error) return
    call cubedag_node_set_flags(dno,flags,error)
    if (error) return
    call cubeadm_head_to_node(fo%head,fo,error)
    if (error) return
    call cubedag_tuple_upsert(fo%node%tuple,fo%order(),code_buffer_disk,filename,error)
    if (error) return
    !
    ! Need some cleaning. At least the GIO slots. We could go through
    ! the cubeadm_finish_all at the end of the command execution, but
    ! IMPORT can open hundreds of cubes, and GIO slots are more limited
    ! than this. We have to avoid accumulating them:
    call file%close(error)
    if (error) return
    !
    call cubeadm_imported_add(dno)
    !
    skipped = .false.
    !
  end subroutine cubeadm_import_onefile
  !
  subroutine cubeadm_head_to_node(head,object,error)
    use cubetools_header_types
    use cubedag_node
    !---------------------------------------------------------------------
    ! Transfer the header to the DAG node
    !---------------------------------------------------------------------
    type(cube_header_t),          intent(in)    :: head
    class(cubedag_node_object_t), intent(inout) :: object
    logical,                      intent(inout) :: error
    !
    call cubedag_node_set_header(object,head,error)
    if (error) return
  end subroutine cubeadm_head_to_node
  !
  subroutine cubeadm_imported_add(dno)
    class(cubedag_node_object_t), pointer :: dno
    logical :: error
    error = .false.
    call im%reallocate(im%n+1,error)
    im%n = im%n+1
    im%list(im%n)%p => dno
    im%flag(im%n) = 0
  end subroutine cubeadm_imported_add
  !
  subroutine cubeadm_imported_reset()
    logical :: error
    error = .false.
    call im%final(error)
  end subroutine cubeadm_imported_reset
  !
end module cubeadm_import
!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
