subroutine gr8_trie_i4(x,it,n,error)
  use gbl_message
  use gmath_interfaces, except_this=>gr8_trie_i4
  !---------------------------------------------------------------------
  ! @ public-generic gr8_trie
  !  Sorting program that uses a quicksort algorithm.
  ! Applies for an input array of real*8 values. Also returns an array
  ! of indexes sorted for increasing order of X which can used in
  ! GR8_SORT to reorder other arrays
  ! ---
  !  This version for I*4 indices
  !---------------------------------------------------------------------
  integer(kind=4), intent(in)    :: n      ! Length of arrays
  real(kind=8),    intent(inout) :: x(n)   ! Unsorted array
  integer(kind=4), intent(out)   :: it(n)  ! Integer array of sorted indexes
  logical,         intent(out)   :: error  ! Error flag
  ! Local
  integer(kind=4), parameter :: maxstack=1000,nstop=15
  integer(kind=4) :: i,j,k,itemp
  integer(kind=4) :: l,r,m,lstack(maxstack),rstack(maxstack),sp
  real(kind=8) :: temp,key
  logical :: mgtl,lgtr,rgtm
  !
  error = .false.
  !
  ! Load initial pointers, and check for NaNs
  do i = 1,n
    if (x(i).eq.x(i))then
      it(i) = i
    else
      call gmath_message(seve%e,'QSORT','Array contains NaNQ(s)!')
      error = .true.
      return
    endif
  enddo
  !
  if (n.le.nstop) goto 50
  sp = 0
  sp = sp + 1
  lstack(sp) = 1
  rstack(sp) = n
  !
  ! Sort a subrecord off the stack
  ! Set KEY = median of X(L), X(M), X(R)
  ! No! This is not reasonable, as systematic very inequal partitioning will
  ! occur in some cases (especially for nearly already sorted files)
  ! To fix this problem, I found (but I cannot prove it) that it is best to
  ! select the estimation of the median value from intermediate records. P.V.
1 l = lstack(sp)
  r = rstack(sp)
  sp = sp - 1
  m = (l + r) / 2
  !
  !      L1=(2*L+R)/3  and      R1=(L+2*R)/3
  !
  mgtl = x(m) .gt. x(l)
  rgtm = x(r) .gt. x(m)
  !
  ! Algorithm to select the median key. The original one from MONGO
  ! was completely wrong. P. Valiron, 24-Jan-84 .
  !
  !                       MGTL    RGTM    LGTR    MGTL.EQV.LGTR   MEDIAN_KEY
  !
  !       KL < KM < KR    T       T       *       *               KM
  !       KL > KM > KR    F       F       *       *               KM
  !
  !       KL < KM > KR    T       F       F       F               KR
  !       KL < KM > KR    T       F       T       T               KL
  !
  !       KL > KM < KR    F       T       F       T               KL
  !       KL > KM < KR    F       T       T       F               KR
  !
  if (mgtl .eqv. rgtm) then
    key = x(m)
  else
    lgtr = x(l) .gt. x(r)
    if (mgtl .eqv. lgtr) then
      key = x(l)
    else
      key = x(r)
    endif
  endif
  i = l
  j = r
  !
  ! Find a big record on the left
10 if (x(i).ge.key) goto 11
  i = i + 1
  goto 10
11 continue
  ! Find a small record on the right
20 if (x(j).le.key) goto 21
  j = j - 1
  goto 20
21 continue
  if (i.ge.j) goto 2
  !
  ! Exchange records
  temp = x(i)
  x(i) = x(j)
  x(j) = temp
  itemp = it(i)
  it(i) = it(j)
  it(j) = itemp
  i = i + 1
  j = j - 1
  goto 10
  !
  ! Subfile is partitioned into two halves, left .le. right
  ! Push the two halves on the stack
2 continue
  if (j-l+1 .gt. nstop) then
    sp = sp + 1
    if (sp.gt.maxstack) then
      call gmath_message(seve%e,'SORT','Stack overflow ')
      error = .true.
      return
    endif
    lstack(sp) = l
    rstack(sp) = j
  endif
  if (r-j .gt. nstop) then
    sp = sp + 1
    if (sp.gt.maxstack) then
      call gmath_message(seve%e,'SORT','Stack overflow ')
      error = .true.
      return
    endif
    lstack(sp) = j+1
    rstack(sp) = r
  endif
  !
  ! Anything left to process?
  if (sp.gt.0) goto 1
  !
50 continue
  !
  do j=n-1,1,-1
    k = j
    do i=j+1,n
      if (x(j).le.x(i)) exit   ! I
      k = i
    enddo
    if (k.eq.j) cycle          ! J
    temp = x(j)
    do i = j+1,k
      x(i-1) = x(i)
    enddo
    x(k) = temp
    itemp = it(j)
    do i = j+1,k
      it(i-1) = it(i)
    enddo
    it(k) = itemp
  enddo                        ! J
end subroutine gr8_trie_i4
!
subroutine gr8_trie_i8(x,it,n,error)
  use gbl_message
  use gmath_interfaces, except_this=>gr8_trie_i8
  !---------------------------------------------------------------------
  ! @ public-generic gr8_trie
  !  Sorting program that uses a quicksort algorithm.
  ! Applies for an input array of real*8 values. Also returns an array
  ! of indexes sorted for increasing order of X which can used in
  ! GR8_SORT to reorder other arrays
  ! ---
  !  This version for I*8 indices
  !  All lines of codes duplicated from I*4 version, only variable
  !  declarations differ.
  !---------------------------------------------------------------------
  integer(kind=8), intent(in)    :: n      ! Length of arrays
  real(kind=8),    intent(inout) :: x(n)   ! Unsorted array
  integer(kind=8), intent(out)   :: it(n)  ! Integer array of sorted indexes
  logical,         intent(out)   :: error  ! Error flag
  ! Local
  integer(kind=8), parameter :: maxstack=1000,nstop=15
  integer(kind=8) :: i,j,k,itemp
  integer(kind=8) :: l,r,m,lstack(maxstack),rstack(maxstack),sp
  real(kind=8) :: temp,key
  logical :: mgtl,lgtr,rgtm
  !
  error = .false.
  !
  ! Load initial pointers, and check for NaNs
  do i = 1,n
    if (x(i).eq.x(i))then
      it(i) = i
    else
      call gmath_message(seve%e,'QSORT','Array contains NaNQ(s)!')
      error = .true.
      return
    endif
  enddo
  !
  if (n.le.nstop) goto 50
  sp = 0
  sp = sp + 1
  lstack(sp) = 1
  rstack(sp) = n
  !
  ! Sort a subrecord off the stack
  ! Set KEY = median of X(L), X(M), X(R)
  ! No! This is not reasonable, as systematic very inequal partitioning will
  ! occur in some cases (especially for nearly already sorted files)
  ! To fix this problem, I found (but I cannot prove it) that it is best to
  ! select the estimation of the median value from intermediate records. P.V.
1 l = lstack(sp)
  r = rstack(sp)
  sp = sp - 1
  m = (l + r) / 2
  !
  !      L1=(2*L+R)/3  and      R1=(L+2*R)/3
  !
  mgtl = x(m) .gt. x(l)
  rgtm = x(r) .gt. x(m)
  !
  ! Algorithm to select the median key. The original one from MONGO
  ! was completely wrong. P. Valiron, 24-Jan-84 .
  !
  !                       MGTL    RGTM    LGTR    MGTL.EQV.LGTR   MEDIAN_KEY
  !
  !       KL < KM < KR    T       T       *       *               KM
  !       KL > KM > KR    F       F       *       *               KM
  !
  !       KL < KM > KR    T       F       F       F               KR
  !       KL < KM > KR    T       F       T       T               KL
  !
  !       KL > KM < KR    F       T       F       T               KL
  !       KL > KM < KR    F       T       T       F               KR
  !
  if (mgtl .eqv. rgtm) then
    key = x(m)
  else
    lgtr = x(l) .gt. x(r)
    if (mgtl .eqv. lgtr) then
      key = x(l)
    else
      key = x(r)
    endif
  endif
  i = l
  j = r
  !
  ! Find a big record on the left
10 if (x(i).ge.key) goto 11
  i = i + 1
  goto 10
11 continue
  ! Find a small record on the right
20 if (x(j).le.key) goto 21
  j = j - 1
  goto 20
21 continue
  if (i.ge.j) goto 2
  !
  ! Exchange records
  temp = x(i)
  x(i) = x(j)
  x(j) = temp
  itemp = it(i)
  it(i) = it(j)
  it(j) = itemp
  i = i + 1
  j = j - 1
  goto 10
  !
  ! Subfile is partitioned into two halves, left .le. right
  ! Push the two halves on the stack
2 continue
  if (j-l+1 .gt. nstop) then
    sp = sp + 1
    if (sp.gt.maxstack) then
      call gmath_message(seve%e,'SORT','Stack overflow ')
      error = .true.
      return
    endif
    lstack(sp) = l
    rstack(sp) = j
  endif
  if (r-j .gt. nstop) then
    sp = sp + 1
    if (sp.gt.maxstack) then
      call gmath_message(seve%e,'SORT','Stack overflow ')
      error = .true.
      return
    endif
    lstack(sp) = j+1
    rstack(sp) = r
  endif
  !
  ! Anything left to process?
  if (sp.gt.0) goto 1
  !
50 continue
  !
  do j=n-1,1,-1
    k = j
    do i=j+1,n
      if (x(j).le.x(i)) exit   ! I
      k = i
    enddo
    if (k.eq.j) cycle          ! J
    temp = x(j)
    do i = j+1,k
      x(i-1) = x(i)
    enddo
    x(k) = temp
    itemp = it(j)
    do i = j+1,k
      it(i-1) = it(i)
    enddo
    it(k) = itemp
  enddo                        ! J
end subroutine gr8_trie_i8
!
subroutine gr8_sort(x,xwork,key,n)
  use gmath_interfaces, except_this=>gr8_sort
  !---------------------------------------------------------------------
  ! @ public-mandatory (because symbol is used elsewhere)
  !  Reorder a real*8 array by increasing order using the sorted indexes
  ! computed by a G*_TRIE subroutine
  !---------------------------------------------------------------------
  integer(kind=4), intent(in)    :: n         ! Length of arrays
  real(kind=8),    intent(inout) :: x(n)      ! Unsorted array
  real(kind=8)                   :: xwork(n)  ! Working buffer
  integer(kind=4), intent(in)    :: key(n)    ! Integer array of sorted indexes
  ! Local
  integer(kind=4) :: i
  !
  if (n.le.1) return
  do i=1,n
    xwork(i) = x(key(i))
  enddo
  do i=1,n
    x(i) = xwork(i)
  enddo
end subroutine gr8_sort
!
subroutine gr4_trie_i4(x,it,n,error)
  use gbl_message
  use gmath_interfaces, except_this=>gr4_trie_i4
  !---------------------------------------------------------------------
  ! @ public-generic gr4_trie
  !  Sorting program that uses a quicksort algorithm.
  !  Applies for an input array of real*4 values. Also returns an array
  ! of indexes sorted for increasing order of X which can used in
  ! GR4_SORT to reorder other arrays
  ! ---
  !  This version for I*4 indices
  !---------------------------------------------------------------------
  integer(kind=4), intent(in)    :: n      !
  real(kind=4),    intent(inout) :: x(n)   !
  integer(kind=4), intent(out)   :: it(n)  !
  logical,         intent(out)   :: error  !
  ! Local
  integer(kind=4), parameter :: maxstack=1000,nstop=15
  integer(kind=4) :: i,j,k,itemp,l,r,m
  integer(kind=4) :: lstack(maxstack),rstack(maxstack),sp
  real(kind=4) :: temp,key
  logical :: mgtl,lgtr,rgtm
  character(len=message_length) :: mess
  !
  error = .false.
  !
  ! Load initial pointers
  do i = 1,n
    if (x(i).eq.x(i))then
      it(i) = i
    else
      call gmath_message(seve%e,'QSORT','Array contains NaNQ(s)!')
      error = .true.
      return
    endif
  enddo
  !
  if (n.le.nstop) goto 50
  sp = 0
  sp = sp + 1
  lstack(sp) = 1
  rstack(sp) = n
  !
  ! Sort a subrecord off the stack
  ! Set KEY = median of X(L), X(M), X(R)
  ! No! This is not reasonable, as systematic very inequal partitioning will
  ! occur in some cases (especially for nearly already sorted files)
  ! To fix this problem, I found (but I cannot prove it) that it is best to
  ! select the estimation of the median value from intermediate records. P.V.
1 l = lstack(sp)
  r = rstack(sp)
  sp = sp - 1
  m = (l + r) / 2
  !
  !      L1=(2*L+R)/3  and      R1=(L+2*R)/3
  !
  mgtl = x(m) .gt. x(l)
  rgtm = x(r) .gt. x(m)
  !
  ! Algorithm to select the median key. The original one from MONGO
  ! was completely wrong. P. Valiron, 24-Jan-84 .
  !
  !                       MGTL    RGTM    LGTR    MGTL.EQV.LGTR   MEDIAN_KEY
  !
  !       KL < KM < KR    T       T       *       *               KM
  !       KL > KM > KR    F       F       *       *               KM
  !
  !       KL < KM > KR    T       F       F       F               KR
  !       KL < KM > KR    T       F       T       T               KL
  !
  !       KL > KM < KR    F       T       F       T               KL
  !       KL > KM < KR    F       T       T       F               KR
  !
  if (mgtl .eqv. rgtm) then
    key = x(m)
  else
    lgtr = x(l) .gt. x(r)
    if (mgtl .eqv. lgtr) then
      key = x(l)
    else
      key = x(r)
    endif
  endif
  i = l
  j = r
  !
  ! Find a big record on the left
10 if (x(i).ge.key) goto 11
  i = i + 1
  goto 10
11 continue
  ! Find a small record on the right
20 if (x(j).le.key) goto 21
  j = j - 1
  goto 20
21 continue
  if (i.ge.j) goto 2
  !
  ! Exchange records
  temp = x(i)
  x(i) = x(j)
  x(j) = temp
  itemp = it(i)
  it(i) = it(j)
  it(j) = itemp
  i = i + 1
  j = j - 1
  goto 10
  !
  ! Subfile is partitioned into two halves, left .le. right
  ! Push the two halves on the stack
2 continue
  if (j-l+1 .gt. nstop) then
    sp = sp + 1
    if (sp.gt.maxstack) then
      write(mess,*) 'Stack overflow ',sp
      call gmath_message(seve%e,'SORT',mess)
      error = .true.
      return
    endif
    lstack(sp) = l
    rstack(sp) = j
  endif
  if (r-j .gt. nstop) then
    sp = sp + 1
    if (sp.gt.maxstack) then
      write(mess,*) 'Stack overflow ',sp
      call gmath_message(seve%e,'SORT',mess)
      error = .true.
      return
    endif
    lstack(sp) = j+1
    rstack(sp) = r
  endif
  !
  ! Anything left to process?
  if (sp.gt.0) goto 1
  !
50 continue
  !
  do j=n-1,1,-1
    k = j
    do i=j+1,n
      if (x(j).le.x(i)) exit   ! I
      k = i
    enddo
    if (k.eq.j) cycle          ! J
    temp = x(j)
    do i = j+1,k
      x(i-1) = x(i)
    enddo
    x(k) = temp
    itemp = it(j)
    do i = j+1,k
      it(i-1) = it(i)
    enddo
    it(k) = itemp
  enddo                        ! J
  return
end subroutine gr4_trie_i4
!
subroutine gr4_trie_i8(x,it,n,error)
  use gbl_message
  use gmath_interfaces, except_this=>gr4_trie_i8
  !---------------------------------------------------------------------
  ! @ public-generic gr4_trie
  !  Sorting program that uses a quicksort algorithm.
  !  Applies for an input array of real*4 values. Also returns an array
  ! of indexes sorted for increasing order of X which can used in
  ! GR4_SORT to reorder other arrays
  ! ---
  !  This version for I*8 indices
  !---------------------------------------------------------------------
  integer(kind=8), intent(in)    :: n      !
  real(kind=4),    intent(inout) :: x(n)   !
  integer(kind=8), intent(out)   :: it(n)  !
  logical,         intent(out)   :: error  !
  ! Local
  integer(kind=4), parameter :: maxstack=1000,nstop=15
  integer(kind=4) :: i,j,k,itemp,l,r,m
  integer(kind=4) :: lstack(maxstack),rstack(maxstack),sp
  real(kind=4) :: temp,key
  logical :: mgtl,lgtr,rgtm
  character(len=message_length) :: mess
  !
  error = .false.
  !
  ! Load initial pointers
  do i = 1,n
    if (x(i).eq.x(i))then
      it(i) = i
    else
      call gmath_message(seve%e,'QSORT','Array contains NaNQ(s)!')
      error = .true.
      return
    endif
  enddo
  !
  if (n.le.nstop) goto 50
  sp = 0
  sp = sp + 1
  lstack(sp) = 1
  rstack(sp) = n
  !
  ! Sort a subrecord off the stack
  ! Set KEY = median of X(L), X(M), X(R)
  ! No! This is not reasonable, as systematic very inequal partitioning will
  ! occur in some cases (especially for nearly already sorted files)
  ! To fix this problem, I found (but I cannot prove it) that it is best to
  ! select the estimation of the median value from intermediate records. P.V.
1 l = lstack(sp)
  r = rstack(sp)
  sp = sp - 1
  m = (l + r) / 2
  !
  !      L1=(2*L+R)/3  and      R1=(L+2*R)/3
  !
  mgtl = x(m) .gt. x(l)
  rgtm = x(r) .gt. x(m)
  !
  ! Algorithm to select the median key. The original one from MONGO
  ! was completely wrong. P. Valiron, 24-Jan-84 .
  !
  !                       MGTL    RGTM    LGTR    MGTL.EQV.LGTR   MEDIAN_KEY
  !
  !       KL < KM < KR    T       T       *       *               KM
  !       KL > KM > KR    F       F       *       *               KM
  !
  !       KL < KM > KR    T       F       F       F               KR
  !       KL < KM > KR    T       F       T       T               KL
  !
  !       KL > KM < KR    F       T       F       T               KL
  !       KL > KM < KR    F       T       T       F               KR
  !
  if (mgtl .eqv. rgtm) then
    key = x(m)
  else
    lgtr = x(l) .gt. x(r)
    if (mgtl .eqv. lgtr) then
      key = x(l)
    else
      key = x(r)
    endif
  endif
  i = l
  j = r
  !
  ! Find a big record on the left
10 if (x(i).ge.key) goto 11
  i = i + 1
  goto 10
11 continue
  ! Find a small record on the right
20 if (x(j).le.key) goto 21
  j = j - 1
  goto 20
21 continue
  if (i.ge.j) goto 2
  !
  ! Exchange records
  temp = x(i)
  x(i) = x(j)
  x(j) = temp
  itemp = it(i)
  it(i) = it(j)
  it(j) = itemp
  i = i + 1
  j = j - 1
  goto 10
  !
  ! Subfile is partitioned into two halves, left .le. right
  ! Push the two halves on the stack
2 continue
  if (j-l+1 .gt. nstop) then
    sp = sp + 1
    if (sp.gt.maxstack) then
      write(mess,*) 'Stack overflow ',sp
      call gmath_message(seve%e,'SORT',mess)
      error = .true.
      return
    endif
    lstack(sp) = l
    rstack(sp) = j
  endif
  if (r-j .gt. nstop) then
    sp = sp + 1
    if (sp.gt.maxstack) then
      write(mess,*) 'Stack overflow ',sp
      call gmath_message(seve%e,'SORT',mess)
      error = .true.
      return
    endif
    lstack(sp) = j+1
    rstack(sp) = r
  endif
  !
  ! Anything left to process?
  if (sp.gt.0) goto 1
  !
50 continue
  !
  do j=n-1,1,-1
    k = j
    do i=j+1,n
      if (x(j).le.x(i)) exit   ! I
      k = i
    enddo
    if (k.eq.j) cycle          ! J
    temp = x(j)
    do i = j+1,k
      x(i-1) = x(i)
    enddo
    x(k) = temp
    itemp = it(j)
    do i = j+1,k
      it(i-1) = it(i)
    enddo
    it(k) = itemp
  enddo                        ! J
  return
end subroutine gr4_trie_i8
!
subroutine gr4_sort(x,xwork,key,n)
  use gmath_interfaces, except_this=>gr4_sort
  !---------------------------------------------------------------------
  ! @ public-mandatory (because symbol is used elsewhere)
  !  Reorder a real*4 array by increasing order using the sorted indexes
  ! computed by a G*_TRIE subroutine
  !---------------------------------------------------------------------
  integer(kind=4), intent(in)    :: n         !
  real(kind=4),    intent(inout) :: x(n)      !
  real(kind=4)                   :: xwork(n)  ! Working buffer
  integer(kind=4), intent(in)    :: key(n)    !
  ! Local
  integer(kind=4) :: i
  !
  if (n.le.1) return
  do i=1,n
    xwork(i) = x(key(i))
  enddo
  do i=1,n
    x(i) = xwork(i)
  enddo
end subroutine gr4_sort
!
subroutine gi4_trie(x,it,n,error)
  use gbl_message
  use gmath_interfaces, except_this=>gi4_trie
  !---------------------------------------------------------------------
  ! @ public-mandatory (because symbol is used elsewhere)
  !  Sorting program that uses a quicksort algorithm.
  !  Applies for an input array of integer*4 values. Also returns an
  ! array of indexes sorted for increasing order of X which can used in
  ! GI4_SORT to reorder other arrays
  !---------------------------------------------------------------------
  integer(kind=4), intent(in)    :: n      ! Length of arrays
  integer(kind=4), intent(inout) :: x(n)   ! Unsorted array
  integer(kind=4), intent(out)   :: it(n)  ! Integer array of sorted indexes
  logical,         intent(out)   :: error  ! Error flag
  ! Local
  integer(kind=4), parameter :: maxstack=1000,nstop=15
  integer(kind=4) :: i,j,k,itemp,l,r,m
  integer(kind=4) :: lstack(maxstack),rstack(maxstack),sp
  integer(kind=4) :: temp,key
  logical :: mgtl,lgtr,rgtm
  character(len=message_length) :: mess
  !
  error = .false.
  !
  ! Load initial pointers
  do i = 1,n
    it(i) = i
  enddo
  !
  if (n.le.nstop) goto 50
  sp = 0
  sp = sp + 1
  lstack(sp) = 1
  rstack(sp) = n
  !
  ! Sort a subrecord off the stack
  ! Set KEY = median of X(L), X(M), X(R)
  ! No! This is not reasonable, as systematic very inequal partitioning will
  ! occur in some cases (especially for nearly already sorted files)
  ! To fix this problem, I found (but I cannot prove it) that it is best to
  ! select the estimation of the median value from intermediate records. P.V.
1 l = lstack(sp)
  r = rstack(sp)
  sp = sp - 1
  m = (l + r) / 2
  !
  !      L1=(2*L+R)/3         and      R1=(L+2*R)/3
  !
  mgtl = x(m) .gt. x(l)
  rgtm = x(r) .gt. x(m)
  !
  ! Algorithm to select the median key. The original one from MONGO
  ! was completely wrong. P. Valiron, 24-Jan-84 .
  !
  !                       MGTL    RGTM    LGTR    MGTL.EQV.LGTR   MEDIAN_KEY
  !
  !       KL < KM < KR    T       T       *       *               KM
  !       KL > KM > KR    F       F       *       *               KM
  !
  !       KL < KM > KR    T       F       F       F               KR
  !       KL < KM > KR    T       F       T       T               KL
  !
  !       KL > KM < KR    F       T       F       T               KL
  !       KL > KM < KR    F       T       T       F               KR
  !
  if (mgtl .eqv. rgtm) then
    key = x(m)
  else
    lgtr = x(l) .gt. x(r)
    if (mgtl .eqv. lgtr) then
      key = x(l)
    else
      key = x(r)
    endif
  endif
  i = l
  j = r
  !
  ! Find a big record on the left
10 if (x(i).ge.key) goto 11
  i = i + 1
  goto 10
11 continue
  ! Find a small record on the right
20 if (x(j).le.key) goto 21
  j = j - 1
  goto 20
21 continue
  if (i.ge.j) goto 2
  !
  ! Exchange records
  temp = x(i)
  x(i) = x(j)
  x(j) = temp
  itemp = it(i)
  it(i) = it(j)
  it(j) = itemp
  i = i + 1
  j = j - 1
  goto 10
  !
  ! Subfile is partitioned into two halves, left .le. right
  ! Push the two halves on the stack
2 continue
  if (j-l+1 .gt. nstop) then
    sp = sp + 1
    if (sp.gt.maxstack) then
      write(mess,*) 'Stack overflow ',sp
      call gmath_message(seve%e,'SORT',mess)
      error = .true.
      return
    endif
    lstack(sp) = l
    rstack(sp) = j
  endif
  if (r-j .gt. nstop) then
    sp = sp + 1
    if (sp.gt.maxstack) then
      write(mess,*) 'Stack overflow ',sp
      call gmath_message(seve%e,'SORT',mess)
      error = .true.
      return
    endif
    lstack(sp) = j+1
    rstack(sp) = r
  endif
  !
  ! Anything left to process?
  if (sp.gt.0) goto 1
  !
50 continue
  !
  do j=n-1,1,-1
    k = j
    do i=j+1,n
      if (x(j).le.x(i)) exit   ! I
      k = i
    enddo
    if (k.eq.j) cycle          ! J
    temp = x(j)
    do i = j+1,k
      x(i-1) = x(i)
    enddo
    x(k) = temp
    itemp = it(j)
    do i = j+1,k
      it(i-1) = it(i)
    enddo
    it(k) = itemp
  enddo                        ! J
  return
end subroutine gi4_trie
!
subroutine gi4_sort(x,xwork,key,n)
  use gmath_interfaces, except_this=>gi4_sort
  !---------------------------------------------------------------------
  ! @ public-mandatory (because symbol is used elsewhere)
  !  Reorder an integer*4 array by increasing order using the sorted
  ! indexes computed by a G*_TRIE subroutine
  !---------------------------------------------------------------------
  integer(kind=4), intent(in)    :: n         ! Length of arrays
  integer(kind=4), intent(inout) :: x(n)      ! Unsorted array
  integer(kind=4)                :: xwork(n)  ! Working buffer
  integer(kind=4), intent(in)    :: key(n)    ! Integer array of sorted indexes
  ! Local
  integer(kind=4) :: i
  !
  if (n.le.1) return
  do i=1,n
    xwork(i) = x(key(i))
  enddo
  do i=1,n
    x(i) = xwork(i)
  enddo
end subroutine gi4_sort
!
subroutine gi8_trie(x,it,n,error)
  use gbl_message
  use gmath_interfaces, except_this=>gi8_trie
  !---------------------------------------------------------------------
  ! @ public-mandatory (because symbol is used elsewhere)
  !  Sorting program that uses a quicksort algorithm.
  !  Applies for an input array of integer*8 values. Also returns an
  ! array of indexes sorted for increasing order of X which can used in
  ! GI8_SORT to reorder other arrays
  !---------------------------------------------------------------------
  integer(kind=4), intent(in)    :: n      ! Length of arrays
  integer(kind=8), intent(inout) :: x(n)   ! Unsorted array
  integer(kind=4), intent(out)   :: it(n)  ! Integer array of sorted indexes
  logical,         intent(out)   :: error  ! Error flag
  ! Local
  integer(kind=4), parameter :: maxstack=1000,nstop=15
  integer(kind=4) :: i,j,k,itemp,l,r,m
  integer(kind=4) :: lstack(maxstack),rstack(maxstack),sp
  integer(kind=8) :: temp,key
  logical :: mgtl,lgtr,rgtm
  character(len=message_length) :: mess
  !
  error = .false.
  !
  ! Load initial pointers
  do i = 1,n
    it(i) = i
  enddo
  !
  if (n.le.nstop) goto 50
  sp = 0
  sp = sp + 1
  lstack(sp) = 1
  rstack(sp) = n
  !
  ! Sort a subrecord off the stack
  ! Set KEY = median of X(L), X(M), X(R)
  ! No! This is not reasonable, as systematic very inequal partitioning will
  ! occur in some cases (especially for nearly already sorted files)
  ! To fix this problem, I found (but I cannot prove it) that it is best to
  ! select the estimation of the median value from intermediate records. P.V.
1 l = lstack(sp)
  r = rstack(sp)
  sp = sp - 1
  m = (l + r) / 2
  !
  !      L1=(2*L+R)/3         and      R1=(L+2*R)/3
  !
  mgtl = x(m) .gt. x(l)
  rgtm = x(r) .gt. x(m)
  !
  ! Algorithm to select the median key. The original one from MONGO
  ! was completely wrong. P. Valiron, 24-Jan-84 .
  !
  !                       MGTL    RGTM    LGTR    MGTL.EQV.LGTR   MEDIAN_KEY
  !
  !       KL < KM < KR    T       T       *       *               KM
  !       KL > KM > KR    F       F       *       *               KM
  !
  !       KL < KM > KR    T       F       F       F               KR
  !       KL < KM > KR    T       F       T       T               KL
  !
  !       KL > KM < KR    F       T       F       T               KL
  !       KL > KM < KR    F       T       T       F               KR
  !
  if (mgtl .eqv. rgtm) then
    key = x(m)
  else
    lgtr = x(l) .gt. x(r)
    if (mgtl .eqv. lgtr) then
      key = x(l)
    else
      key = x(r)
    endif
  endif
  i = l
  j = r
  !
  ! Find a big record on the left
10 if (x(i).ge.key) goto 11
  i = i + 1
  goto 10
11 continue
  ! Find a small record on the right
20 if (x(j).le.key) goto 21
  j = j - 1
  goto 20
21 continue
  if (i.ge.j) goto 2
  !
  ! Exchange records
  temp = x(i)
  x(i) = x(j)
  x(j) = temp
  itemp = it(i)
  it(i) = it(j)
  it(j) = itemp
  i = i + 1
  j = j - 1
  goto 10
  !
  ! Subfile is partitioned into two halves, left .le. right
  ! Push the two halves on the stack
2 continue
  if (j-l+1 .gt. nstop) then
    sp = sp + 1
    if (sp.gt.maxstack) then
      write(mess,*) 'Stack overflow ',sp
      call gmath_message(seve%e,'SORT',mess)
      error = .true.
      return
    endif
    lstack(sp) = l
    rstack(sp) = j
  endif
  if (r-j .gt. nstop) then
    sp = sp + 1
    if (sp.gt.maxstack) then
      write(mess,*) 'Stack overflow ',sp
      call gmath_message(seve%e,'SORT',mess)
      error = .true.
      return
    endif
    lstack(sp) = j+1
    rstack(sp) = r
  endif
  !
  ! Anything left to process?
  if (sp.gt.0) goto 1
  !
50 continue
  !
  do j=n-1,1,-1
    k = j
    do i=j+1,n
      if (x(j).le.x(i)) exit   ! I
      k = i
    enddo
    if (k.eq.j) cycle          ! J
    temp = x(j)
    do i = j+1,k
      x(i-1) = x(i)
    enddo
    x(k) = temp
    itemp = it(j)
    do i = j+1,k
      it(i-1) = it(i)
    enddo
    it(k) = itemp
  enddo                        ! J
  return
end subroutine gi8_trie
!
subroutine gi8_sort(x,xwork,key,n)
  use gmath_interfaces, except_this=>gi8_sort
  !---------------------------------------------------------------------
  ! @ public-mandatory (because symbol is used elsewhere)
  !  Reorder an integer*8 array by increasing order using the sorted
  ! indexes computed by a G*_TRIE subroutine
  !---------------------------------------------------------------------
  integer(kind=4), intent(in)    :: n         ! Length of arrays
  integer(kind=8), intent(inout) :: x(n)      ! Unsorted array
  integer(kind=8)                :: xwork(n)  ! Working buffer
  integer(kind=4), intent(in)    :: key(n)    ! Integer array of sorted indexes
  ! Local
  integer(kind=4) :: i
  !
  if (n.le.1) return
  do i=1,n
    xwork(i) = x(key(i))
  enddo
  do i=1,n
    x(i) = xwork(i)
  enddo
end subroutine gi8_sort
!
subroutine gch_trie(x,it,n,nc,error)
  use gbl_message
  use gmath_interfaces, except_this=>gch_trie
  !---------------------------------------------------------------------
  ! @ public-mandatory (because symbol is used elsewhere)
  !  Sorting program that uses a quicksort algorithm.
  !  Applies for an input array of CHARACTER(len=*) values. Also returns
  ! an array of indexes sorted for increasing order of X which can used
  ! in GCH_SORT to reorder other arrays
  !---------------------------------------------------------------------
  integer(kind=4),   intent(in)    :: n      ! Length of arrays
  integer(kind=4),   intent(in)    :: nc     ! Size of strings
  character(len=nc), intent(inout) :: x(n)   ! Unsorted array
  integer(kind=4),   intent(out)   :: it(n)  ! Integer array of sorted indexes
  logical,           intent(out)   :: error  ! Error flag
  ! Local
  integer(kind=4), parameter :: maxstack=1000,nstop=15
  integer(kind=4) :: i,j,k,itemp,l,r,m
  integer(kind=4) :: lstack(maxstack),rstack(maxstack),sp
  character(len=nc) :: temp,key
  logical :: mgtl,lgtr,rgtm
  character(len=message_length) :: mess
  !
  error = .false.
  !
  ! Load initial pointers
  do i = 1,n
    it(i) = i
  enddo
  !
  if (n.le.nstop) goto 50
  sp = 0
  sp = sp + 1
  lstack(sp) = 1
  rstack(sp) = n
  !
  ! Sort a subrecord off the stack
  ! Set KEY = median of X(L), X(M), X(R)
  ! No! This is not reasonable, as systematic very inequal partitioning will
  ! occur in some cases (especially for nearly already sorted files)
  ! To fix this problem, I found (but I cannot prove it) that it is best to
  ! select the estimation of the median value from intermediate records. P.V.
1 l = lstack(sp)
  r = rstack(sp)
  sp = sp - 1
  m = (l + r) / 2
  !
  !      L1=(2*L+R)/3         and      R1=(L+2*R)/3
  !
  mgtl = lgt(x(m),x(l))
  rgtm = lgt(x(r),x(m))
  !
  ! Algorithm to select the median key. The original one from MONGO
  ! was completely wrong. P. Valiron, 24-Jan-84 .
  !
  !                       MGTL    RGTM    LGTR    MGTL.EQV.LGTR   MEDIAN_KEY
  !
  !       KL < KM < KR    T       T       *       *               KM
  !       KL > KM > KR    F       F       *       *               KM
  !
  !       KL < KM > KR    T       F       F       F               KR
  !       KL < KM > KR    T       F       T       T               KL
  !
  !       KL > KM < KR    F       T       F       T               KL
  !       KL > KM < KR    F       T       T       F               KR
  !
  if (mgtl .eqv. rgtm) then
    key = x(m)
  else
    lgtr = lgt(x(l),x(r))
    if (mgtl .eqv. lgtr) then
      key = x(l)
    else
      key = x(r)
    endif
  endif
  i = l
  j = r
  !
  ! Find a big record on the left
10 if (lge(x(i),key)) goto 11
  i = i + 1
  goto 10
11 continue
  ! Find a small record on the right
20 if (lle(x(j),key)) goto 21
  j = j - 1
  goto 20
21 continue
  if (i.ge.j) goto 2
  !
  ! Exchange records
  temp = x(i)
  x(i) = x(j)
  x(j) = temp
  itemp = it(i)
  it(i) = it(j)
  it(j) = itemp
  i = i + 1
  j = j - 1
  goto 10
  !
  ! Subfile is partitioned into two halves, left .le. right
  ! Push the two halves on the stack
2 continue
  if (j-l+1 .gt. nstop) then
    sp = sp + 1
    if (sp.gt.maxstack) then
      write(mess,*) 'Stack overflow ',sp
      call gmath_message(seve%e,'SORT',mess)
      error = .true.
      return
    endif
    lstack(sp) = l
    rstack(sp) = j
  endif
  if (r-j .gt. nstop) then
    sp = sp + 1
    if (sp.gt.maxstack) then
      write(mess,*) 'Stack overflow ',sp
      call gmath_message(seve%e,'SORT',mess)
      error = .true.
      return
    endif
    lstack(sp) = j+1
    rstack(sp) = r
  endif
  !
  ! Anything left to process?
  if (sp.gt.0) goto 1
  !
50 continue
  !
  do j=n-1,1,-1
    k = j
    do i=j+1,n
      if (lle(x(j),x(i))) exit   ! I
      k = i
    enddo
    if (k.eq.j) cycle          ! J
    temp = x(j)
    do i = j+1,k
      x(i-1) = x(i)
    enddo
    x(k) = temp
    itemp = it(j)
    do i = j+1,k
      it(i-1) = it(i)
    enddo
    it(k) = itemp
  enddo                        ! J
  return
end subroutine gch_trie
!
subroutine gch_sort(x,xwork,key,nc,n)
  use gmath_interfaces, except_this=>gch_sort
  !---------------------------------------------------------------------
  ! @ public-mandatory (because symbol is used elsewhere)
  !   Reorder a character array by increasing order using the sorted
  ! indexes computed by a G*_TRIE subroutine
  !---------------------------------------------------------------------
  integer(kind=4),   intent(in)    :: nc        ! Size of strings
  character(len=nc), intent(inout) :: x(*)      ! The array
  character(len=nc)                :: xwork(*)  ! Work buffer
  integer(kind=4),   intent(in)    :: key(*)    ! Integer array of sorted indexes
  integer(kind=4),   intent(in)    :: n         ! Length of arrays
  ! Local
  integer(kind=4) :: i
  !
  if (n.le.1) return
  do i=1,n
    xwork(i) = x(key(i))
  enddo
  do i=1,n
    x(i) = xwork(i)
  enddo
end subroutine gch_sort
!
subroutine gl_sort(x,xwork,key,n)
  use gmath_interfaces, except_this=>gl_sort
  !---------------------------------------------------------------------
  ! @ public-mandatory (because symbol is used elsewhere)
  !  Reorder a logical*4 array by increasing order using the sorted
  ! indexes computed by a G*_TRIE subroutine
  !---------------------------------------------------------------------
  integer(kind=4), intent(in)    :: n         ! Length of arrays
  logical,         intent(inout) :: x(n)      ! Unsorted array
  logical                        :: xwork(n)  ! Working buffer
  integer(kind=4), intent(in)    :: key(n)    ! Integer array of sorted indexes
  ! Local
  integer(kind=4) :: i
  !
  if (n.le.1) return
  do i=1,n
    xwork(i) = x(key(i))
  enddo
  do i=1,n
    x(i) = xwork(i)
  enddo
end subroutine gl_sort
!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
subroutine gi4_quicksort_index_with_user_gtge(x,n,ugt,uge,error)
  use gmath_interfaces, except_this=>gi4_quicksort_index_with_user_gtge
  use gbl_message
  !---------------------------------------------------------------------
  ! @ public-generic gi0_quicksort_index_with_user_gtge
  ! Sort an integer*4 index array according to an external comparison
  ! criteria. The index array can then be used by gi4_quicksort_array
  ! to sort an associated array.
  !---------------------------------------------------------------------
  integer(kind=4), intent(in)    :: n      ! Length of index array
  integer(kind=4), intent(inout) :: x(n)   ! Index array to be sorted
  logical,         external      :: ugt    ! User greater than
  logical,         external      :: uge    ! User greater than or equal
  logical,         intent(out)   :: error  ! Error status
  ! Local
  character(len=*), parameter :: rname='SORT'
  integer(kind=4), parameter :: maxstack=1000, nstop=15
  integer(kind=4) :: temp,key
  integer(kind=4) :: i,j,k,l,r,m
  integer(kind=4) :: lstack(maxstack),rstack(maxstack),sp
  logical :: mgtl,lgtr,rgtm
  character(len=message_length) :: mess
  !
  error = .false.
  !
  if (n.le.nstop) goto 50
  sp = 0
  sp = sp + 1
  lstack(sp) = 1
  rstack(sp) = n
  !
  ! Sort a subrecord off the stack
  ! Set KEY = median of X(L), X(M), X(R)
  ! No! This is not reasonable, as systematic very inequal partitioning will
  ! occur in some cases (especially for nearly already sorted files)
  ! To fix this problem, I found (but I cannot prove it) that it is best to
  ! select the estimation of the median value from intermediate records. P.V.
1 l = lstack(sp)
  r = rstack(sp)
  sp = sp - 1
  m = (l + r) / 2
  !
  mgtl = ugt(x(m),x(l))
  rgtm = ugt(x(r),x(m))
  !
  ! Algorithm to select the median key:
  !
  !                       MGTL    RGTM    LGTR    MGTL.EQV.LGTR   MEDIAN_KEY
  !
  !       KL < KM < KR    T       T       *       *               KM
  !       KL > KM > KR    F       F       *       *               KM
  !
  !       KL < KM > KR    T       F       F       F               KR
  !       KL < KM > KR    T       F       T       T               KL
  !
  !       KL > KM < KR    F       T       F       T               KL
  !       KL > KM < KR    F       T       T       F               KR
  !
  if (mgtl .eqv. rgtm) then
    key = x(m)
  else
    lgtr = ugt(x(l),x(r))
    if (mgtl .eqv. lgtr) then
      key = x(l)
    else
      key = x(r)
    endif
  endif
  i = l
  j = r
  !
  ! Find a big record on the left
10 if (uge(x(i),key)) goto 11
  i = i + 1
  goto 10
11 continue
  ! Find a small record on the right
20 if (uge(key,x(j))) goto 21
  j = j - 1
  goto 20
21 continue
  if (i.ge.j) goto 2
  !
  ! Exchange records
  temp = x(i)
  x(i) = x(j)
  x(j) = temp
  i = i + 1
  j = j - 1
  goto 10
  !
  ! Subfile is partitioned into two halves, left .le. right
  ! Push the two halves on the stack
2 continue
  if (j-l+1 .gt. nstop) then
    sp = sp + 1
    if (sp.gt.maxstack) then
      write(mess,*) 'Stack overflow ',sp
      call gmath_message(seve%e,rname,mess)
      error = .true.
      return
    endif
    lstack(sp) = l
    rstack(sp) = j
  endif
  if (r-j .gt. nstop) then
    sp = sp + 1
    if (sp.gt.maxstack) then
      write(mess,*) 'Stack overflow ',sp
      call gmath_message(seve%e,rname,mess)
      error = .true.
      return
    endif
    lstack(sp) = j+1
    rstack(sp) = r
  endif
  !
  ! Anything left to process?
  if (sp.gt.0) goto 1
  !
50 continue
  !
  do j=n-1,1,-1
    k = j
    do i=j+1,n
      if (uge(x(i),x(j))) exit ! i
      k = i
    enddo ! i
    if (k.eq.j) cycle ! j
    temp = x(j)
    do i = j+1,k
      x(i-1) = x(i)
    enddo ! i
    x(k) = temp
  enddo ! j
end subroutine gi4_quicksort_index_with_user_gtge
!
subroutine gi8_quicksort_index_with_user_gtge(x,n,ugt,uge,error)
  use gmath_interfaces, except_this=>gi8_quicksort_index_with_user_gtge
  use gbl_message
  !---------------------------------------------------------------------
  ! @ public-generic gi0_quicksort_index_with_user_gtge
  ! Sort an integer*8 index array according to an external comparison
  ! criteria. The index array can then be used by gi4_quicksort_array
  ! to sort an associated array.
  !---------------------------------------------------------------------
  integer(kind=8), intent(in)    :: n      ! Length of index array
  integer(kind=8), intent(inout) :: x(n)   ! Index array to be sorted
  logical,         external      :: ugt    ! User greater than
  logical,         external      :: uge    ! User greater than or equal
  logical,         intent(out)   :: error  ! Error status
  ! Local
  character(len=*), parameter :: rname='SORT'
  integer(kind=4), parameter :: maxstack=1000, nstop=15
  integer(kind=8) :: temp,key
  integer(kind=8) :: i,j,k,l,r,m
  integer(kind=8) :: lstack(maxstack),rstack(maxstack),sp
  logical :: mgtl,lgtr,rgtm
  character(len=message_length) :: mess
  !
  error = .false.
  !
  if (n.le.nstop) goto 50
  sp = 0
  sp = sp + 1
  lstack(sp) = 1
  rstack(sp) = n
  !
  ! Sort a subrecord off the stack
  ! Set KEY = median of X(L), X(M), X(R)
  ! No! This is not reasonable, as systematic very inequal partitioning will
  ! occur in some cases (especially for nearly already sorted files)
  ! To fix this problem, I found (but I cannot prove it) that it is best to
  ! select the estimation of the median value from intermediate records. P.V.
1 l = lstack(sp)
  r = rstack(sp)
  sp = sp - 1
  m = (l + r) / 2
  !
  mgtl = ugt(x(m),x(l))
  rgtm = ugt(x(r),x(m))
  !
  ! Algorithm to select the median key:
  !
  !                       MGTL    RGTM    LGTR    MGTL.EQV.LGTR   MEDIAN_KEY
  !
  !       KL < KM < KR    T       T       *       *               KM
  !       KL > KM > KR    F       F       *       *               KM
  !
  !       KL < KM > KR    T       F       F       F               KR
  !       KL < KM > KR    T       F       T       T               KL
  !
  !       KL > KM < KR    F       T       F       T               KL
  !       KL > KM < KR    F       T       T       F               KR
  !
  if (mgtl .eqv. rgtm) then
    key = x(m)
  else
    lgtr = ugt(x(l),x(r))
    if (mgtl .eqv. lgtr) then
      key = x(l)
    else
      key = x(r)
    endif
  endif
  i = l
  j = r
  !
  ! Find a big record on the left
10 if (uge(x(i),key)) goto 11
  i = i + 1
  goto 10
11 continue
  ! Find a small record on the right
20 if (uge(key,x(j))) goto 21
  j = j - 1
  goto 20
21 continue
  if (i.ge.j) goto 2
  !
  ! Exchange records
  temp = x(i)
  x(i) = x(j)
  x(j) = temp
  i = i + 1
  j = j - 1
  goto 10
  !
  ! Subfile is partitioned into two halves, left .le. right
  ! Push the two halves on the stack
2 continue
  if (j-l+1 .gt. nstop) then
    sp = sp + 1
    if (sp.gt.maxstack) then
      write(mess,*) 'Stack overflow ',sp
      call gmath_message(seve%e,rname,mess)
      error = .true.
      return
    endif
    lstack(sp) = l
    rstack(sp) = j
  endif
  if (r-j .gt. nstop) then
    sp = sp + 1
    if (sp.gt.maxstack) then
      write(mess,*) 'Stack overflow ',sp
      call gmath_message(seve%e,rname,mess)
      error = .true.
      return
    endif
    lstack(sp) = j+1
    rstack(sp) = r
  endif
  !
  ! Anything left to process?
  if (sp.gt.0) goto 1
  !
50 continue
  !
  do j=n-1,1,-1
    k = j
    do i=j+1,n
      if (uge(x(i),x(j))) exit ! i
      k = i
    enddo ! i
    if (k.eq.j) cycle ! j
    temp = x(j)
    do i = j+1,k
      x(i-1) = x(i)
    enddo ! i
    x(k) = temp
  enddo ! j
end subroutine gi8_quicksort_index_with_user_gtge
!
subroutine gi4_quicksort_array(array,work,index,n,error)
  use gmath_interfaces, except_this=>gi4_quicksort_array
  use gbl_message
  !---------------------------------------------------------------------
  ! @ private
  ! Reorder an integer(4) array by increasing order using the sorted
  ! index computed by gi4_quicksort_index
  !---------------------------------------------------------------------
  integer(kind=4), intent(in)    :: n         ! Length of arrays
  integer(kind=4), intent(inout) :: array(n)  ! Array
  integer(kind=4), intent(inout) :: work(n)   ! Work space
  integer(kind=4), intent(in)    :: index(n)  ! index array
  logical,         intent(out)   :: error     ! Error status
  ! Local
  integer(kind=4) :: i
  !
  error = .false.
  if (n.le.1) then
     call gmath_message(seve%e,'SORT','Input array dimension < 1')
     error = .true.
     return
  endif
  do i=1,n
    work(i) = array(index(i))
  enddo
  do i=1,n
    array(i) = work(i)
  enddo
end subroutine gi4_quicksort_array
!
function gr8_in (x,y,ngon,gons,bound)
  use gmath_interfaces, except_this=>gr8_in
  !---------------------------------------------------------------------
  ! @ public
  !  Find if a point is within a n-gon
  !---------------------------------------------------------------------
  logical :: gr8_in  ! Function value on return
  real(kind=8),    intent(in) :: x,y        ! Coordinate of point to test
  integer(kind=4), intent(in) :: ngon       ! Current number of summits
  real(kind=8),    intent(in) :: gons(:,:)  ! Description of polygon
  real(kind=8),    intent(in) :: bound(5)   ! Polygon boundary
  ! Local
  integer(kind=4) :: index,i
  real(kind=8) :: d,xx
  logical :: yin
  !
  ! Quick check.
  if (x.lt.bound(2) .or. x.gt.bound(3) .or.  &
      y.lt.bound(4) .or. y.gt.bound(5)) then
    gr8_in = .false.
    return
  endif
  gr8_in = .true.
  !
  ! Count intersection.
  index = 0
  do i=1,ngon
    !
    if (x.eq.gons(i,1) .and. y.eq.gons(i,2)) then
      return                   ! Summit is in
    endif
    !
    ! Check Y range
    if (y.le.gons(i,2) .and. y.ge.gons(i+1,2)) then
      yin = .true.
    elseif (y.ge.gons(i,2) .and. y.le.gons(i+1,2)) then
      yin = .true.
    else
      yin = .false.
    endif
    !
    ! If Y is OK, check X
    if (yin) then
      !
      ! Polygon side is normal
      if (gons(i,3).ne.0) then
        d = gons(i,4)/gons(i,3)
        ! Lines intersect
        if (d.ne.0d0) then
          xx =  (y-gons(i,2))/d + gons(i,1)
          if (xx.lt.x) then
            index = index+1
          elseif (xx.eq.x) then
            return
          endif
          ! Lines have same slope (i.e. Horizontal)
        else
          if (x.ge.gons(i,1) .and. x.le.gons(i+1,1) ) then
            return             ! On edge
          elseif (x.le.gons(i,1) .and. x.ge.gons(i+1,1) ) then
            return             ! On edge
          endif
        endif
      else
        !
        ! Polygon side is vertical
        if (gons(i,1).lt.x) then
          index = index+1      ! Crosses
        elseif (gons(i,1).eq.x) then
          return               ! On edge
        endif
      endif
    endif
  enddo
  !
  gr8_in = mod(index,2).eq.1
end function gr8_in
