/*
 ============================================================================
 Name		: BenchmarkAppUi.h
 Author	  : Konstantin Knizhnik
 Copyright   : GigaBASE is freeware
 Description : Declares UI class for application.
 ============================================================================
 */

#ifndef __BENCHMARKAPPUI_h__
#define __BENCHMARKAPPUI_h__

// INCLUDES
#include <aknappui.h>

// FORWARD DECLARATIONS
class CBenchmarkAppView;

// CLASS DECLARATION
/**
 * CBenchmarkAppUi application UI class.
 * Interacts with the user through the UI and request message processing
 * from the handler class
 */
class CBenchmarkAppUi : public CAknAppUi
	{
public:
	// Constructors and destructor

	/**
	 * ConstructL.
	 * 2nd phase constructor.
	 */
	void ConstructL();

	/**
	 * CBenchmarkAppUi.
	 * C++ default constructor. This needs to be public due to
	 * the way the framework constructs the AppUi
	 */
	CBenchmarkAppUi();

	/**
	 * ~CBenchmarkAppUi.
	 * Virtual Destructor.
	 */
	virtual ~CBenchmarkAppUi();

private:
	// Functions from base classes

	/**
	 * From CEikAppUi, HandleCommandL.
	 * Takes care of command handling.
	 * @param aCommand Command to be handled.
	 */
	void HandleCommandL(TInt aCommand);

	/**
	 *  HandleStatusPaneSizeChange.
	 *  Called by the framework when the application status pane
	 *  size is changed.
	 */
	void HandleStatusPaneSizeChange();

	/**
	 *  From CCoeAppUi, HelpContextL.
	 *  Provides help context for the application.
	 *  size is changed.
	 */
	CArrayFix<TCoeHelpContext>* HelpContextL() const;

private:
	// Data

	/**
	 * The application view
	 * Owned by CBenchmarkAppUi
	 */
	CBenchmarkAppView* iAppView;

	};

#endif // __BENCHMARKAPPUI_h__
// End of File
