using System;
using CSharpCLI;

class person {
    public string      name;
    public int         salary;
    public string      address;
    public double      rating;
    public string[]    pets;
    [References("person")]
    public Reference[] subordinates;
}

public class CliTest { 
    static public void Main(string[] args) { 
	ConnectionPool pool = null;
	int nConnections = 1;
	if (args.Length > 0) { 
	    nConnections = Convert.ToInt32(args[0]);
	}
	
	if (nConnections > 1) {
	    pool = new ConnectionPool();
	}
	for (int i = 0; i < nConnections; i++) { 
	    Connection con;
	    if (nConnections > 1) { 
		con = pool.newConnection("localhost", 6100);
	    } else { 
		con = new Connection();
		con.open("localhost", 6100);
	    }
	    doTest(con);
	}
	if (nConnections > 1) {
	    pool.close();
	}
    }
    
    static void doTest(Connection con) { 
	int i;
        if (con.createTable(typeof(person))) { 
            con.addIndex("person", "salary");
            con.addIndex("person", "name");
        }
	person p = new person();
	p.name = "John Smith";
	p.address = "1 Guildhall St., Cambridge CB2 3NH, UK";
	p.salary = 80000;
	p.rating = 3.84;
	p.pets = new string[2];
	p.pets[0] = "dog";
	p.pets[1] = "cat";
	p.subordinates = new Reference[0];
	Reference john = con.insert(p);
	p.name = "Joe Cooker";
	p.address = "Outlook drive, 15/3";
	p.salary = 50000;
	p.rating = 1.76;
	p.pets = new string[1];
	p.pets[0] = "snake";
	p.subordinates = new Reference[1];
	p.subordinates[0] = john;
	Reference joe = con.insert(p);
	p.name = "Hugo Grant";
	p.address = "London, Baker street,12";
	p.salary = 65000;
	p.rating = 2.14;	
	p.pets =  new String[2];
	p.pets[0] = "canary";
	p.pets[1] = "goldfish";
	p.subordinates = new Reference[0];
	con.insert(p);
	con.commit();

	Statement stmt = con.createStatement("select * from person where salary > %salary order by salary");
	stmt.setInt("%salary", 65000);
	ObjectSet cursor = stmt.fetch();
	if (cursor.size() != 1) {
	    Console.WriteLine("stmt->fetch 1 returns {0} instead of 1", cursor.size());
	}
	Console.WriteLine("NAME\t\tSALARY\tRATING");
	while ((p = (person)cursor.getNext()) != null) { 
	    Console.WriteLine("{0}\t{1}\t{2}", p.name, p.salary, p.rating);
	}
	stmt.setInt("%salary", 50000);
	cursor = stmt.fetch();
	if (cursor.size() != 2) {
	    Console.WriteLine("stmt->fetch 2 returns {0} instead of 2", cursor.size());
	}
	stmt.close();

	stmt = con.createStatement("select * from person where current = %ref");
	stmt.setRef("%ref", joe);
	cursor = stmt.fetch();
	if (cursor.size() != 1) {
	    Console.WriteLine("stmt->fetch 3 returns {0} instead of 1", cursor.size());
	}
	p = (person)cursor.getFirst();
	Console.WriteLine("Object oid={0} , name={1}, address={2}, rating={3}, salary={4}",
			  cursor.getRef(), p.name, p.address, p.rating, p.salary);
	for (i = 0 ; i < p.pets.Length; i++) { 
	    Console.WriteLine("Pet: {0}", p.pets[i]);
	}
	for (i = 0 ; i < p.subordinates.Length; i++) { 
	    Statement s =  con.createStatement("select * from person where current = %ref");
	    s.setRef("%ref", p.subordinates[i]);
	    ObjectSet  objs = s.fetch();
	    person q = (person)objs.getNext();
	    Console.WriteLine("Subordinate: {0}", q.name);
	}	
	stmt.close();

	stmt = con.createStatement("select * from person where rating > %rating and salary between %min and %max");
	stmt.setDouble("%rating", 2.0);
	stmt.setInt("%min", 50000);
	stmt.setInt("%max", 100000);
	cursor = stmt.fetch(true);
	if (cursor.size() != 2) {
	    Console.WriteLine("stmt->fetch 4 returns {0} instead of 2", cursor.size());
	}
	p = (person)cursor.getLast();
	Console.WriteLine("NAME\t\tSALARY\tRATING\tADDRESS");
	do { 
	    Console.WriteLine("{0}\t{1}\t{2}\t{3}", p.name, p.salary, p.rating, p.address);
	    p.salary = (int)(p.salary * 1.1);
	    cursor.update();
	} while ((p = (person)cursor.getPrev()) != null);
	stmt.close();

	con.commit();

	stmt = con.createStatement("select * from person where address like %pattern");
	stmt.setString("%pattern", "%"); 
	cursor = stmt.fetch();
	if (cursor.size() != 3) {
	    Console.WriteLine("stmt->fetch 5 returns {0} instead of 3", cursor.size());
	}
	Console.WriteLine("NAME\t\tSALARY\tRATING\tADDRESS");
	while ((p = (person)cursor.getNext()) != null) { 
	    Console.WriteLine("{0}\t{1}\t{2}\t{3}", p.name, p.salary, p.rating, p.address);
	}
	stmt.close();

	stmt = con.createStatement("select * from person");
	cursor = stmt.fetch(true);
	if (cursor.size() != 3) {
	    Console.WriteLine("stmt->fetch 6 returns {0} instead of 3", cursor.size());
	}
	cursor.removeAll();
	stmt.close();

	con.close();
	Console.WriteLine("*** CLI test sucessfully passed!");
    }
}


