#include <errno.h>
#include <signal.h>
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <string.h>
#include <netdb.h>
#include <sys/socket.h>
#include <netinet/in.h>

#define TXMODE_UDP	1
#define TXMODE_TCP	2

#define DMODE_BIN	1
#define DMODE_ASCII	2

#define incopy(a)       *((struct in_addr *)a)

unsigned long int cnt = 0;

int READ(int fd, char *whereto, size_t len)
{
	int cnt=len;

	while(len>0)
	{
		int rc;

		rc = read(fd, whereto, len);

		if (rc == -1)
		{
			if (errno != EINTR && errno != EAGAIN)
			{
				return -1;
			}
		}
		else if (rc == 0)
		{
			return 0;
		}
		else
		{
			whereto += rc;
			len -= rc;
		}
	}

	return cnt;
}

int WRITE(int fd, char *whereto, size_t len)
{
	int cnt=len;

	while(len>0)
	{
		int rc;

		rc = write(fd, whereto, len);

		if (rc == -1)
		{
			if (errno != EINTR && errno != EAGAIN)
			{
				return -1;
			}
		}
		else if (rc == 0)
		{
			return 0;
		}
		else
		{
			whereto += rc;
			len -= rc;
		}
	}

	return cnt;
}

static int rand_avail=0;
int seed_rand()
{
	unsigned char buffer[3];
	int fd = open("/dev/urandom", O_RDONLY);
	if (fd == -1)
	{
		fprintf(stderr, "open(/dev/urandom) error: %d\n", errno);
		return -1;
	}

	if (READ(fd, (char *)buffer, 3) != 3)
	{
		close(fd);
		return -1;
	}

	srand((buffer[0] << 8) + buffer[1]);

	rand_avail = buffer[3];

	close(fd);

	return 0;
}

char rand_byte()
{
	if (--rand_avail == 0)
		seed_rand();

	return (char)(rand()&255);
}

int resolve_address(char *hostname, struct sockaddr_in *addr_out)
{
	// lookup hostname
	struct hostent *ph;
	ph = gethostbyname(hostname);
	if (!ph)
	{
		fprintf(stderr, "problem while resolving %s!\n", hostname);
		return -1;
	}

	memset((void *)addr_out, 0, sizeof(struct sockaddr_in));
	addr_out -> sin_family = ph -> h_addrtype;
	addr_out -> sin_addr = incopy(ph -> h_addr_list[0]);

	return 0;
}

char * create_data(char data_mode, int len)
{
	int loop;
	char *buffer = (unsigned char *)malloc(len);

	if (!buffer)
	{
		fprintf(stderr, "could not allocate %d bytes of memory\n", len);
		return NULL;
	}

	if (data_mode == DMODE_ASCII)
	{
		for(loop=0; loop<len; loop++)
		{
			char dummy;

			do
			{
				dummy = rand_byte() & 127;
			}
			while(dummy<32 && dummy != 13 && dummy != 10);

			buffer[loop] = dummy;
		}
	}
	else if (data_mode == DMODE_BIN)
	{
		for(loop=0; loop<len; loop++)
			buffer[loop] = rand_byte();
	}

	return buffer;
}

void print_stats(void)
{
	cnt++;

	if ((cnt & 1023) == 0)
	{
		printf("%ld\r", cnt);
		fflush(stdout);
	}
}

int do_udp(char *hostname, int portnr, char data_mode)
{
	int sh;
	struct sockaddr_in addr;

	sh = socket(AF_INET, SOCK_STREAM, 0);
	if (sh == -1)
	{
		fprintf(stderr, "could not create socket error: %d\n", errno);
		return -1;
	}

	(void)resolve_address(hostname, &addr);
	addr.sin_port = htons(portnr);

	for(;;)
	{
		unsigned char *buffer;
		int len, rc;

		len  = ((unsigned char)rand_byte()) << 1;
		len += ((unsigned char)rand_byte());

		len &= 511;

		if (!len) len = 1;

		buffer = create_data(data_mode, len);
		if (!buffer)
			break;

		rc = sendto(sh, (void *)buffer, len, 0, (struct sockaddr *)&addr, sizeof(addr));

		free(buffer);

		print_stats();

		if (rc == -1 && errno != 32) /* 32 = EPIPE */
		{
			fprintf(stderr, "sendto failed with %d\n", errno);
			break;
		}
	}

	close(sh);

	return 0;
}

int do_tcpip(char *hostname, int portnr, char data_mode)
{
	int sh;
	struct sockaddr_in addr;
	char exit=0;

	print_stats();

	sh = socket(AF_INET, SOCK_STREAM, 0);
	if (sh == -1)
	{
		fprintf(stderr, "could not create socket error: %d\n", errno);
		return -1;
	}

	(void)resolve_address(hostname, &addr);
	addr.sin_port = htons(portnr);

	if (connect(sh, (struct sockaddr *)&addr, sizeof(addr)) == -1)
	{
		fprintf(stderr, "connect() failed with error-code: %d\n", errno);
		close(sh);
		return -1;
	}

	for(;!exit;)
	{
		unsigned char *buffer;
		int len, rc;

		len  = ((unsigned char)rand_byte()) << 8;
		len += ((unsigned char)rand_byte());

		if (!len) len = 1;
		if (len > 65535) len = 65535;

		buffer = create_data(data_mode, len);
		if (!buffer)
			break;

		rc = WRITE(sh, buffer, len);

		free(buffer);

		if (rc == 0 || rc == -1)
			break;
	}

	close(sh);

	return 0;
}

int main(int argc, char *argv[])
{
	char *hostname, tx_mode, data_mode;
	int portnr;

	signal(SIGPIPE, SIG_IGN);

	printf("gibberish v0.1, (C) 2002 by folkert@vanheusden.com\n\n");

	if (argc != 5)
	{
		printf("Usage: %s -t/-u -a/-b hostname portnr\n", argv[0]);
		return 1;
	}

	if (strcasecmp(argv[1], "-u") == 0)
		tx_mode = TXMODE_UDP;
	else if (strcasecmp(argv[1], "-t") == 0)
		tx_mode = TXMODE_TCP;
	else
	{
		fprintf(stderr, "2nd parameter must be either -t (TCP) or -u (UDP)\n");
		return 1;
	}

	if (strcasecmp(argv[2], "-a") == 0)
		data_mode = DMODE_ASCII;
	else if (strcasecmp(argv[2], "-b") == 0)
		data_mode = DMODE_BIN;
	else
	{
		fprintf(stderr, "3d parameter must be either -a (ASCII) or -b (BINARY)\n");
		return 1;
	}

	hostname = strdup(argv[3]);
	portnr = atoi(argv[4]);

	printf("Using: %s:%d\n", hostname, portnr);
	printf("Press break (ctrl+c) to abort\n\n");

	(void)seed_rand();

	if (tx_mode == TXMODE_TCP)
	{
		for(;;)
		{
			do_tcpip(hostname, portnr, data_mode);
		}
	}
	else if (tx_mode == TXMODE_UDP)
	{
		do_udp(hostname, portnr, data_mode);
	}

	return 0;
}
