/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.task;

import ghidra.util.datastruct.WeakDataStructureFactory;
import ghidra.util.datastruct.WeakSet;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.CancelledListener;
import ghidra.util.task.TaskMonitor;

public class WrappingTaskMonitor
implements TaskMonitor {
    private WeakSet<CancelledListener> listeners = WeakDataStructureFactory.createCopyOnReadWeakSet();
    protected TaskMonitor delegate;

    public WrappingTaskMonitor(TaskMonitor delegate) {
        this.delegate = delegate;
    }

    public synchronized void setDelegate(TaskMonitor newDelegate) {
        if (this.delegate.isCancelled()) {
            newDelegate.cancel();
            return;
        }
        for (CancelledListener l : this.listeners) {
            newDelegate.addCancelledListener(l);
            this.delegate.removeCancelledListener(l);
        }
        newDelegate.initialize(this.delegate.getMaximum());
        newDelegate.setProgress(this.delegate.getProgress());
        newDelegate.setMessage(this.delegate.getMessage());
        newDelegate.setIndeterminate(this.delegate.isIndeterminate());
        newDelegate.setCancelEnabled(this.delegate.isCancelEnabled());
        this.delegate = newDelegate;
    }

    public synchronized boolean isCancelled() {
        return this.delegate.isCancelled();
    }

    public void setShowProgressValue(boolean showProgressValue) {
        this.delegate.setShowProgressValue(showProgressValue);
    }

    public void setMessage(String message) {
        this.delegate.setMessage(message);
    }

    public String getMessage() {
        return this.delegate.getMessage();
    }

    public void setProgress(long value) {
        this.delegate.setProgress(value);
    }

    public void initialize(long max) {
        this.delegate.initialize(max);
    }

    public synchronized void setMaximum(long max) {
        this.delegate.setMaximum(max);
    }

    public long getMaximum() {
        return this.delegate.getMaximum();
    }

    public synchronized void setIndeterminate(boolean indeterminate) {
        this.delegate.setIndeterminate(indeterminate);
    }

    public boolean isIndeterminate() {
        return this.delegate.isIndeterminate();
    }

    public void checkCanceled() throws CancelledException {
        this.delegate.checkCanceled();
    }

    public void incrementProgress(long incrementAmount) {
        this.delegate.incrementProgress(incrementAmount);
    }

    public long getProgress() {
        return this.delegate.getProgress();
    }

    public synchronized void cancel() {
        this.delegate.cancel();
    }

    public synchronized void addCancelledListener(CancelledListener listener) {
        this.listeners.add(listener);
        this.delegate.addCancelledListener(listener);
    }

    public synchronized void removeCancelledListener(CancelledListener listener) {
        this.listeners.remove(listener);
        this.delegate.removeCancelledListener(listener);
    }

    public synchronized void setCancelEnabled(boolean enable) {
        this.delegate.setCancelEnabled(enable);
    }

    public boolean isCancelEnabled() {
        return this.delegate.isCancelEnabled();
    }

    public synchronized void clearCanceled() {
        this.delegate.clearCanceled();
    }
}

