/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.task;

import ghidra.util.Msg;
import ghidra.util.SystemUtilities;
import ghidra.util.datastruct.WeakDataStructureFactory;
import ghidra.util.datastruct.WeakSet;
import javax.swing.Timer;
import utilities.util.reflection.ReflectionUtilities;

public class SwingUpdateManager {
    private static final long NONE = 0L;
    public static final int DEFAULT_MAX_DELAY = 30000;
    private static final int MIN_DELAY_FLOOR = 10;
    private static final int DEFAULT_MIN_DELAY = 250;
    private static final String DEFAULT_NAME = SwingUpdateManager.class.getSimpleName();
    private static final WeakSet<SwingUpdateManager> instances = WeakDataStructureFactory.createCopyOnReadWeakSet();
    private final Timer timer;
    private final int minDelay;
    private final int maxDelay;
    private final Runnable clientRunnable;
    private final String name;
    private String inceptionInformation;
    private long requestTime = 0L;
    private long bufferingStartTime;
    private boolean disposed = false;
    private boolean isWorking;

    public SwingUpdateManager(Runnable r) {
        this(250, 30000, r);
    }

    public SwingUpdateManager(int minDelay, Runnable r) {
        this(minDelay, 30000, r);
    }

    public SwingUpdateManager(int minDelay, int maxDelay, Runnable r) {
        this(minDelay, maxDelay, DEFAULT_NAME, r);
    }

    public SwingUpdateManager(int minDelay, int maxDelay, String name, Runnable r) {
        if (r == null) {
            throw new IllegalArgumentException("Runnable callback cannot be null");
        }
        this.clientRunnable = r;
        this.maxDelay = maxDelay;
        this.name = name;
        this.recordInception();
        this.minDelay = Math.max(10, minDelay);
        this.timer = new Timer(minDelay, e -> this.timerCallback());
        this.timer.setRepeats(false);
        instances.add(this);
    }

    public synchronized void update() {
        if (this.disposed) {
            return;
        }
        this.requestTime = System.currentTimeMillis();
        SystemUtilities.runSwingLater(this::checkForWork);
    }

    public synchronized void updateLater() {
        if (this.disposed) {
            return;
        }
        this.requestTime = System.currentTimeMillis();
        this.bufferingStartTime = this.bufferingStartTime == 0L ? this.requestTime : this.bufferingStartTime;
        this.scheduleCheckForWork();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateNow() {
        SwingUpdateManager swingUpdateManager = this;
        synchronized (swingUpdateManager) {
            if (this.disposed) {
                return;
            }
            this.requestTime = System.currentTimeMillis();
            this.bufferingStartTime = 0L;
        }
        SystemUtilities.runSwingNow(this::checkForWork);
    }

    public synchronized void stop() {
        if (this.disposed) {
            return;
        }
        this.timer.stop();
        this.requestTime = 0L;
        this.bufferingStartTime = 0L;
    }

    public synchronized boolean hasPendingUpdates() {
        if (this.disposed) {
            return false;
        }
        return this.requestTime != 0L;
    }

    public synchronized boolean isBusy() {
        if (this.disposed) {
            return false;
        }
        return this.requestTime != 0L || this.isWorking;
    }

    public synchronized void dispose() {
        this.timer.stop();
        instances.remove(this);
        this.requestTime = 0L;
        this.bufferingStartTime = 0L;
        this.disposed = true;
    }

    public synchronized boolean isDisposed() {
        return this.disposed;
    }

    public String toString() {
        return this.name + " @ " + this.inceptionInformation;
    }

    public String toStringDebug() {
        return "{\n\tname: " + this.name + "\n\tcreator: " + this.inceptionInformation + " (" + System.identityHashCode(this) + ")\n\trequest time: " + this.requestTime + "\n\twork count: " + this.isWorking + "\n}";
    }

    private void checkForWork() {
        if (this.shouldDoWork()) {
            this.doWork();
        }
    }

    private void timerCallback() {
        if (this.shouldDoWork()) {
            this.doWork();
        } else if (this.requestTime == 0L) {
            this.bufferingStartTime = 0L;
        }
    }

    private synchronized boolean shouldDoWork() {
        if (this.requestTime == 0L) {
            return false;
        }
        long now = System.currentTimeMillis();
        if (this.isTimeToWork(now)) {
            this.bufferingStartTime = now;
            this.requestTime = 0L;
            this.isWorking = true;
            return true;
        }
        this.scheduleCheckForWork();
        return false;
    }

    private void scheduleCheckForWork() {
        this.timer.start();
    }

    private boolean isTimeToWork(long now) {
        long timeSinceBufferingStart = now - this.bufferingStartTime;
        if (timeSinceBufferingStart > (long)this.maxDelay) {
            return true;
        }
        long timeSinceLastRequest = now - this.requestTime;
        return timeSinceLastRequest > (long)this.minDelay;
    }

    private void doWork() {
        try {
            this.clientRunnable.run();
        }
        catch (Throwable t) {
            Msg.showError((Object)this, null, (String)"Unexpected Exception", (Object)"Unexpected exception in Swing Update Manager", (Throwable)t);
        }
        this.isWorking = false;
        this.scheduleCheckForWork();
    }

    private void recordInception() {
        this.inceptionInformation = this.getInceptionFromTheFirstClassThatIsNotUs();
    }

    private String getInceptionFromTheFirstClassThatIsNotUs() {
        Throwable t = ReflectionUtilities.createThrowableWithStackOlderThan((Class[])new Class[]{this.getClass()});
        StackTraceElement[] trace = t.getStackTrace();
        String classInfo = trace[0].toString();
        return classInfo;
    }
}

