/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.preferences;

import ghidra.framework.Application;
import ghidra.framework.GenericRunInfo;
import ghidra.util.Msg;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import util.CollectionUtils;
import utilities.util.FileUtilities;

public class Preferences {
    public static final String APPLICATION_PREFERENCES_FILENAME = "preferences";
    private static final String USER_PLUGIN_PATH = "UserPluginPath";
    public static final String LAST_OPENED_ARCHIVE_DIRECTORY = "LastOpenedArchiveDirectory";
    public static final String PROJECT_DIRECTORY = "ProjectDirectory";
    public static final String LAST_TOOL_IMPORT_DIRECTORY = "LastToolImportDirectory";
    public static final String LAST_TOOL_EXPORT_DIRECTORY = "LastToolExportDirectory";
    public static final String LAST_NEW_PROJECT_DIRECTORY = "LastNewProjectDirectory";
    public static final String LAST_IMPORT_DIRECTORY = "LastImportDirectory";
    public static final String LAST_EXPORT_DIRECTORY = "LastExportDirectory";
    private static Properties properties = new Properties();
    private static Properties previousProperties = new Properties();
    private static String filename = null;

    private Preferences() {
    }

    private static void load(String pathName) throws IOException {
        Msg.info(Preferences.class, (Object)("Loading user preferences: " + pathName));
        properties = new Properties();
        filename = pathName;
        File file = new File(pathName);
        if (file.exists()) {
            try (FileInputStream in = new FileInputStream(pathName);){
                properties.load(in);
            }
        }
        Preferences.loadPreviousInstallationPreferences();
    }

    private static void loadPreviousInstallationPreferences() throws IOException {
        try (FileInputStream fis = Preferences.getAlternateFileInputStream();){
            if (fis != null) {
                previousProperties.load(fis);
            }
        }
    }

    public static void clear() {
        properties.clear();
    }

    private static FileInputStream getAlternateFileInputStream() {
        File previousFile = GenericRunInfo.getPreviousApplicationSettingsFile(APPLICATION_PREFERENCES_FILENAME);
        if (previousFile == null) {
            return null;
        }
        try {
            FileInputStream fis = new FileInputStream(previousFile);
            Msg.info(Preferences.class, (Object)("Loading previous preferences: " + previousFile));
            return fis;
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
    }

    public static String removeProperty(String name) {
        return (String)properties.remove(name);
    }

    public static String getProperty(String name) {
        String systemProperty = System.getProperty(name);
        if (systemProperty != null) {
            return systemProperty;
        }
        return properties.getProperty(name, null);
    }

    public static String getProperty(String name, String defaultValue) {
        String systemProperty = System.getProperty(name);
        if (systemProperty != null) {
            return systemProperty;
        }
        return properties.getProperty(name, defaultValue);
    }

    public static String getProperty(String name, String defaultValue, boolean useHistoricalValue) {
        String systemProperty = System.getProperty(name);
        if (systemProperty != null) {
            return systemProperty;
        }
        String currentValue = properties.getProperty(name);
        if (currentValue != null) {
            return currentValue;
        }
        if (!useHistoricalValue) {
            return defaultValue;
        }
        return previousProperties.getProperty(name, defaultValue);
    }

    public static void setProperty(String name, String value) {
        if (value == null) {
            Msg.trace(Preferences.class, (Object)("clearing property " + name));
            properties.remove(name);
            return;
        }
        Msg.trace(Preferences.class, (Object)("setting property " + name + "=" + value));
        properties.setProperty(name, value);
    }

    public static List<String> getPropertyNames() {
        Collection<String> backedCollection = CollectionUtils.asCollection(properties.keySet(), String.class);
        return new LinkedList<String>(backedCollection);
    }

    public static String getFilename() {
        return filename;
    }

    public static void setFilename(String name) {
        filename = name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean store() {
        if (filename == null) {
            throw new RuntimeException("Preferences filename has not been set!");
        }
        Msg.trace(Preferences.class, (Object)("Storing user preferences: " + filename));
        File file = new File(filename);
        if (!file.exists()) {
            FileUtilities.mkdirs((File)file.getParentFile());
        }
        FilterOutputStream os = null;
        try {
            os = new BufferedOutputStream(new FileOutputStream(filename));
            properties.store(os, "User Preferences");
            os.close();
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            Msg.error(Preferences.class, (Object)("Failed to store user preferences: " + filename));
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException iOException) {}
            }
        }
        return false;
    }

    public static String[] getPluginPaths() {
        List<String> list = Preferences.getPluginPathList();
        if (list == null) {
            return new String[0];
        }
        return list.toArray(new String[list.size()]);
    }

    public static void setPluginPaths(String[] paths) {
        if (paths == null || paths.length == 0) {
            properties.remove(USER_PLUGIN_PATH);
            return;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < paths.length; ++i) {
            sb.append(paths[i]);
            if (i >= paths.length - 1) continue;
            sb.append(File.pathSeparator);
        }
        properties.setProperty(USER_PLUGIN_PATH, sb.toString());
    }

    private static List<String> getPluginPathList() {
        String path = properties.getProperty(USER_PLUGIN_PATH);
        if (path == null) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>(5);
        StringTokenizer st = new StringTokenizer(path, File.pathSeparator);
        while (st.hasMoreElements()) {
            String p = (String)st.nextElement();
            list.add(p);
        }
        return list;
    }

    static {
        try {
            File userSettingsDir = Application.getUserSettingsDirectory();
            if (userSettingsDir != null) {
                Preferences.load(userSettingsDir.getAbsolutePath() + File.separatorChar + APPLICATION_PREFERENCES_FILENAME);
            }
        }
        catch (Exception e) {
            Msg.error(Preferences.class, (Object)"Unexpected exception reading preferences file: ", (Throwable)e);
        }
    }
}

