/*
 * Decompiled with CFR 0.152.
 */
package generic.concurrent.io;

import ghidra.util.Msg;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import utilities.util.reflection.ReflectionUtilities;
import utility.function.Dummy;

public class IOResult
implements Runnable {
    public static final String THREAD_POOL_NAME = "I/O Thread Pool";
    private List<String> outputLines = new ArrayList<String>();
    private BufferedReader commandOutput;
    private final Throwable inception;
    private Consumer<String> consumer = Dummy.consumer();

    public IOResult(InputStream input) {
        this(ReflectionUtilities.createThrowableWithStackOlderThan((Class[])new Class[]{IOResult.class}), input);
    }

    public IOResult(Throwable inception, InputStream input) {
        this.inception = inception;
        this.commandOutput = new BufferedReader(new InputStreamReader(input));
    }

    public void setConsumer(Consumer<String> consumer) {
        this.consumer = consumer;
    }

    public String getOutputAsString() {
        StringBuilder buffy = new StringBuilder();
        for (String line : this.outputLines) {
            buffy.append(line);
        }
        return buffy.toString();
    }

    public List<String> getOutput() {
        return this.outputLines;
    }

    @Override
    public void run() {
        String line = null;
        try {
            while ((line = this.commandOutput.readLine()) != null) {
                this.consumer.accept(line);
                this.outputLines.add(line);
            }
        }
        catch (Exception e) {
            String inceptionString = ReflectionUtilities.stackTraceToString((Throwable)this.inception);
            Msg.debug(IOResult.class, (Object)("Exception reading output from process.  Created from:\n" + inceptionString), (Throwable)e);
        }
    }
}

