/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.util;

import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jgrapht.Graph;
import org.jgrapht.GraphType;
import org.jgrapht.graph.DefaultGraphType;
import org.jgrapht.graph.DirectedPseudograph;
import org.jgrapht.graph.builder.GraphTypeBuilder;
import org.jgrapht.traverse.BreadthFirstIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TreeUtils {
    private static Logger log = LoggerFactory.getLogger(TreeUtils.class);

    public static <V> Set<V> roots(Graph<V, ?> graph) {
        Objects.requireNonNull(graph, "graph");
        return graph.vertexSet().stream().filter(vertex -> graph.incomingEdgesOf(vertex).isEmpty()).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public static <V> boolean isForestShaped(Graph<V, ?> graph) {
        Objects.requireNonNull(graph, "graph");
        return graph.getType().isDirected() && !graph.getType().isAllowingCycles() && graph.vertexSet().stream().allMatch(vertex -> graph.incomingEdgesOf(vertex).size() <= 1);
    }

    public static <V, E> Graph<V, E> getSubTree(Graph<V, E> tree, V root) {
        Objects.requireNonNull(tree, "tree");
        Objects.requireNonNull(root, "root");
        Objects.requireNonNull(Boolean.valueOf(tree.vertexSet().contains(root)), "Input tree does not contain the input subtree root");
        DirectedPseudograph subtree = (DirectedPseudograph)GraphTypeBuilder.forGraphType((GraphType)DefaultGraphType.directedPseudograph()).buildGraph();
        TreeUtils.growSubTree(tree, subtree, root);
        return subtree;
    }

    public static <V, E> void growSubTree(Graph<V, E> tree, Graph<V, E> subTree, V root) {
        Objects.requireNonNull(tree, "tree");
        Objects.requireNonNull(subTree, "subTree");
        Objects.requireNonNull(root, "root");
        for (Object edge : tree.outgoingEdgesOf(root)) {
            Object kid = tree.getEdgeTarget(edge);
            subTree.addVertex(root);
            subTree.addVertex(kid);
            subTree.addEdge(root, kid, edge);
            TreeUtils.growSubTree(tree, subTree, kid);
        }
    }

    public static <V, E> void addSubTree(Graph<V, E> tree, Graph<V, E> subTree, V subTreeParent, E connectingEdge) {
        Objects.requireNonNull(tree, "tree");
        Objects.requireNonNull(subTree, "subTree");
        Objects.requireNonNull(subTreeParent, "subTreeParent");
        Objects.requireNonNull(connectingEdge, "connectingEdge");
        Objects.requireNonNull(Boolean.valueOf(tree.vertexSet().contains(subTreeParent)), "'tree' does not contain 'subTreeParent'");
        Set<V> roots = TreeUtils.roots(subTree);
        log.trace("ast roots of {} is {}", subTree, roots);
        if (roots.isEmpty()) {
            return;
        }
        for (V subTreeRoot : roots) {
            log.trace("ast add {} to \n{}", subTreeParent, tree);
            tree.addVertex(subTreeParent);
            log.trace("ast add {} to \n{}", subTreeRoot, tree);
            tree.addVertex(subTreeRoot);
            log.trace("ast addEdge {} {} {} to \n{}", new Object[]{subTreeParent, subTreeRoot, connectingEdge, tree});
            tree.addEdge(subTreeParent, subTreeRoot, connectingEdge);
            TreeUtils.addFromSubTree(tree, subTree, subTreeRoot);
        }
    }

    private static <V, E> void addFromSubTree(Graph<V, E> tree, Graph<V, E> subTree, V subTreeRoot) {
        Objects.requireNonNull(tree, "tree");
        Objects.requireNonNull(subTree, "subTree");
        Objects.requireNonNull(subTreeRoot, "subTreeRoot");
        for (Object edge : subTree.outgoingEdgesOf(subTreeRoot)) {
            Object child = subTree.getEdgeTarget(edge);
            log.trace("addVertex {} to \n{}", subTreeRoot, tree);
            tree.addVertex(subTreeRoot);
            log.trace("addVertex {} to \n{}", child, tree);
            tree.addVertex(child);
            log.trace("addEdge {} {} {} \n to {}", new Object[]{subTreeRoot, child, edge, tree});
            tree.addEdge(subTreeRoot, child, edge);
            TreeUtils.addFromSubTree(tree, subTree, child);
        }
    }

    public static <V, E> void removeTreeVertex(Graph<V, E> tree, V subRoot) {
        BreadthFirstIterator iterator = new BreadthFirstIterator(tree, subRoot);
        while (iterator.hasNext()) {
            Object loser = iterator.next();
            tree.removeVertex(loser);
        }
        tree.removeVertex(subRoot);
    }
}

