/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.renderers;

import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.util.function.BiFunction;
import org.jgrapht.Graph;
import org.jungrapht.visualization.RenderContext;
import org.jungrapht.visualization.layout.model.LayoutModel;
import org.jungrapht.visualization.renderers.AbstractEdgeRenderer;
import org.jungrapht.visualization.renderers.CenterEdgeArrowRenderingSupport;
import org.jungrapht.visualization.renderers.DefaultEdgeArrowRenderingSupport;
import org.jungrapht.visualization.renderers.EdgeArrowRenderingSupport;
import org.jungrapht.visualization.renderers.Renderer;
import org.jungrapht.visualization.transform.shape.GraphicsDecorator;

public class HeavyweightEdgeRenderer<V, E>
extends AbstractEdgeRenderer<V, E>
implements Renderer.Edge<V, E> {
    protected EdgeArrowRenderingSupport<V, E> edgeArrowRenderingSupport = this.getPreferredEdgeArrowRenderingSupport();

    private EdgeArrowRenderingSupport<V, E> getPreferredEdgeArrowRenderingSupport() {
        switch (System.getProperty("jungrapht.edgeArrowPlacement", "ENDPOINTS")) {
            case "CENTER": {
                return new CenterEdgeArrowRenderingSupport();
            }
        }
        return new DefaultEdgeArrowRenderingSupport();
    }

    @Override
    protected Shape getEdgeShape(BiFunction<Graph<V, E>, E, Shape> edgeShapeFunction, E edge, Graph<V, E> graph) {
        return edgeShapeFunction.apply(graph, edge);
    }

    @Override
    protected void drawSimpleEdge(RenderContext<V, E> renderContext, LayoutModel<V> layoutModel, E e) {
        Paint draw_paint;
        Graphics2D g2d = renderContext.getGraphicsContext().getDelegate();
        Stroke savedStroke = g2d.getStroke();
        float savedStrokeWidth = renderContext.getEdgeWidth();
        g2d.setStroke(new BasicStroke(Math.max(savedStrokeWidth, (float)((int)(1.0 / g2d.getTransform().getScaleX())))));
        int[] coords = new int[4];
        boolean[] loop = new boolean[1];
        Shape edgeShape = this.prepareFinalEdgeShape(renderContext, layoutModel, e, coords, loop);
        int x1 = coords[0];
        int y1 = coords[1];
        int x2 = coords[2];
        int y2 = coords[3];
        boolean isLoop = loop[0];
        GraphicsDecorator g = renderContext.getGraphicsContext();
        Graph graph = layoutModel.getGraph();
        Paint oldPaint = g.getPaint();
        Paint fill_paint = renderContext.getEdgeFillPaintFunction().apply(e);
        if (fill_paint != null) {
            g.setPaint(fill_paint);
            g.fill(edgeShape);
        }
        if ((draw_paint = renderContext.getEdgeDrawPaintFunction().apply(e)) != null) {
            g.setPaint(draw_paint);
            g.draw(edgeShape);
        }
        float scalex = (float)g.getTransform().getScaleX();
        float scaley = (float)g.getTransform().getScaleY();
        if ((double)scalex < 0.3 || (double)scaley < 0.3) {
            return;
        }
        if (renderContext.renderEdgeArrow()) {
            Stroke new_stroke = renderContext.getEdgeArrowStrokeFunction().apply(e);
            Stroke old_stroke = g.getStroke();
            if (new_stroke != null) {
                g.setStroke(new_stroke);
            }
            Shape destVertexShape = renderContext.getVertexShapeFunction().apply(graph.getEdgeTarget(e));
            AffineTransform xf = AffineTransform.getTranslateInstance(x2, y2);
            destVertexShape = xf.createTransformedShape(destVertexShape);
            AffineTransform at = this.edgeArrowRenderingSupport.getArrowTransform(renderContext, edgeShape, destVertexShape);
            if (at == null) {
                return;
            }
            Shape arrow = renderContext.getEdgeArrow();
            arrow = at.createTransformedShape(arrow);
            g.setPaint(renderContext.getArrowFillPaintFunction().apply(e));
            g.fill(arrow);
            g.setPaint(renderContext.getArrowDrawPaintFunction().apply(e));
            g.draw(arrow);
            if (!graph.getType().isDirected()) {
                Shape vertexShape = renderContext.getVertexShapeFunction().apply(graph.getEdgeSource(e));
                xf = AffineTransform.getTranslateInstance(x1, y1);
                vertexShape = xf.createTransformedShape(vertexShape);
                at = this.edgeArrowRenderingSupport.getReverseArrowTransform(renderContext, edgeShape, vertexShape, !isLoop);
                if (at == null) {
                    return;
                }
                arrow = renderContext.getEdgeArrow();
                arrow = at.createTransformedShape(arrow);
                g.setPaint(renderContext.getArrowFillPaintFunction().apply(e));
                g.fill(arrow);
                g.setPaint(renderContext.getArrowDrawPaintFunction().apply(e));
                g.draw(arrow);
            }
            if (new_stroke != null) {
                g.setStroke(old_stroke);
            }
        }
        g.setPaint(oldPaint);
        g2d.setStroke(savedStroke);
    }

    @Override
    public EdgeArrowRenderingSupport<V, E> getEdgeArrowRenderingSupport() {
        return this.edgeArrowRenderingSupport;
    }

    @Override
    public void setEdgeArrowRenderingSupport(EdgeArrowRenderingSupport<V, E> edgeArrowRenderingSupport) {
        this.edgeArrowRenderingSupport = edgeArrowRenderingSupport;
    }
}

